// Code generated by go-swagger; DO NOT EDIT.

package real_time_response_admin

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRTRCreateScriptsParams creates a new RTRCreateScriptsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRTRCreateScriptsParams() *RTRCreateScriptsParams {
	return &RTRCreateScriptsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRTRCreateScriptsParamsWithTimeout creates a new RTRCreateScriptsParams object
// with the ability to set a timeout on a request.
func NewRTRCreateScriptsParamsWithTimeout(timeout time.Duration) *RTRCreateScriptsParams {
	return &RTRCreateScriptsParams{
		timeout: timeout,
	}
}

// NewRTRCreateScriptsParamsWithContext creates a new RTRCreateScriptsParams object
// with the ability to set a context for a request.
func NewRTRCreateScriptsParamsWithContext(ctx context.Context) *RTRCreateScriptsParams {
	return &RTRCreateScriptsParams{
		Context: ctx,
	}
}

// NewRTRCreateScriptsParamsWithHTTPClient creates a new RTRCreateScriptsParams object
// with the ability to set a custom HTTPClient for a request.
func NewRTRCreateScriptsParamsWithHTTPClient(client *http.Client) *RTRCreateScriptsParams {
	return &RTRCreateScriptsParams{
		HTTPClient: client,
	}
}

/*
RTRCreateScriptsParams contains all the parameters to send to the API endpoint

	for the r t r create scripts operation.

	Typically these are written to a http.Request.
*/
type RTRCreateScriptsParams struct {

	/* CommentsForAuditLog.

	   The audit log comment
	*/
	CommentsForAuditLog *string

	/* Content.

	   The script text that you want to use to upload
	*/
	Content *string

	/* Description.

	   File description
	*/
	Description string

	/* File.

	   custom-script file to upload.  These should be powershell scripts.
	*/
	File runtime.NamedReadCloser

	/* Name.

	   File name (if different than actual file name)
	*/
	Name *string

	/* PermissionType.

	    Permission for the custom-script. Valid permission values:
	- `private`, usable by only the user who uploaded it
	- `group`, usable by all RTR Admins
	- `public`, usable by all active-responders and RTR admins

	    Default: "none"
	*/
	PermissionType string

	/* Platform.

	   Platforms for the file. Currently supports: windows, mac, linux, . If no platform is provided, it will default to 'windows'
	*/
	Platform []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the r t r create scripts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRCreateScriptsParams) WithDefaults() *RTRCreateScriptsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the r t r create scripts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RTRCreateScriptsParams) SetDefaults() {
	var (
		permissionTypeDefault = string("none")
	)

	val := RTRCreateScriptsParams{
		PermissionType: permissionTypeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithTimeout(timeout time.Duration) *RTRCreateScriptsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithContext(ctx context.Context) *RTRCreateScriptsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithHTTPClient(client *http.Client) *RTRCreateScriptsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCommentsForAuditLog adds the commentsForAuditLog to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithCommentsForAuditLog(commentsForAuditLog *string) *RTRCreateScriptsParams {
	o.SetCommentsForAuditLog(commentsForAuditLog)
	return o
}

// SetCommentsForAuditLog adds the commentsForAuditLog to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetCommentsForAuditLog(commentsForAuditLog *string) {
	o.CommentsForAuditLog = commentsForAuditLog
}

// WithContent adds the content to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithContent(content *string) *RTRCreateScriptsParams {
	o.SetContent(content)
	return o
}

// SetContent adds the content to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetContent(content *string) {
	o.Content = content
}

// WithDescription adds the description to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithDescription(description string) *RTRCreateScriptsParams {
	o.SetDescription(description)
	return o
}

// SetDescription adds the description to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetDescription(description string) {
	o.Description = description
}

// WithFile adds the file to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithFile(file runtime.NamedReadCloser) *RTRCreateScriptsParams {
	o.SetFile(file)
	return o
}

// SetFile adds the file to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetFile(file runtime.NamedReadCloser) {
	o.File = file
}

// WithName adds the name to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithName(name *string) *RTRCreateScriptsParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetName(name *string) {
	o.Name = name
}

// WithPermissionType adds the permissionType to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithPermissionType(permissionType string) *RTRCreateScriptsParams {
	o.SetPermissionType(permissionType)
	return o
}

// SetPermissionType adds the permissionType to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetPermissionType(permissionType string) {
	o.PermissionType = permissionType
}

// WithPlatform adds the platform to the r t r create scripts params
func (o *RTRCreateScriptsParams) WithPlatform(platform []string) *RTRCreateScriptsParams {
	o.SetPlatform(platform)
	return o
}

// SetPlatform adds the platform to the r t r create scripts params
func (o *RTRCreateScriptsParams) SetPlatform(platform []string) {
	o.Platform = platform
}

// WriteToRequest writes these params to a swagger request
func (o *RTRCreateScriptsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CommentsForAuditLog != nil {

		// form param comments_for_audit_log
		var frCommentsForAuditLog string
		if o.CommentsForAuditLog != nil {
			frCommentsForAuditLog = *o.CommentsForAuditLog
		}
		fCommentsForAuditLog := frCommentsForAuditLog
		if fCommentsForAuditLog != "" {
			if err := r.SetFormParam("comments_for_audit_log", fCommentsForAuditLog); err != nil {
				return err
			}
		}
	}

	if o.Content != nil {

		// form param content
		var frContent string
		if o.Content != nil {
			frContent = *o.Content
		}
		fContent := frContent
		if fContent != "" {
			if err := r.SetFormParam("content", fContent); err != nil {
				return err
			}
		}
	}

	// form param description
	frDescription := o.Description
	fDescription := frDescription
	if fDescription != "" {
		if err := r.SetFormParam("description", fDescription); err != nil {
			return err
		}
	}

	if o.File != nil {

		if o.File != nil {
			// form file param file
			if err := r.SetFileParam("file", o.File); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// form param name
		var frName string
		if o.Name != nil {
			frName = *o.Name
		}
		fName := frName
		if fName != "" {
			if err := r.SetFormParam("name", fName); err != nil {
				return err
			}
		}
	}

	// form param permission_type
	frPermissionType := o.PermissionType
	fPermissionType := frPermissionType
	if fPermissionType != "" {
		if err := r.SetFormParam("permission_type", fPermissionType); err != nil {
			return err
		}
	}

	if o.Platform != nil {

		// binding items for platform
		joinedPlatform := o.bindParamPlatform(reg)

		// form array param platform
		if err := r.SetFormParam("platform", joinedPlatform...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamRTRCreateScripts binds the parameter platform
func (o *RTRCreateScriptsParams) bindParamPlatform(formats strfmt.Registry) []string {
	platformIR := o.Platform

	var platformIC []string
	for _, platformIIR := range platformIR { // explode []string

		platformIIV := platformIIR // string as string
		platformIC = append(platformIC, platformIIV)
	}

	// items.CollectionFormat: "multi"
	platformIS := swag.JoinByFormat(platformIC, "multi")

	return platformIS
}
