// Code generated by go-swagger; DO NOT EDIT.

package real_time_response_admin

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RTRCreateScriptsReader is a Reader for the RTRCreateScripts structure.
type RTRCreateScriptsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RTRCreateScriptsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRTRCreateScriptsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRTRCreateScriptsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRTRCreateScriptsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRTRCreateScriptsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /real-time-response/entities/scripts/v1] RTR-CreateScripts", response, response.Code())
	}
}

// NewRTRCreateScriptsOK creates a RTRCreateScriptsOK with default headers values
func NewRTRCreateScriptsOK() *RTRCreateScriptsOK {
	return &RTRCreateScriptsOK{}
}

/*
RTRCreateScriptsOK describes a response with status code 200, with default header values.

OK
*/
type RTRCreateScriptsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r create scripts o k response has a 2xx status code
func (o *RTRCreateScriptsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this r t r create scripts o k response has a 3xx status code
func (o *RTRCreateScriptsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r create scripts o k response has a 4xx status code
func (o *RTRCreateScriptsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this r t r create scripts o k response has a 5xx status code
func (o *RTRCreateScriptsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r create scripts o k response a status code equal to that given
func (o *RTRCreateScriptsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the r t r create scripts o k response
func (o *RTRCreateScriptsOK) Code() int {
	return 200
}

func (o *RTRCreateScriptsOK) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/scripts/v1][%d] rTRCreateScriptsOK  %+v", 200, o.Payload)
}

func (o *RTRCreateScriptsOK) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/scripts/v1][%d] rTRCreateScriptsOK  %+v", 200, o.Payload)
}

func (o *RTRCreateScriptsOK) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRCreateScriptsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRCreateScriptsBadRequest creates a RTRCreateScriptsBadRequest with default headers values
func NewRTRCreateScriptsBadRequest() *RTRCreateScriptsBadRequest {
	return &RTRCreateScriptsBadRequest{}
}

/*
RTRCreateScriptsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RTRCreateScriptsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r create scripts bad request response has a 2xx status code
func (o *RTRCreateScriptsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r create scripts bad request response has a 3xx status code
func (o *RTRCreateScriptsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r create scripts bad request response has a 4xx status code
func (o *RTRCreateScriptsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r create scripts bad request response has a 5xx status code
func (o *RTRCreateScriptsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r create scripts bad request response a status code equal to that given
func (o *RTRCreateScriptsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the r t r create scripts bad request response
func (o *RTRCreateScriptsBadRequest) Code() int {
	return 400
}

func (o *RTRCreateScriptsBadRequest) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/scripts/v1][%d] rTRCreateScriptsBadRequest  %+v", 400, o.Payload)
}

func (o *RTRCreateScriptsBadRequest) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/scripts/v1][%d] rTRCreateScriptsBadRequest  %+v", 400, o.Payload)
}

func (o *RTRCreateScriptsBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRCreateScriptsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRCreateScriptsForbidden creates a RTRCreateScriptsForbidden with default headers values
func NewRTRCreateScriptsForbidden() *RTRCreateScriptsForbidden {
	return &RTRCreateScriptsForbidden{}
}

/*
RTRCreateScriptsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RTRCreateScriptsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r create scripts forbidden response has a 2xx status code
func (o *RTRCreateScriptsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r create scripts forbidden response has a 3xx status code
func (o *RTRCreateScriptsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r create scripts forbidden response has a 4xx status code
func (o *RTRCreateScriptsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r create scripts forbidden response has a 5xx status code
func (o *RTRCreateScriptsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r create scripts forbidden response a status code equal to that given
func (o *RTRCreateScriptsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the r t r create scripts forbidden response
func (o *RTRCreateScriptsForbidden) Code() int {
	return 403
}

func (o *RTRCreateScriptsForbidden) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/scripts/v1][%d] rTRCreateScriptsForbidden  %+v", 403, o.Payload)
}

func (o *RTRCreateScriptsForbidden) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/scripts/v1][%d] rTRCreateScriptsForbidden  %+v", 403, o.Payload)
}

func (o *RTRCreateScriptsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRCreateScriptsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRCreateScriptsTooManyRequests creates a RTRCreateScriptsTooManyRequests with default headers values
func NewRTRCreateScriptsTooManyRequests() *RTRCreateScriptsTooManyRequests {
	return &RTRCreateScriptsTooManyRequests{}
}

/*
RTRCreateScriptsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RTRCreateScriptsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r create scripts too many requests response has a 2xx status code
func (o *RTRCreateScriptsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r create scripts too many requests response has a 3xx status code
func (o *RTRCreateScriptsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r create scripts too many requests response has a 4xx status code
func (o *RTRCreateScriptsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r create scripts too many requests response has a 5xx status code
func (o *RTRCreateScriptsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r create scripts too many requests response a status code equal to that given
func (o *RTRCreateScriptsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the r t r create scripts too many requests response
func (o *RTRCreateScriptsTooManyRequests) Code() int {
	return 429
}

func (o *RTRCreateScriptsTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /real-time-response/entities/scripts/v1][%d] rTRCreateScriptsTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRCreateScriptsTooManyRequests) String() string {
	return fmt.Sprintf("[POST /real-time-response/entities/scripts/v1][%d] rTRCreateScriptsTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRCreateScriptsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRCreateScriptsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
