// Code generated by go-swagger; DO NOT EDIT.

package real_time_response_admin

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RTRGetPutFilesReader is a Reader for the RTRGetPutFiles structure.
type RTRGetPutFilesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RTRGetPutFilesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRTRGetPutFilesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRTRGetPutFilesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRTRGetPutFilesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRTRGetPutFilesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRTRGetPutFilesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /real-time-response/entities/put-files/v1] RTR-GetPut-Files", response, response.Code())
	}
}

// NewRTRGetPutFilesOK creates a RTRGetPutFilesOK with default headers values
func NewRTRGetPutFilesOK() *RTRGetPutFilesOK {
	return &RTRGetPutFilesOK{}
}

/*
RTRGetPutFilesOK describes a response with status code 200, with default header values.

OK
*/
type RTRGetPutFilesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.EmpowerapiMsaPFResponseV1
}

// IsSuccess returns true when this r t r get put files o k response has a 2xx status code
func (o *RTRGetPutFilesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this r t r get put files o k response has a 3xx status code
func (o *RTRGetPutFilesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get put files o k response has a 4xx status code
func (o *RTRGetPutFilesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this r t r get put files o k response has a 5xx status code
func (o *RTRGetPutFilesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get put files o k response a status code equal to that given
func (o *RTRGetPutFilesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the r t r get put files o k response
func (o *RTRGetPutFilesOK) Code() int {
	return 200
}

func (o *RTRGetPutFilesOK) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesOK  %+v", 200, o.Payload)
}

func (o *RTRGetPutFilesOK) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesOK  %+v", 200, o.Payload)
}

func (o *RTRGetPutFilesOK) GetPayload() *models.EmpowerapiMsaPFResponseV1 {
	return o.Payload
}

func (o *RTRGetPutFilesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.EmpowerapiMsaPFResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetPutFilesBadRequest creates a RTRGetPutFilesBadRequest with default headers values
func NewRTRGetPutFilesBadRequest() *RTRGetPutFilesBadRequest {
	return &RTRGetPutFilesBadRequest{}
}

/*
RTRGetPutFilesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RTRGetPutFilesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r get put files bad request response has a 2xx status code
func (o *RTRGetPutFilesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get put files bad request response has a 3xx status code
func (o *RTRGetPutFilesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get put files bad request response has a 4xx status code
func (o *RTRGetPutFilesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get put files bad request response has a 5xx status code
func (o *RTRGetPutFilesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get put files bad request response a status code equal to that given
func (o *RTRGetPutFilesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the r t r get put files bad request response
func (o *RTRGetPutFilesBadRequest) Code() int {
	return 400
}

func (o *RTRGetPutFilesBadRequest) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesBadRequest  %+v", 400, o.Payload)
}

func (o *RTRGetPutFilesBadRequest) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesBadRequest  %+v", 400, o.Payload)
}

func (o *RTRGetPutFilesBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRGetPutFilesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetPutFilesForbidden creates a RTRGetPutFilesForbidden with default headers values
func NewRTRGetPutFilesForbidden() *RTRGetPutFilesForbidden {
	return &RTRGetPutFilesForbidden{}
}

/*
RTRGetPutFilesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RTRGetPutFilesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r get put files forbidden response has a 2xx status code
func (o *RTRGetPutFilesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get put files forbidden response has a 3xx status code
func (o *RTRGetPutFilesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get put files forbidden response has a 4xx status code
func (o *RTRGetPutFilesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get put files forbidden response has a 5xx status code
func (o *RTRGetPutFilesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get put files forbidden response a status code equal to that given
func (o *RTRGetPutFilesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the r t r get put files forbidden response
func (o *RTRGetPutFilesForbidden) Code() int {
	return 403
}

func (o *RTRGetPutFilesForbidden) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesForbidden  %+v", 403, o.Payload)
}

func (o *RTRGetPutFilesForbidden) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesForbidden  %+v", 403, o.Payload)
}

func (o *RTRGetPutFilesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRGetPutFilesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetPutFilesNotFound creates a RTRGetPutFilesNotFound with default headers values
func NewRTRGetPutFilesNotFound() *RTRGetPutFilesNotFound {
	return &RTRGetPutFilesNotFound{}
}

/*
RTRGetPutFilesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type RTRGetPutFilesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r get put files not found response has a 2xx status code
func (o *RTRGetPutFilesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get put files not found response has a 3xx status code
func (o *RTRGetPutFilesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get put files not found response has a 4xx status code
func (o *RTRGetPutFilesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get put files not found response has a 5xx status code
func (o *RTRGetPutFilesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get put files not found response a status code equal to that given
func (o *RTRGetPutFilesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the r t r get put files not found response
func (o *RTRGetPutFilesNotFound) Code() int {
	return 404
}

func (o *RTRGetPutFilesNotFound) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesNotFound  %+v", 404, o.Payload)
}

func (o *RTRGetPutFilesNotFound) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesNotFound  %+v", 404, o.Payload)
}

func (o *RTRGetPutFilesNotFound) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRGetPutFilesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetPutFilesTooManyRequests creates a RTRGetPutFilesTooManyRequests with default headers values
func NewRTRGetPutFilesTooManyRequests() *RTRGetPutFilesTooManyRequests {
	return &RTRGetPutFilesTooManyRequests{}
}

/*
RTRGetPutFilesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RTRGetPutFilesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r get put files too many requests response has a 2xx status code
func (o *RTRGetPutFilesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get put files too many requests response has a 3xx status code
func (o *RTRGetPutFilesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get put files too many requests response has a 4xx status code
func (o *RTRGetPutFilesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get put files too many requests response has a 5xx status code
func (o *RTRGetPutFilesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get put files too many requests response a status code equal to that given
func (o *RTRGetPutFilesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the r t r get put files too many requests response
func (o *RTRGetPutFilesTooManyRequests) Code() int {
	return 429
}

func (o *RTRGetPutFilesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRGetPutFilesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/put-files/v1][%d] rTRGetPutFilesTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRGetPutFilesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRGetPutFilesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
