// Code generated by go-swagger; DO NOT EDIT.

package real_time_response_admin

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RTRGetScriptsReader is a Reader for the RTRGetScripts structure.
type RTRGetScriptsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RTRGetScriptsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRTRGetScriptsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRTRGetScriptsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRTRGetScriptsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRTRGetScriptsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRTRGetScriptsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /real-time-response/entities/scripts/v1] RTR-GetScripts", response, response.Code())
	}
}

// NewRTRGetScriptsOK creates a RTRGetScriptsOK with default headers values
func NewRTRGetScriptsOK() *RTRGetScriptsOK {
	return &RTRGetScriptsOK{}
}

/*
RTRGetScriptsOK describes a response with status code 200, with default header values.

OK
*/
type RTRGetScriptsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.EmpowerapiMsaPFResponseV1
}

// IsSuccess returns true when this r t r get scripts o k response has a 2xx status code
func (o *RTRGetScriptsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this r t r get scripts o k response has a 3xx status code
func (o *RTRGetScriptsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts o k response has a 4xx status code
func (o *RTRGetScriptsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this r t r get scripts o k response has a 5xx status code
func (o *RTRGetScriptsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts o k response a status code equal to that given
func (o *RTRGetScriptsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the r t r get scripts o k response
func (o *RTRGetScriptsOK) Code() int {
	return 200
}

func (o *RTRGetScriptsOK) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsOK  %+v", 200, o.Payload)
}

func (o *RTRGetScriptsOK) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsOK  %+v", 200, o.Payload)
}

func (o *RTRGetScriptsOK) GetPayload() *models.EmpowerapiMsaPFResponseV1 {
	return o.Payload
}

func (o *RTRGetScriptsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.EmpowerapiMsaPFResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetScriptsBadRequest creates a RTRGetScriptsBadRequest with default headers values
func NewRTRGetScriptsBadRequest() *RTRGetScriptsBadRequest {
	return &RTRGetScriptsBadRequest{}
}

/*
RTRGetScriptsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RTRGetScriptsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r get scripts bad request response has a 2xx status code
func (o *RTRGetScriptsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get scripts bad request response has a 3xx status code
func (o *RTRGetScriptsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts bad request response has a 4xx status code
func (o *RTRGetScriptsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get scripts bad request response has a 5xx status code
func (o *RTRGetScriptsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts bad request response a status code equal to that given
func (o *RTRGetScriptsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the r t r get scripts bad request response
func (o *RTRGetScriptsBadRequest) Code() int {
	return 400
}

func (o *RTRGetScriptsBadRequest) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsBadRequest  %+v", 400, o.Payload)
}

func (o *RTRGetScriptsBadRequest) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsBadRequest  %+v", 400, o.Payload)
}

func (o *RTRGetScriptsBadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRGetScriptsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetScriptsForbidden creates a RTRGetScriptsForbidden with default headers values
func NewRTRGetScriptsForbidden() *RTRGetScriptsForbidden {
	return &RTRGetScriptsForbidden{}
}

/*
RTRGetScriptsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RTRGetScriptsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r get scripts forbidden response has a 2xx status code
func (o *RTRGetScriptsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get scripts forbidden response has a 3xx status code
func (o *RTRGetScriptsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts forbidden response has a 4xx status code
func (o *RTRGetScriptsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get scripts forbidden response has a 5xx status code
func (o *RTRGetScriptsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts forbidden response a status code equal to that given
func (o *RTRGetScriptsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the r t r get scripts forbidden response
func (o *RTRGetScriptsForbidden) Code() int {
	return 403
}

func (o *RTRGetScriptsForbidden) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsForbidden  %+v", 403, o.Payload)
}

func (o *RTRGetScriptsForbidden) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsForbidden  %+v", 403, o.Payload)
}

func (o *RTRGetScriptsForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRGetScriptsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetScriptsNotFound creates a RTRGetScriptsNotFound with default headers values
func NewRTRGetScriptsNotFound() *RTRGetScriptsNotFound {
	return &RTRGetScriptsNotFound{}
}

/*
RTRGetScriptsNotFound describes a response with status code 404, with default header values.

Not Found
*/
type RTRGetScriptsNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r get scripts not found response has a 2xx status code
func (o *RTRGetScriptsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get scripts not found response has a 3xx status code
func (o *RTRGetScriptsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts not found response has a 4xx status code
func (o *RTRGetScriptsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get scripts not found response has a 5xx status code
func (o *RTRGetScriptsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts not found response a status code equal to that given
func (o *RTRGetScriptsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the r t r get scripts not found response
func (o *RTRGetScriptsNotFound) Code() int {
	return 404
}

func (o *RTRGetScriptsNotFound) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsNotFound  %+v", 404, o.Payload)
}

func (o *RTRGetScriptsNotFound) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsNotFound  %+v", 404, o.Payload)
}

func (o *RTRGetScriptsNotFound) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRGetScriptsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetScriptsTooManyRequests creates a RTRGetScriptsTooManyRequests with default headers values
func NewRTRGetScriptsTooManyRequests() *RTRGetScriptsTooManyRequests {
	return &RTRGetScriptsTooManyRequests{}
}

/*
RTRGetScriptsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RTRGetScriptsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r get scripts too many requests response has a 2xx status code
func (o *RTRGetScriptsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get scripts too many requests response has a 3xx status code
func (o *RTRGetScriptsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts too many requests response has a 4xx status code
func (o *RTRGetScriptsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get scripts too many requests response has a 5xx status code
func (o *RTRGetScriptsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts too many requests response a status code equal to that given
func (o *RTRGetScriptsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the r t r get scripts too many requests response
func (o *RTRGetScriptsTooManyRequests) Code() int {
	return 429
}

func (o *RTRGetScriptsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRGetScriptsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v1][%d] rTRGetScriptsTooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRGetScriptsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRGetScriptsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
