// Code generated by go-swagger; DO NOT EDIT.

package real_time_response_admin

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// RTRGetScriptsV2Reader is a Reader for the RTRGetScriptsV2 structure.
type RTRGetScriptsV2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RTRGetScriptsV2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRTRGetScriptsV2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewRTRGetScriptsV2BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewRTRGetScriptsV2Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewRTRGetScriptsV2NotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewRTRGetScriptsV2TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /real-time-response/entities/scripts/v2] RTR-GetScriptsV2", response, response.Code())
	}
}

// NewRTRGetScriptsV2OK creates a RTRGetScriptsV2OK with default headers values
func NewRTRGetScriptsV2OK() *RTRGetScriptsV2OK {
	return &RTRGetScriptsV2OK{}
}

/*
RTRGetScriptsV2OK describes a response with status code 200, with default header values.

OK
*/
type RTRGetScriptsV2OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.EmpowerapiMsaPFResponseV2
}

// IsSuccess returns true when this r t r get scripts v2 o k response has a 2xx status code
func (o *RTRGetScriptsV2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this r t r get scripts v2 o k response has a 3xx status code
func (o *RTRGetScriptsV2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts v2 o k response has a 4xx status code
func (o *RTRGetScriptsV2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this r t r get scripts v2 o k response has a 5xx status code
func (o *RTRGetScriptsV2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts v2 o k response a status code equal to that given
func (o *RTRGetScriptsV2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the r t r get scripts v2 o k response
func (o *RTRGetScriptsV2OK) Code() int {
	return 200
}

func (o *RTRGetScriptsV2OK) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2OK  %+v", 200, o.Payload)
}

func (o *RTRGetScriptsV2OK) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2OK  %+v", 200, o.Payload)
}

func (o *RTRGetScriptsV2OK) GetPayload() *models.EmpowerapiMsaPFResponseV2 {
	return o.Payload
}

func (o *RTRGetScriptsV2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.EmpowerapiMsaPFResponseV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetScriptsV2BadRequest creates a RTRGetScriptsV2BadRequest with default headers values
func NewRTRGetScriptsV2BadRequest() *RTRGetScriptsV2BadRequest {
	return &RTRGetScriptsV2BadRequest{}
}

/*
RTRGetScriptsV2BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type RTRGetScriptsV2BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r get scripts v2 bad request response has a 2xx status code
func (o *RTRGetScriptsV2BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get scripts v2 bad request response has a 3xx status code
func (o *RTRGetScriptsV2BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts v2 bad request response has a 4xx status code
func (o *RTRGetScriptsV2BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get scripts v2 bad request response has a 5xx status code
func (o *RTRGetScriptsV2BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts v2 bad request response a status code equal to that given
func (o *RTRGetScriptsV2BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the r t r get scripts v2 bad request response
func (o *RTRGetScriptsV2BadRequest) Code() int {
	return 400
}

func (o *RTRGetScriptsV2BadRequest) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2BadRequest  %+v", 400, o.Payload)
}

func (o *RTRGetScriptsV2BadRequest) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2BadRequest  %+v", 400, o.Payload)
}

func (o *RTRGetScriptsV2BadRequest) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRGetScriptsV2BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetScriptsV2Forbidden creates a RTRGetScriptsV2Forbidden with default headers values
func NewRTRGetScriptsV2Forbidden() *RTRGetScriptsV2Forbidden {
	return &RTRGetScriptsV2Forbidden{}
}

/*
RTRGetScriptsV2Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type RTRGetScriptsV2Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r get scripts v2 forbidden response has a 2xx status code
func (o *RTRGetScriptsV2Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get scripts v2 forbidden response has a 3xx status code
func (o *RTRGetScriptsV2Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts v2 forbidden response has a 4xx status code
func (o *RTRGetScriptsV2Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get scripts v2 forbidden response has a 5xx status code
func (o *RTRGetScriptsV2Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts v2 forbidden response a status code equal to that given
func (o *RTRGetScriptsV2Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the r t r get scripts v2 forbidden response
func (o *RTRGetScriptsV2Forbidden) Code() int {
	return 403
}

func (o *RTRGetScriptsV2Forbidden) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2Forbidden  %+v", 403, o.Payload)
}

func (o *RTRGetScriptsV2Forbidden) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2Forbidden  %+v", 403, o.Payload)
}

func (o *RTRGetScriptsV2Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRGetScriptsV2Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetScriptsV2NotFound creates a RTRGetScriptsV2NotFound with default headers values
func NewRTRGetScriptsV2NotFound() *RTRGetScriptsV2NotFound {
	return &RTRGetScriptsV2NotFound{}
}

/*
RTRGetScriptsV2NotFound describes a response with status code 404, with default header values.

Not Found
*/
type RTRGetScriptsV2NotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAPIError
}

// IsSuccess returns true when this r t r get scripts v2 not found response has a 2xx status code
func (o *RTRGetScriptsV2NotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get scripts v2 not found response has a 3xx status code
func (o *RTRGetScriptsV2NotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts v2 not found response has a 4xx status code
func (o *RTRGetScriptsV2NotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get scripts v2 not found response has a 5xx status code
func (o *RTRGetScriptsV2NotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts v2 not found response a status code equal to that given
func (o *RTRGetScriptsV2NotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the r t r get scripts v2 not found response
func (o *RTRGetScriptsV2NotFound) Code() int {
	return 404
}

func (o *RTRGetScriptsV2NotFound) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2NotFound  %+v", 404, o.Payload)
}

func (o *RTRGetScriptsV2NotFound) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2NotFound  %+v", 404, o.Payload)
}

func (o *RTRGetScriptsV2NotFound) GetPayload() *models.DomainAPIError {
	return o.Payload
}

func (o *RTRGetScriptsV2NotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAPIError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRTRGetScriptsV2TooManyRequests creates a RTRGetScriptsV2TooManyRequests with default headers values
func NewRTRGetScriptsV2TooManyRequests() *RTRGetScriptsV2TooManyRequests {
	return &RTRGetScriptsV2TooManyRequests{}
}

/*
RTRGetScriptsV2TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type RTRGetScriptsV2TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this r t r get scripts v2 too many requests response has a 2xx status code
func (o *RTRGetScriptsV2TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this r t r get scripts v2 too many requests response has a 3xx status code
func (o *RTRGetScriptsV2TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this r t r get scripts v2 too many requests response has a 4xx status code
func (o *RTRGetScriptsV2TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this r t r get scripts v2 too many requests response has a 5xx status code
func (o *RTRGetScriptsV2TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this r t r get scripts v2 too many requests response a status code equal to that given
func (o *RTRGetScriptsV2TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the r t r get scripts v2 too many requests response
func (o *RTRGetScriptsV2TooManyRequests) Code() int {
	return 429
}

func (o *RTRGetScriptsV2TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRGetScriptsV2TooManyRequests) String() string {
	return fmt.Sprintf("[GET /real-time-response/entities/scripts/v2][%d] rTRGetScriptsV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *RTRGetScriptsV2TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *RTRGetScriptsV2TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
