// Code generated by go-swagger; DO NOT EDIT.

package real_time_response_admin

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new real time response admin API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for real time response admin API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	BatchAdminCmd(params *BatchAdminCmdParams, opts ...ClientOption) (*BatchAdminCmdCreated, error)

	RTRCheckAdminCommandStatus(params *RTRCheckAdminCommandStatusParams, opts ...ClientOption) (*RTRCheckAdminCommandStatusOK, error)

	RTRCreatePutFiles(params *RTRCreatePutFilesParams, opts ...ClientOption) (*RTRCreatePutFilesOK, error)

	RTRCreateScripts(params *RTRCreateScriptsParams, opts ...ClientOption) (*RTRCreateScriptsOK, error)

	RTRDeletePutFiles(params *RTRDeletePutFilesParams, opts ...ClientOption) (*RTRDeletePutFilesOK, error)

	RTRDeleteScripts(params *RTRDeleteScriptsParams, opts ...ClientOption) (*RTRDeleteScriptsOK, error)

	RTRExecuteAdminCommand(params *RTRExecuteAdminCommandParams, opts ...ClientOption) (*RTRExecuteAdminCommandCreated, error)

	RTRGetPutFiles(params *RTRGetPutFilesParams, opts ...ClientOption) (*RTRGetPutFilesOK, error)

	RTRGetPutFilesV2(params *RTRGetPutFilesV2Params, opts ...ClientOption) (*RTRGetPutFilesV2OK, error)

	RTRGetScripts(params *RTRGetScriptsParams, opts ...ClientOption) (*RTRGetScriptsOK, error)

	RTRGetScriptsV2(params *RTRGetScriptsV2Params, opts ...ClientOption) (*RTRGetScriptsV2OK, error)

	RTRListPutFiles(params *RTRListPutFilesParams, opts ...ClientOption) (*RTRListPutFilesOK, error)

	RTRListScripts(params *RTRListScriptsParams, opts ...ClientOption) (*RTRListScriptsOK, error)

	RTRUpdateScripts(params *RTRUpdateScriptsParams, opts ...ClientOption) (*RTRUpdateScriptsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
BatchAdminCmd batches executes a r t r administrator command across the hosts mapped to the given batch ID
*/
func (a *Client) BatchAdminCmd(params *BatchAdminCmdParams, opts ...ClientOption) (*BatchAdminCmdCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBatchAdminCmdParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "BatchAdminCmd",
		Method:             "POST",
		PathPattern:        "/real-time-response/combined/batch-admin-command/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BatchAdminCmdReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*BatchAdminCmdCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for BatchAdminCmd: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRCheckAdminCommandStatus gets status of an executed r t r administrator command on a single host
*/
func (a *Client) RTRCheckAdminCommandStatus(params *RTRCheckAdminCommandStatusParams, opts ...ClientOption) (*RTRCheckAdminCommandStatusOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRCheckAdminCommandStatusParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-CheckAdminCommandStatus",
		Method:             "GET",
		PathPattern:        "/real-time-response/entities/admin-command/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRCheckAdminCommandStatusReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRCheckAdminCommandStatusOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-CheckAdminCommandStatus: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRCreatePutFiles uploads a new put file to use for the r t r put command
*/
func (a *Client) RTRCreatePutFiles(params *RTRCreatePutFilesParams, opts ...ClientOption) (*RTRCreatePutFilesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRCreatePutFilesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-CreatePut-Files",
		Method:             "POST",
		PathPattern:        "/real-time-response/entities/put-files/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRCreatePutFilesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRCreatePutFilesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-CreatePut-Files: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRCreateScripts uploads a new custom script to use for the r t r runscript command
*/
func (a *Client) RTRCreateScripts(params *RTRCreateScriptsParams, opts ...ClientOption) (*RTRCreateScriptsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRCreateScriptsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-CreateScripts",
		Method:             "POST",
		PathPattern:        "/real-time-response/entities/scripts/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRCreateScriptsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRCreateScriptsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-CreateScripts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRDeletePutFiles deletes a put file based on the ID given can only delete one file at a time
*/
func (a *Client) RTRDeletePutFiles(params *RTRDeletePutFilesParams, opts ...ClientOption) (*RTRDeletePutFilesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRDeletePutFilesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-DeletePut-Files",
		Method:             "DELETE",
		PathPattern:        "/real-time-response/entities/put-files/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRDeletePutFilesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRDeletePutFilesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-DeletePut-Files: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRDeleteScripts deletes a custom script based on the ID given can only delete one script at a time
*/
func (a *Client) RTRDeleteScripts(params *RTRDeleteScriptsParams, opts ...ClientOption) (*RTRDeleteScriptsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRDeleteScriptsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-DeleteScripts",
		Method:             "DELETE",
		PathPattern:        "/real-time-response/entities/scripts/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRDeleteScriptsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRDeleteScriptsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-DeleteScripts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRExecuteAdminCommand executes a r t r administrator command on a single host
*/
func (a *Client) RTRExecuteAdminCommand(params *RTRExecuteAdminCommandParams, opts ...ClientOption) (*RTRExecuteAdminCommandCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRExecuteAdminCommandParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-ExecuteAdminCommand",
		Method:             "POST",
		PathPattern:        "/real-time-response/entities/admin-command/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRExecuteAdminCommandReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRExecuteAdminCommandCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-ExecuteAdminCommand: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRGetPutFiles gets put files based on the ID s given these are used for the r t r put command
*/
func (a *Client) RTRGetPutFiles(params *RTRGetPutFilesParams, opts ...ClientOption) (*RTRGetPutFilesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRGetPutFilesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-GetPut-Files",
		Method:             "GET",
		PathPattern:        "/real-time-response/entities/put-files/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRGetPutFilesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRGetPutFilesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-GetPut-Files: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRGetPutFilesV2 gets put files based on the ID s given these are used for the r t r put command
*/
func (a *Client) RTRGetPutFilesV2(params *RTRGetPutFilesV2Params, opts ...ClientOption) (*RTRGetPutFilesV2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRGetPutFilesV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-GetPut-FilesV2",
		Method:             "GET",
		PathPattern:        "/real-time-response/entities/put-files/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRGetPutFilesV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRGetPutFilesV2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-GetPut-FilesV2: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRGetScripts gets custom scripts based on the ID s given these are used for the r t r runscript command
*/
func (a *Client) RTRGetScripts(params *RTRGetScriptsParams, opts ...ClientOption) (*RTRGetScriptsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRGetScriptsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-GetScripts",
		Method:             "GET",
		PathPattern:        "/real-time-response/entities/scripts/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRGetScriptsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRGetScriptsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-GetScripts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRGetScriptsV2 gets custom scripts based on the ID s given these are used for the r t r runscript command
*/
func (a *Client) RTRGetScriptsV2(params *RTRGetScriptsV2Params, opts ...ClientOption) (*RTRGetScriptsV2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRGetScriptsV2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-GetScriptsV2",
		Method:             "GET",
		PathPattern:        "/real-time-response/entities/scripts/v2",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRGetScriptsV2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRGetScriptsV2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-GetScriptsV2: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRListPutFiles gets a list of put file ID s that are available to the user for the put command
*/
func (a *Client) RTRListPutFiles(params *RTRListPutFilesParams, opts ...ClientOption) (*RTRListPutFilesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRListPutFilesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-ListPut-Files",
		Method:             "GET",
		PathPattern:        "/real-time-response/queries/put-files/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRListPutFilesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRListPutFilesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-ListPut-Files: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRListScripts gets a list of custom script ID s that are available to the user for the runscript command
*/
func (a *Client) RTRListScripts(params *RTRListScriptsParams, opts ...ClientOption) (*RTRListScriptsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRListScriptsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-ListScripts",
		Method:             "GET",
		PathPattern:        "/real-time-response/queries/scripts/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRListScriptsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRListScriptsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-ListScripts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
RTRUpdateScripts uploads a new scripts to replace an existing one
*/
func (a *Client) RTRUpdateScripts(params *RTRUpdateScriptsParams, opts ...ClientOption) (*RTRUpdateScriptsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRTRUpdateScriptsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RTR-UpdateScripts",
		Method:             "PATCH",
		PathPattern:        "/real-time-response/entities/scripts/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"multipart/form-data"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RTRUpdateScriptsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RTRUpdateScriptsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for RTR-UpdateScripts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
