// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateActionsV1Reader is a Reader for the CreateActionsV1 structure.
type CreateActionsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateActionsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateActionsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateActionsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCreateActionsV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateActionsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreateActionsV1NotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateActionsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateActionsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /recon/entities/actions/v1] CreateActionsV1", response, response.Code())
	}
}

// NewCreateActionsV1OK creates a CreateActionsV1OK with default headers values
func NewCreateActionsV1OK() *CreateActionsV1OK {
	return &CreateActionsV1OK{}
}

/*
CreateActionsV1OK describes a response with status code 200, with default header values.

OK
*/
type CreateActionsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainActionEntitiesResponseV1
}

// IsSuccess returns true when this create actions v1 o k response has a 2xx status code
func (o *CreateActionsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create actions v1 o k response has a 3xx status code
func (o *CreateActionsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create actions v1 o k response has a 4xx status code
func (o *CreateActionsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create actions v1 o k response has a 5xx status code
func (o *CreateActionsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this create actions v1 o k response a status code equal to that given
func (o *CreateActionsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create actions v1 o k response
func (o *CreateActionsV1OK) Code() int {
	return 200
}

func (o *CreateActionsV1OK) Error() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1OK  %+v", 200, o.Payload)
}

func (o *CreateActionsV1OK) String() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1OK  %+v", 200, o.Payload)
}

func (o *CreateActionsV1OK) GetPayload() *models.DomainActionEntitiesResponseV1 {
	return o.Payload
}

func (o *CreateActionsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainActionEntitiesResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateActionsV1BadRequest creates a CreateActionsV1BadRequest with default headers values
func NewCreateActionsV1BadRequest() *CreateActionsV1BadRequest {
	return &CreateActionsV1BadRequest{}
}

/*
CreateActionsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateActionsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this create actions v1 bad request response has a 2xx status code
func (o *CreateActionsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create actions v1 bad request response has a 3xx status code
func (o *CreateActionsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create actions v1 bad request response has a 4xx status code
func (o *CreateActionsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create actions v1 bad request response has a 5xx status code
func (o *CreateActionsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create actions v1 bad request response a status code equal to that given
func (o *CreateActionsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create actions v1 bad request response
func (o *CreateActionsV1BadRequest) Code() int {
	return 400
}

func (o *CreateActionsV1BadRequest) Error() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *CreateActionsV1BadRequest) String() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *CreateActionsV1BadRequest) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *CreateActionsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateActionsV1Unauthorized creates a CreateActionsV1Unauthorized with default headers values
func NewCreateActionsV1Unauthorized() *CreateActionsV1Unauthorized {
	return &CreateActionsV1Unauthorized{}
}

/*
CreateActionsV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type CreateActionsV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this create actions v1 unauthorized response has a 2xx status code
func (o *CreateActionsV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create actions v1 unauthorized response has a 3xx status code
func (o *CreateActionsV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create actions v1 unauthorized response has a 4xx status code
func (o *CreateActionsV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create actions v1 unauthorized response has a 5xx status code
func (o *CreateActionsV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create actions v1 unauthorized response a status code equal to that given
func (o *CreateActionsV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create actions v1 unauthorized response
func (o *CreateActionsV1Unauthorized) Code() int {
	return 401
}

func (o *CreateActionsV1Unauthorized) Error() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *CreateActionsV1Unauthorized) String() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *CreateActionsV1Unauthorized) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *CreateActionsV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateActionsV1Forbidden creates a CreateActionsV1Forbidden with default headers values
func NewCreateActionsV1Forbidden() *CreateActionsV1Forbidden {
	return &CreateActionsV1Forbidden{}
}

/*
CreateActionsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateActionsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this create actions v1 forbidden response has a 2xx status code
func (o *CreateActionsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create actions v1 forbidden response has a 3xx status code
func (o *CreateActionsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create actions v1 forbidden response has a 4xx status code
func (o *CreateActionsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create actions v1 forbidden response has a 5xx status code
func (o *CreateActionsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create actions v1 forbidden response a status code equal to that given
func (o *CreateActionsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create actions v1 forbidden response
func (o *CreateActionsV1Forbidden) Code() int {
	return 403
}

func (o *CreateActionsV1Forbidden) Error() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *CreateActionsV1Forbidden) String() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *CreateActionsV1Forbidden) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *CreateActionsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateActionsV1NotFound creates a CreateActionsV1NotFound with default headers values
func NewCreateActionsV1NotFound() *CreateActionsV1NotFound {
	return &CreateActionsV1NotFound{}
}

/*
CreateActionsV1NotFound describes a response with status code 404, with default header values.

Not Found
*/
type CreateActionsV1NotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this create actions v1 not found response has a 2xx status code
func (o *CreateActionsV1NotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create actions v1 not found response has a 3xx status code
func (o *CreateActionsV1NotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create actions v1 not found response has a 4xx status code
func (o *CreateActionsV1NotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this create actions v1 not found response has a 5xx status code
func (o *CreateActionsV1NotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this create actions v1 not found response a status code equal to that given
func (o *CreateActionsV1NotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the create actions v1 not found response
func (o *CreateActionsV1NotFound) Code() int {
	return 404
}

func (o *CreateActionsV1NotFound) Error() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1NotFound  %+v", 404, o.Payload)
}

func (o *CreateActionsV1NotFound) String() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1NotFound  %+v", 404, o.Payload)
}

func (o *CreateActionsV1NotFound) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *CreateActionsV1NotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateActionsV1TooManyRequests creates a CreateActionsV1TooManyRequests with default headers values
func NewCreateActionsV1TooManyRequests() *CreateActionsV1TooManyRequests {
	return &CreateActionsV1TooManyRequests{}
}

/*
CreateActionsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateActionsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create actions v1 too many requests response has a 2xx status code
func (o *CreateActionsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create actions v1 too many requests response has a 3xx status code
func (o *CreateActionsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create actions v1 too many requests response has a 4xx status code
func (o *CreateActionsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create actions v1 too many requests response has a 5xx status code
func (o *CreateActionsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create actions v1 too many requests response a status code equal to that given
func (o *CreateActionsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create actions v1 too many requests response
func (o *CreateActionsV1TooManyRequests) Code() int {
	return 429
}

func (o *CreateActionsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateActionsV1TooManyRequests) String() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateActionsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateActionsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateActionsV1InternalServerError creates a CreateActionsV1InternalServerError with default headers values
func NewCreateActionsV1InternalServerError() *CreateActionsV1InternalServerError {
	return &CreateActionsV1InternalServerError{}
}

/*
CreateActionsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateActionsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecResponseFields
}

// IsSuccess returns true when this create actions v1 internal server error response has a 2xx status code
func (o *CreateActionsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create actions v1 internal server error response has a 3xx status code
func (o *CreateActionsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create actions v1 internal server error response has a 4xx status code
func (o *CreateActionsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create actions v1 internal server error response has a 5xx status code
func (o *CreateActionsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create actions v1 internal server error response a status code equal to that given
func (o *CreateActionsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create actions v1 internal server error response
func (o *CreateActionsV1InternalServerError) Code() int {
	return 500
}

func (o *CreateActionsV1InternalServerError) Error() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *CreateActionsV1InternalServerError) String() string {
	return fmt.Sprintf("[POST /recon/entities/actions/v1][%d] createActionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *CreateActionsV1InternalServerError) GetPayload() *models.MsaspecResponseFields {
	return o.Payload
}

func (o *CreateActionsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecResponseFields)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
