// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteNotificationsV1Reader is a Reader for the DeleteNotificationsV1 structure.
type DeleteNotificationsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteNotificationsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteNotificationsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteNotificationsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeleteNotificationsV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteNotificationsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteNotificationsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteNotificationsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /recon/entities/notifications/v1] DeleteNotificationsV1", response, response.Code())
	}
}

// NewDeleteNotificationsV1OK creates a DeleteNotificationsV1OK with default headers values
func NewDeleteNotificationsV1OK() *DeleteNotificationsV1OK {
	return &DeleteNotificationsV1OK{}
}

/*
DeleteNotificationsV1OK describes a response with status code 200, with default header values.

OK
*/
type DeleteNotificationsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainNotificationIDResponse
}

// IsSuccess returns true when this delete notifications v1 o k response has a 2xx status code
func (o *DeleteNotificationsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete notifications v1 o k response has a 3xx status code
func (o *DeleteNotificationsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete notifications v1 o k response has a 4xx status code
func (o *DeleteNotificationsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete notifications v1 o k response has a 5xx status code
func (o *DeleteNotificationsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete notifications v1 o k response a status code equal to that given
func (o *DeleteNotificationsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete notifications v1 o k response
func (o *DeleteNotificationsV1OK) Code() int {
	return 200
}

func (o *DeleteNotificationsV1OK) Error() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1OK  %+v", 200, o.Payload)
}

func (o *DeleteNotificationsV1OK) String() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1OK  %+v", 200, o.Payload)
}

func (o *DeleteNotificationsV1OK) GetPayload() *models.DomainNotificationIDResponse {
	return o.Payload
}

func (o *DeleteNotificationsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainNotificationIDResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteNotificationsV1BadRequest creates a DeleteNotificationsV1BadRequest with default headers values
func NewDeleteNotificationsV1BadRequest() *DeleteNotificationsV1BadRequest {
	return &DeleteNotificationsV1BadRequest{}
}

/*
DeleteNotificationsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type DeleteNotificationsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this delete notifications v1 bad request response has a 2xx status code
func (o *DeleteNotificationsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete notifications v1 bad request response has a 3xx status code
func (o *DeleteNotificationsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete notifications v1 bad request response has a 4xx status code
func (o *DeleteNotificationsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete notifications v1 bad request response has a 5xx status code
func (o *DeleteNotificationsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete notifications v1 bad request response a status code equal to that given
func (o *DeleteNotificationsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete notifications v1 bad request response
func (o *DeleteNotificationsV1BadRequest) Code() int {
	return 400
}

func (o *DeleteNotificationsV1BadRequest) Error() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1BadRequest  %+v", 400, o.Payload)
}

func (o *DeleteNotificationsV1BadRequest) String() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1BadRequest  %+v", 400, o.Payload)
}

func (o *DeleteNotificationsV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *DeleteNotificationsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteNotificationsV1Unauthorized creates a DeleteNotificationsV1Unauthorized with default headers values
func NewDeleteNotificationsV1Unauthorized() *DeleteNotificationsV1Unauthorized {
	return &DeleteNotificationsV1Unauthorized{}
}

/*
DeleteNotificationsV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type DeleteNotificationsV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this delete notifications v1 unauthorized response has a 2xx status code
func (o *DeleteNotificationsV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete notifications v1 unauthorized response has a 3xx status code
func (o *DeleteNotificationsV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete notifications v1 unauthorized response has a 4xx status code
func (o *DeleteNotificationsV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete notifications v1 unauthorized response has a 5xx status code
func (o *DeleteNotificationsV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete notifications v1 unauthorized response a status code equal to that given
func (o *DeleteNotificationsV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete notifications v1 unauthorized response
func (o *DeleteNotificationsV1Unauthorized) Code() int {
	return 401
}

func (o *DeleteNotificationsV1Unauthorized) Error() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *DeleteNotificationsV1Unauthorized) String() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *DeleteNotificationsV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *DeleteNotificationsV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteNotificationsV1Forbidden creates a DeleteNotificationsV1Forbidden with default headers values
func NewDeleteNotificationsV1Forbidden() *DeleteNotificationsV1Forbidden {
	return &DeleteNotificationsV1Forbidden{}
}

/*
DeleteNotificationsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteNotificationsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this delete notifications v1 forbidden response has a 2xx status code
func (o *DeleteNotificationsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete notifications v1 forbidden response has a 3xx status code
func (o *DeleteNotificationsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete notifications v1 forbidden response has a 4xx status code
func (o *DeleteNotificationsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete notifications v1 forbidden response has a 5xx status code
func (o *DeleteNotificationsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete notifications v1 forbidden response a status code equal to that given
func (o *DeleteNotificationsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete notifications v1 forbidden response
func (o *DeleteNotificationsV1Forbidden) Code() int {
	return 403
}

func (o *DeleteNotificationsV1Forbidden) Error() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1Forbidden  %+v", 403, o.Payload)
}

func (o *DeleteNotificationsV1Forbidden) String() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1Forbidden  %+v", 403, o.Payload)
}

func (o *DeleteNotificationsV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *DeleteNotificationsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteNotificationsV1TooManyRequests creates a DeleteNotificationsV1TooManyRequests with default headers values
func NewDeleteNotificationsV1TooManyRequests() *DeleteNotificationsV1TooManyRequests {
	return &DeleteNotificationsV1TooManyRequests{}
}

/*
DeleteNotificationsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteNotificationsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete notifications v1 too many requests response has a 2xx status code
func (o *DeleteNotificationsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete notifications v1 too many requests response has a 3xx status code
func (o *DeleteNotificationsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete notifications v1 too many requests response has a 4xx status code
func (o *DeleteNotificationsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete notifications v1 too many requests response has a 5xx status code
func (o *DeleteNotificationsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete notifications v1 too many requests response a status code equal to that given
func (o *DeleteNotificationsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete notifications v1 too many requests response
func (o *DeleteNotificationsV1TooManyRequests) Code() int {
	return 429
}

func (o *DeleteNotificationsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteNotificationsV1TooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteNotificationsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteNotificationsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteNotificationsV1InternalServerError creates a DeleteNotificationsV1InternalServerError with default headers values
func NewDeleteNotificationsV1InternalServerError() *DeleteNotificationsV1InternalServerError {
	return &DeleteNotificationsV1InternalServerError{}
}

/*
DeleteNotificationsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type DeleteNotificationsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this delete notifications v1 internal server error response has a 2xx status code
func (o *DeleteNotificationsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete notifications v1 internal server error response has a 3xx status code
func (o *DeleteNotificationsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete notifications v1 internal server error response has a 4xx status code
func (o *DeleteNotificationsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete notifications v1 internal server error response has a 5xx status code
func (o *DeleteNotificationsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete notifications v1 internal server error response a status code equal to that given
func (o *DeleteNotificationsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete notifications v1 internal server error response
func (o *DeleteNotificationsV1InternalServerError) Code() int {
	return 500
}

func (o *DeleteNotificationsV1InternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteNotificationsV1InternalServerError) String() string {
	return fmt.Sprintf("[DELETE /recon/entities/notifications/v1][%d] deleteNotificationsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteNotificationsV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *DeleteNotificationsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
