// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteRulesV1Params creates a new DeleteRulesV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteRulesV1Params() *DeleteRulesV1Params {
	return &DeleteRulesV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteRulesV1ParamsWithTimeout creates a new DeleteRulesV1Params object
// with the ability to set a timeout on a request.
func NewDeleteRulesV1ParamsWithTimeout(timeout time.Duration) *DeleteRulesV1Params {
	return &DeleteRulesV1Params{
		timeout: timeout,
	}
}

// NewDeleteRulesV1ParamsWithContext creates a new DeleteRulesV1Params object
// with the ability to set a context for a request.
func NewDeleteRulesV1ParamsWithContext(ctx context.Context) *DeleteRulesV1Params {
	return &DeleteRulesV1Params{
		Context: ctx,
	}
}

// NewDeleteRulesV1ParamsWithHTTPClient creates a new DeleteRulesV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteRulesV1ParamsWithHTTPClient(client *http.Client) *DeleteRulesV1Params {
	return &DeleteRulesV1Params{
		HTTPClient: client,
	}
}

/*
DeleteRulesV1Params contains all the parameters to send to the API endpoint

	for the delete rules v1 operation.

	Typically these are written to a http.Request.
*/
type DeleteRulesV1Params struct {

	/* Ids.

	   IDs of rules.
	*/
	Ids []string

	/* NotificationsDeletionRequested.

	   Whether we should delete the notifications generated by this rule or not
	*/
	NotificationsDeletionRequested *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete rules v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteRulesV1Params) WithDefaults() *DeleteRulesV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete rules v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteRulesV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete rules v1 params
func (o *DeleteRulesV1Params) WithTimeout(timeout time.Duration) *DeleteRulesV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete rules v1 params
func (o *DeleteRulesV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete rules v1 params
func (o *DeleteRulesV1Params) WithContext(ctx context.Context) *DeleteRulesV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete rules v1 params
func (o *DeleteRulesV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete rules v1 params
func (o *DeleteRulesV1Params) WithHTTPClient(client *http.Client) *DeleteRulesV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete rules v1 params
func (o *DeleteRulesV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the delete rules v1 params
func (o *DeleteRulesV1Params) WithIds(ids []string) *DeleteRulesV1Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the delete rules v1 params
func (o *DeleteRulesV1Params) SetIds(ids []string) {
	o.Ids = ids
}

// WithNotificationsDeletionRequested adds the notificationsDeletionRequested to the delete rules v1 params
func (o *DeleteRulesV1Params) WithNotificationsDeletionRequested(notificationsDeletionRequested *bool) *DeleteRulesV1Params {
	o.SetNotificationsDeletionRequested(notificationsDeletionRequested)
	return o
}

// SetNotificationsDeletionRequested adds the notificationsDeletionRequested to the delete rules v1 params
func (o *DeleteRulesV1Params) SetNotificationsDeletionRequested(notificationsDeletionRequested *bool) {
	o.NotificationsDeletionRequested = notificationsDeletionRequested
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteRulesV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if o.NotificationsDeletionRequested != nil {

		// query param notificationsDeletionRequested
		var qrNotificationsDeletionRequested bool

		if o.NotificationsDeletionRequested != nil {
			qrNotificationsDeletionRequested = *o.NotificationsDeletionRequested
		}
		qNotificationsDeletionRequested := swag.FormatBool(qrNotificationsDeletionRequested)
		if qNotificationsDeletionRequested != "" {

			if err := r.SetQueryParam("notificationsDeletionRequested", qNotificationsDeletionRequested); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDeleteRulesV1 binds the parameter ids
func (o *DeleteRulesV1Params) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
