// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetExportJobsV1Reader is a Reader for the GetExportJobsV1 structure.
type GetExportJobsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetExportJobsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetExportJobsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetExportJobsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetExportJobsV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetExportJobsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetExportJobsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetExportJobsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /recon/entities/exports/v1] GetExportJobsV1", response, response.Code())
	}
}

// NewGetExportJobsV1OK creates a GetExportJobsV1OK with default headers values
func NewGetExportJobsV1OK() *GetExportJobsV1OK {
	return &GetExportJobsV1OK{}
}

/*
GetExportJobsV1OK describes a response with status code 200, with default header values.

OK
*/
type GetExportJobsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainExportJobEntitiesResponseV1
}

// IsSuccess returns true when this get export jobs v1 o k response has a 2xx status code
func (o *GetExportJobsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get export jobs v1 o k response has a 3xx status code
func (o *GetExportJobsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get export jobs v1 o k response has a 4xx status code
func (o *GetExportJobsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get export jobs v1 o k response has a 5xx status code
func (o *GetExportJobsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get export jobs v1 o k response a status code equal to that given
func (o *GetExportJobsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get export jobs v1 o k response
func (o *GetExportJobsV1OK) Code() int {
	return 200
}

func (o *GetExportJobsV1OK) Error() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1OK  %+v", 200, o.Payload)
}

func (o *GetExportJobsV1OK) String() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1OK  %+v", 200, o.Payload)
}

func (o *GetExportJobsV1OK) GetPayload() *models.DomainExportJobEntitiesResponseV1 {
	return o.Payload
}

func (o *GetExportJobsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainExportJobEntitiesResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetExportJobsV1BadRequest creates a GetExportJobsV1BadRequest with default headers values
func NewGetExportJobsV1BadRequest() *GetExportJobsV1BadRequest {
	return &GetExportJobsV1BadRequest{}
}

/*
GetExportJobsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetExportJobsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this get export jobs v1 bad request response has a 2xx status code
func (o *GetExportJobsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get export jobs v1 bad request response has a 3xx status code
func (o *GetExportJobsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get export jobs v1 bad request response has a 4xx status code
func (o *GetExportJobsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get export jobs v1 bad request response has a 5xx status code
func (o *GetExportJobsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get export jobs v1 bad request response a status code equal to that given
func (o *GetExportJobsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get export jobs v1 bad request response
func (o *GetExportJobsV1BadRequest) Code() int {
	return 400
}

func (o *GetExportJobsV1BadRequest) Error() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1BadRequest  %+v", 400, o.Payload)
}

func (o *GetExportJobsV1BadRequest) String() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1BadRequest  %+v", 400, o.Payload)
}

func (o *GetExportJobsV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *GetExportJobsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetExportJobsV1Unauthorized creates a GetExportJobsV1Unauthorized with default headers values
func NewGetExportJobsV1Unauthorized() *GetExportJobsV1Unauthorized {
	return &GetExportJobsV1Unauthorized{}
}

/*
GetExportJobsV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type GetExportJobsV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this get export jobs v1 unauthorized response has a 2xx status code
func (o *GetExportJobsV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get export jobs v1 unauthorized response has a 3xx status code
func (o *GetExportJobsV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get export jobs v1 unauthorized response has a 4xx status code
func (o *GetExportJobsV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get export jobs v1 unauthorized response has a 5xx status code
func (o *GetExportJobsV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get export jobs v1 unauthorized response a status code equal to that given
func (o *GetExportJobsV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get export jobs v1 unauthorized response
func (o *GetExportJobsV1Unauthorized) Code() int {
	return 401
}

func (o *GetExportJobsV1Unauthorized) Error() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *GetExportJobsV1Unauthorized) String() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *GetExportJobsV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *GetExportJobsV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetExportJobsV1Forbidden creates a GetExportJobsV1Forbidden with default headers values
func NewGetExportJobsV1Forbidden() *GetExportJobsV1Forbidden {
	return &GetExportJobsV1Forbidden{}
}

/*
GetExportJobsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetExportJobsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this get export jobs v1 forbidden response has a 2xx status code
func (o *GetExportJobsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get export jobs v1 forbidden response has a 3xx status code
func (o *GetExportJobsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get export jobs v1 forbidden response has a 4xx status code
func (o *GetExportJobsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get export jobs v1 forbidden response has a 5xx status code
func (o *GetExportJobsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get export jobs v1 forbidden response a status code equal to that given
func (o *GetExportJobsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get export jobs v1 forbidden response
func (o *GetExportJobsV1Forbidden) Code() int {
	return 403
}

func (o *GetExportJobsV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetExportJobsV1Forbidden) String() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetExportJobsV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *GetExportJobsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetExportJobsV1TooManyRequests creates a GetExportJobsV1TooManyRequests with default headers values
func NewGetExportJobsV1TooManyRequests() *GetExportJobsV1TooManyRequests {
	return &GetExportJobsV1TooManyRequests{}
}

/*
GetExportJobsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetExportJobsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get export jobs v1 too many requests response has a 2xx status code
func (o *GetExportJobsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get export jobs v1 too many requests response has a 3xx status code
func (o *GetExportJobsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get export jobs v1 too many requests response has a 4xx status code
func (o *GetExportJobsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get export jobs v1 too many requests response has a 5xx status code
func (o *GetExportJobsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get export jobs v1 too many requests response a status code equal to that given
func (o *GetExportJobsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get export jobs v1 too many requests response
func (o *GetExportJobsV1TooManyRequests) Code() int {
	return 429
}

func (o *GetExportJobsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetExportJobsV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetExportJobsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetExportJobsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetExportJobsV1InternalServerError creates a GetExportJobsV1InternalServerError with default headers values
func NewGetExportJobsV1InternalServerError() *GetExportJobsV1InternalServerError {
	return &GetExportJobsV1InternalServerError{}
}

/*
GetExportJobsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetExportJobsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this get export jobs v1 internal server error response has a 2xx status code
func (o *GetExportJobsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get export jobs v1 internal server error response has a 3xx status code
func (o *GetExportJobsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get export jobs v1 internal server error response has a 4xx status code
func (o *GetExportJobsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get export jobs v1 internal server error response has a 5xx status code
func (o *GetExportJobsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get export jobs v1 internal server error response a status code equal to that given
func (o *GetExportJobsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get export jobs v1 internal server error response
func (o *GetExportJobsV1InternalServerError) Code() int {
	return 500
}

func (o *GetExportJobsV1InternalServerError) Error() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *GetExportJobsV1InternalServerError) String() string {
	return fmt.Sprintf("[GET /recon/entities/exports/v1][%d] getExportJobsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *GetExportJobsV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *GetExportJobsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
