// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetNotificationsV1Reader is a Reader for the GetNotificationsV1 structure.
type GetNotificationsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetNotificationsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetNotificationsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetNotificationsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetNotificationsV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetNotificationsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetNotificationsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetNotificationsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /recon/entities/notifications/v1] GetNotificationsV1", response, response.Code())
	}
}

// NewGetNotificationsV1OK creates a GetNotificationsV1OK with default headers values
func NewGetNotificationsV1OK() *GetNotificationsV1OK {
	return &GetNotificationsV1OK{}
}

/*
GetNotificationsV1OK describes a response with status code 200, with default header values.

OK
*/
type GetNotificationsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainNotificationEntitiesResponseV1
}

// IsSuccess returns true when this get notifications v1 o k response has a 2xx status code
func (o *GetNotificationsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get notifications v1 o k response has a 3xx status code
func (o *GetNotificationsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get notifications v1 o k response has a 4xx status code
func (o *GetNotificationsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get notifications v1 o k response has a 5xx status code
func (o *GetNotificationsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get notifications v1 o k response a status code equal to that given
func (o *GetNotificationsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get notifications v1 o k response
func (o *GetNotificationsV1OK) Code() int {
	return 200
}

func (o *GetNotificationsV1OK) Error() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1OK  %+v", 200, o.Payload)
}

func (o *GetNotificationsV1OK) String() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1OK  %+v", 200, o.Payload)
}

func (o *GetNotificationsV1OK) GetPayload() *models.DomainNotificationEntitiesResponseV1 {
	return o.Payload
}

func (o *GetNotificationsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainNotificationEntitiesResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNotificationsV1BadRequest creates a GetNotificationsV1BadRequest with default headers values
func NewGetNotificationsV1BadRequest() *GetNotificationsV1BadRequest {
	return &GetNotificationsV1BadRequest{}
}

/*
GetNotificationsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetNotificationsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this get notifications v1 bad request response has a 2xx status code
func (o *GetNotificationsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get notifications v1 bad request response has a 3xx status code
func (o *GetNotificationsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get notifications v1 bad request response has a 4xx status code
func (o *GetNotificationsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get notifications v1 bad request response has a 5xx status code
func (o *GetNotificationsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get notifications v1 bad request response a status code equal to that given
func (o *GetNotificationsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get notifications v1 bad request response
func (o *GetNotificationsV1BadRequest) Code() int {
	return 400
}

func (o *GetNotificationsV1BadRequest) Error() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1BadRequest  %+v", 400, o.Payload)
}

func (o *GetNotificationsV1BadRequest) String() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1BadRequest  %+v", 400, o.Payload)
}

func (o *GetNotificationsV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *GetNotificationsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNotificationsV1Unauthorized creates a GetNotificationsV1Unauthorized with default headers values
func NewGetNotificationsV1Unauthorized() *GetNotificationsV1Unauthorized {
	return &GetNotificationsV1Unauthorized{}
}

/*
GetNotificationsV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type GetNotificationsV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this get notifications v1 unauthorized response has a 2xx status code
func (o *GetNotificationsV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get notifications v1 unauthorized response has a 3xx status code
func (o *GetNotificationsV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get notifications v1 unauthorized response has a 4xx status code
func (o *GetNotificationsV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get notifications v1 unauthorized response has a 5xx status code
func (o *GetNotificationsV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get notifications v1 unauthorized response a status code equal to that given
func (o *GetNotificationsV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get notifications v1 unauthorized response
func (o *GetNotificationsV1Unauthorized) Code() int {
	return 401
}

func (o *GetNotificationsV1Unauthorized) Error() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *GetNotificationsV1Unauthorized) String() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *GetNotificationsV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *GetNotificationsV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNotificationsV1Forbidden creates a GetNotificationsV1Forbidden with default headers values
func NewGetNotificationsV1Forbidden() *GetNotificationsV1Forbidden {
	return &GetNotificationsV1Forbidden{}
}

/*
GetNotificationsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetNotificationsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this get notifications v1 forbidden response has a 2xx status code
func (o *GetNotificationsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get notifications v1 forbidden response has a 3xx status code
func (o *GetNotificationsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get notifications v1 forbidden response has a 4xx status code
func (o *GetNotificationsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get notifications v1 forbidden response has a 5xx status code
func (o *GetNotificationsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get notifications v1 forbidden response a status code equal to that given
func (o *GetNotificationsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get notifications v1 forbidden response
func (o *GetNotificationsV1Forbidden) Code() int {
	return 403
}

func (o *GetNotificationsV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetNotificationsV1Forbidden) String() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1Forbidden  %+v", 403, o.Payload)
}

func (o *GetNotificationsV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *GetNotificationsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNotificationsV1TooManyRequests creates a GetNotificationsV1TooManyRequests with default headers values
func NewGetNotificationsV1TooManyRequests() *GetNotificationsV1TooManyRequests {
	return &GetNotificationsV1TooManyRequests{}
}

/*
GetNotificationsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetNotificationsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get notifications v1 too many requests response has a 2xx status code
func (o *GetNotificationsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get notifications v1 too many requests response has a 3xx status code
func (o *GetNotificationsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get notifications v1 too many requests response has a 4xx status code
func (o *GetNotificationsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get notifications v1 too many requests response has a 5xx status code
func (o *GetNotificationsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get notifications v1 too many requests response a status code equal to that given
func (o *GetNotificationsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get notifications v1 too many requests response
func (o *GetNotificationsV1TooManyRequests) Code() int {
	return 429
}

func (o *GetNotificationsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetNotificationsV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetNotificationsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetNotificationsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNotificationsV1InternalServerError creates a GetNotificationsV1InternalServerError with default headers values
func NewGetNotificationsV1InternalServerError() *GetNotificationsV1InternalServerError {
	return &GetNotificationsV1InternalServerError{}
}

/*
GetNotificationsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetNotificationsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this get notifications v1 internal server error response has a 2xx status code
func (o *GetNotificationsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get notifications v1 internal server error response has a 3xx status code
func (o *GetNotificationsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get notifications v1 internal server error response has a 4xx status code
func (o *GetNotificationsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get notifications v1 internal server error response has a 5xx status code
func (o *GetNotificationsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get notifications v1 internal server error response a status code equal to that given
func (o *GetNotificationsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get notifications v1 internal server error response
func (o *GetNotificationsV1InternalServerError) Code() int {
	return 500
}

func (o *GetNotificationsV1InternalServerError) Error() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *GetNotificationsV1InternalServerError) String() string {
	return fmt.Sprintf("[GET /recon/entities/notifications/v1][%d] getNotificationsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *GetNotificationsV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *GetNotificationsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
