// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetRulesV1Params creates a new GetRulesV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetRulesV1Params() *GetRulesV1Params {
	return &GetRulesV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetRulesV1ParamsWithTimeout creates a new GetRulesV1Params object
// with the ability to set a timeout on a request.
func NewGetRulesV1ParamsWithTimeout(timeout time.Duration) *GetRulesV1Params {
	return &GetRulesV1Params{
		timeout: timeout,
	}
}

// NewGetRulesV1ParamsWithContext creates a new GetRulesV1Params object
// with the ability to set a context for a request.
func NewGetRulesV1ParamsWithContext(ctx context.Context) *GetRulesV1Params {
	return &GetRulesV1Params{
		Context: ctx,
	}
}

// NewGetRulesV1ParamsWithHTTPClient creates a new GetRulesV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewGetRulesV1ParamsWithHTTPClient(client *http.Client) *GetRulesV1Params {
	return &GetRulesV1Params{
		HTTPClient: client,
	}
}

/*
GetRulesV1Params contains all the parameters to send to the API endpoint

	for the get rules v1 operation.

	Typically these are written to a http.Request.
*/
type GetRulesV1Params struct {

	/* Ids.

	   IDs of rules.
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get rules v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRulesV1Params) WithDefaults() *GetRulesV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get rules v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRulesV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get rules v1 params
func (o *GetRulesV1Params) WithTimeout(timeout time.Duration) *GetRulesV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get rules v1 params
func (o *GetRulesV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get rules v1 params
func (o *GetRulesV1Params) WithContext(ctx context.Context) *GetRulesV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get rules v1 params
func (o *GetRulesV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get rules v1 params
func (o *GetRulesV1Params) WithHTTPClient(client *http.Client) *GetRulesV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get rules v1 params
func (o *GetRulesV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get rules v1 params
func (o *GetRulesV1Params) WithIds(ids []string) *GetRulesV1Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get rules v1 params
func (o *GetRulesV1Params) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetRulesV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetRulesV1 binds the parameter ids
func (o *GetRulesV1Params) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
