// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewPreviewRuleV1Params creates a new PreviewRuleV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPreviewRuleV1Params() *PreviewRuleV1Params {
	return &PreviewRuleV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewPreviewRuleV1ParamsWithTimeout creates a new PreviewRuleV1Params object
// with the ability to set a timeout on a request.
func NewPreviewRuleV1ParamsWithTimeout(timeout time.Duration) *PreviewRuleV1Params {
	return &PreviewRuleV1Params{
		timeout: timeout,
	}
}

// NewPreviewRuleV1ParamsWithContext creates a new PreviewRuleV1Params object
// with the ability to set a context for a request.
func NewPreviewRuleV1ParamsWithContext(ctx context.Context) *PreviewRuleV1Params {
	return &PreviewRuleV1Params{
		Context: ctx,
	}
}

// NewPreviewRuleV1ParamsWithHTTPClient creates a new PreviewRuleV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewPreviewRuleV1ParamsWithHTTPClient(client *http.Client) *PreviewRuleV1Params {
	return &PreviewRuleV1Params{
		HTTPClient: client,
	}
}

/*
PreviewRuleV1Params contains all the parameters to send to the API endpoint

	for the preview rule v1 operation.

	Typically these are written to a http.Request.
*/
type PreviewRuleV1Params struct {

	// Body.
	Body *models.DomainRulePreviewRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the preview rule v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PreviewRuleV1Params) WithDefaults() *PreviewRuleV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the preview rule v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PreviewRuleV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the preview rule v1 params
func (o *PreviewRuleV1Params) WithTimeout(timeout time.Duration) *PreviewRuleV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the preview rule v1 params
func (o *PreviewRuleV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the preview rule v1 params
func (o *PreviewRuleV1Params) WithContext(ctx context.Context) *PreviewRuleV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the preview rule v1 params
func (o *PreviewRuleV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the preview rule v1 params
func (o *PreviewRuleV1Params) WithHTTPClient(client *http.Client) *PreviewRuleV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the preview rule v1 params
func (o *PreviewRuleV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the preview rule v1 params
func (o *PreviewRuleV1Params) WithBody(body *models.DomainRulePreviewRequest) *PreviewRuleV1Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the preview rule v1 params
func (o *PreviewRuleV1Params) SetBody(body *models.DomainRulePreviewRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PreviewRuleV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
