// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// PreviewRuleV1Reader is a Reader for the PreviewRuleV1 structure.
type PreviewRuleV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PreviewRuleV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPreviewRuleV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPreviewRuleV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewPreviewRuleV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPreviewRuleV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPreviewRuleV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPreviewRuleV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /recon/aggregates/rules-preview/GET/v1] PreviewRuleV1", response, response.Code())
	}
}

// NewPreviewRuleV1OK creates a PreviewRuleV1OK with default headers values
func NewPreviewRuleV1OK() *PreviewRuleV1OK {
	return &PreviewRuleV1OK{}
}

/*
PreviewRuleV1OK describes a response with status code 200, with default header values.

OK
*/
type PreviewRuleV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainAggregatesResponse
}

// IsSuccess returns true when this preview rule v1 o k response has a 2xx status code
func (o *PreviewRuleV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this preview rule v1 o k response has a 3xx status code
func (o *PreviewRuleV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this preview rule v1 o k response has a 4xx status code
func (o *PreviewRuleV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this preview rule v1 o k response has a 5xx status code
func (o *PreviewRuleV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this preview rule v1 o k response a status code equal to that given
func (o *PreviewRuleV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the preview rule v1 o k response
func (o *PreviewRuleV1OK) Code() int {
	return 200
}

func (o *PreviewRuleV1OK) Error() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1OK  %+v", 200, o.Payload)
}

func (o *PreviewRuleV1OK) String() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1OK  %+v", 200, o.Payload)
}

func (o *PreviewRuleV1OK) GetPayload() *models.DomainAggregatesResponse {
	return o.Payload
}

func (o *PreviewRuleV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainAggregatesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPreviewRuleV1BadRequest creates a PreviewRuleV1BadRequest with default headers values
func NewPreviewRuleV1BadRequest() *PreviewRuleV1BadRequest {
	return &PreviewRuleV1BadRequest{}
}

/*
PreviewRuleV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type PreviewRuleV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this preview rule v1 bad request response has a 2xx status code
func (o *PreviewRuleV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this preview rule v1 bad request response has a 3xx status code
func (o *PreviewRuleV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this preview rule v1 bad request response has a 4xx status code
func (o *PreviewRuleV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this preview rule v1 bad request response has a 5xx status code
func (o *PreviewRuleV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this preview rule v1 bad request response a status code equal to that given
func (o *PreviewRuleV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the preview rule v1 bad request response
func (o *PreviewRuleV1BadRequest) Code() int {
	return 400
}

func (o *PreviewRuleV1BadRequest) Error() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1BadRequest  %+v", 400, o.Payload)
}

func (o *PreviewRuleV1BadRequest) String() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1BadRequest  %+v", 400, o.Payload)
}

func (o *PreviewRuleV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *PreviewRuleV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPreviewRuleV1Unauthorized creates a PreviewRuleV1Unauthorized with default headers values
func NewPreviewRuleV1Unauthorized() *PreviewRuleV1Unauthorized {
	return &PreviewRuleV1Unauthorized{}
}

/*
PreviewRuleV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type PreviewRuleV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this preview rule v1 unauthorized response has a 2xx status code
func (o *PreviewRuleV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this preview rule v1 unauthorized response has a 3xx status code
func (o *PreviewRuleV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this preview rule v1 unauthorized response has a 4xx status code
func (o *PreviewRuleV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this preview rule v1 unauthorized response has a 5xx status code
func (o *PreviewRuleV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this preview rule v1 unauthorized response a status code equal to that given
func (o *PreviewRuleV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the preview rule v1 unauthorized response
func (o *PreviewRuleV1Unauthorized) Code() int {
	return 401
}

func (o *PreviewRuleV1Unauthorized) Error() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1Unauthorized  %+v", 401, o.Payload)
}

func (o *PreviewRuleV1Unauthorized) String() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1Unauthorized  %+v", 401, o.Payload)
}

func (o *PreviewRuleV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *PreviewRuleV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPreviewRuleV1Forbidden creates a PreviewRuleV1Forbidden with default headers values
func NewPreviewRuleV1Forbidden() *PreviewRuleV1Forbidden {
	return &PreviewRuleV1Forbidden{}
}

/*
PreviewRuleV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PreviewRuleV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this preview rule v1 forbidden response has a 2xx status code
func (o *PreviewRuleV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this preview rule v1 forbidden response has a 3xx status code
func (o *PreviewRuleV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this preview rule v1 forbidden response has a 4xx status code
func (o *PreviewRuleV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this preview rule v1 forbidden response has a 5xx status code
func (o *PreviewRuleV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this preview rule v1 forbidden response a status code equal to that given
func (o *PreviewRuleV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the preview rule v1 forbidden response
func (o *PreviewRuleV1Forbidden) Code() int {
	return 403
}

func (o *PreviewRuleV1Forbidden) Error() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1Forbidden  %+v", 403, o.Payload)
}

func (o *PreviewRuleV1Forbidden) String() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1Forbidden  %+v", 403, o.Payload)
}

func (o *PreviewRuleV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *PreviewRuleV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPreviewRuleV1TooManyRequests creates a PreviewRuleV1TooManyRequests with default headers values
func NewPreviewRuleV1TooManyRequests() *PreviewRuleV1TooManyRequests {
	return &PreviewRuleV1TooManyRequests{}
}

/*
PreviewRuleV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type PreviewRuleV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this preview rule v1 too many requests response has a 2xx status code
func (o *PreviewRuleV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this preview rule v1 too many requests response has a 3xx status code
func (o *PreviewRuleV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this preview rule v1 too many requests response has a 4xx status code
func (o *PreviewRuleV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this preview rule v1 too many requests response has a 5xx status code
func (o *PreviewRuleV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this preview rule v1 too many requests response a status code equal to that given
func (o *PreviewRuleV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the preview rule v1 too many requests response
func (o *PreviewRuleV1TooManyRequests) Code() int {
	return 429
}

func (o *PreviewRuleV1TooManyRequests) Error() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *PreviewRuleV1TooManyRequests) String() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *PreviewRuleV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PreviewRuleV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPreviewRuleV1InternalServerError creates a PreviewRuleV1InternalServerError with default headers values
func NewPreviewRuleV1InternalServerError() *PreviewRuleV1InternalServerError {
	return &PreviewRuleV1InternalServerError{}
}

/*
PreviewRuleV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type PreviewRuleV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this preview rule v1 internal server error response has a 2xx status code
func (o *PreviewRuleV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this preview rule v1 internal server error response has a 3xx status code
func (o *PreviewRuleV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this preview rule v1 internal server error response has a 4xx status code
func (o *PreviewRuleV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this preview rule v1 internal server error response has a 5xx status code
func (o *PreviewRuleV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this preview rule v1 internal server error response a status code equal to that given
func (o *PreviewRuleV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the preview rule v1 internal server error response
func (o *PreviewRuleV1InternalServerError) Code() int {
	return 500
}

func (o *PreviewRuleV1InternalServerError) Error() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1InternalServerError  %+v", 500, o.Payload)
}

func (o *PreviewRuleV1InternalServerError) String() string {
	return fmt.Sprintf("[POST /recon/aggregates/rules-preview/GET/v1][%d] previewRuleV1InternalServerError  %+v", 500, o.Payload)
}

func (o *PreviewRuleV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *PreviewRuleV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
