// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryActionsV1Reader is a Reader for the QueryActionsV1 structure.
type QueryActionsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryActionsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryActionsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryActionsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewQueryActionsV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryActionsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryActionsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryActionsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /recon/queries/actions/v1] QueryActionsV1", response, response.Code())
	}
}

// NewQueryActionsV1OK creates a QueryActionsV1OK with default headers values
func NewQueryActionsV1OK() *QueryActionsV1OK {
	return &QueryActionsV1OK{}
}

/*
QueryActionsV1OK describes a response with status code 200, with default header values.

OK
*/
type QueryActionsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainQueryResponse
}

// IsSuccess returns true when this query actions v1 o k response has a 2xx status code
func (o *QueryActionsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query actions v1 o k response has a 3xx status code
func (o *QueryActionsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query actions v1 o k response has a 4xx status code
func (o *QueryActionsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query actions v1 o k response has a 5xx status code
func (o *QueryActionsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this query actions v1 o k response a status code equal to that given
func (o *QueryActionsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query actions v1 o k response
func (o *QueryActionsV1OK) Code() int {
	return 200
}

func (o *QueryActionsV1OK) Error() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1OK  %+v", 200, o.Payload)
}

func (o *QueryActionsV1OK) String() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1OK  %+v", 200, o.Payload)
}

func (o *QueryActionsV1OK) GetPayload() *models.DomainQueryResponse {
	return o.Payload
}

func (o *QueryActionsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryActionsV1BadRequest creates a QueryActionsV1BadRequest with default headers values
func NewQueryActionsV1BadRequest() *QueryActionsV1BadRequest {
	return &QueryActionsV1BadRequest{}
}

/*
QueryActionsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryActionsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query actions v1 bad request response has a 2xx status code
func (o *QueryActionsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query actions v1 bad request response has a 3xx status code
func (o *QueryActionsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query actions v1 bad request response has a 4xx status code
func (o *QueryActionsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query actions v1 bad request response has a 5xx status code
func (o *QueryActionsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query actions v1 bad request response a status code equal to that given
func (o *QueryActionsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query actions v1 bad request response
func (o *QueryActionsV1BadRequest) Code() int {
	return 400
}

func (o *QueryActionsV1BadRequest) Error() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *QueryActionsV1BadRequest) String() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1BadRequest  %+v", 400, o.Payload)
}

func (o *QueryActionsV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryActionsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryActionsV1Unauthorized creates a QueryActionsV1Unauthorized with default headers values
func NewQueryActionsV1Unauthorized() *QueryActionsV1Unauthorized {
	return &QueryActionsV1Unauthorized{}
}

/*
QueryActionsV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type QueryActionsV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query actions v1 unauthorized response has a 2xx status code
func (o *QueryActionsV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query actions v1 unauthorized response has a 3xx status code
func (o *QueryActionsV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query actions v1 unauthorized response has a 4xx status code
func (o *QueryActionsV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this query actions v1 unauthorized response has a 5xx status code
func (o *QueryActionsV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this query actions v1 unauthorized response a status code equal to that given
func (o *QueryActionsV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the query actions v1 unauthorized response
func (o *QueryActionsV1Unauthorized) Code() int {
	return 401
}

func (o *QueryActionsV1Unauthorized) Error() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *QueryActionsV1Unauthorized) String() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *QueryActionsV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryActionsV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryActionsV1Forbidden creates a QueryActionsV1Forbidden with default headers values
func NewQueryActionsV1Forbidden() *QueryActionsV1Forbidden {
	return &QueryActionsV1Forbidden{}
}

/*
QueryActionsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryActionsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query actions v1 forbidden response has a 2xx status code
func (o *QueryActionsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query actions v1 forbidden response has a 3xx status code
func (o *QueryActionsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query actions v1 forbidden response has a 4xx status code
func (o *QueryActionsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query actions v1 forbidden response has a 5xx status code
func (o *QueryActionsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query actions v1 forbidden response a status code equal to that given
func (o *QueryActionsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query actions v1 forbidden response
func (o *QueryActionsV1Forbidden) Code() int {
	return 403
}

func (o *QueryActionsV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *QueryActionsV1Forbidden) String() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1Forbidden  %+v", 403, o.Payload)
}

func (o *QueryActionsV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryActionsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryActionsV1TooManyRequests creates a QueryActionsV1TooManyRequests with default headers values
func NewQueryActionsV1TooManyRequests() *QueryActionsV1TooManyRequests {
	return &QueryActionsV1TooManyRequests{}
}

/*
QueryActionsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryActionsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query actions v1 too many requests response has a 2xx status code
func (o *QueryActionsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query actions v1 too many requests response has a 3xx status code
func (o *QueryActionsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query actions v1 too many requests response has a 4xx status code
func (o *QueryActionsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query actions v1 too many requests response has a 5xx status code
func (o *QueryActionsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query actions v1 too many requests response a status code equal to that given
func (o *QueryActionsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query actions v1 too many requests response
func (o *QueryActionsV1TooManyRequests) Code() int {
	return 429
}

func (o *QueryActionsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryActionsV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryActionsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryActionsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryActionsV1InternalServerError creates a QueryActionsV1InternalServerError with default headers values
func NewQueryActionsV1InternalServerError() *QueryActionsV1InternalServerError {
	return &QueryActionsV1InternalServerError{}
}

/*
QueryActionsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryActionsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query actions v1 internal server error response has a 2xx status code
func (o *QueryActionsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query actions v1 internal server error response has a 3xx status code
func (o *QueryActionsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query actions v1 internal server error response has a 4xx status code
func (o *QueryActionsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query actions v1 internal server error response has a 5xx status code
func (o *QueryActionsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query actions v1 internal server error response a status code equal to that given
func (o *QueryActionsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query actions v1 internal server error response
func (o *QueryActionsV1InternalServerError) Code() int {
	return 500
}

func (o *QueryActionsV1InternalServerError) Error() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryActionsV1InternalServerError) String() string {
	return fmt.Sprintf("[GET /recon/queries/actions/v1][%d] queryActionsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryActionsV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryActionsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
