// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryNotificationsExposedDataRecordsV1Reader is a Reader for the QueryNotificationsExposedDataRecordsV1 structure.
type QueryNotificationsExposedDataRecordsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryNotificationsExposedDataRecordsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryNotificationsExposedDataRecordsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryNotificationsExposedDataRecordsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewQueryNotificationsExposedDataRecordsV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryNotificationsExposedDataRecordsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryNotificationsExposedDataRecordsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryNotificationsExposedDataRecordsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /recon/queries/notifications-exposed-data-records/v1] QueryNotificationsExposedDataRecordsV1", response, response.Code())
	}
}

// NewQueryNotificationsExposedDataRecordsV1OK creates a QueryNotificationsExposedDataRecordsV1OK with default headers values
func NewQueryNotificationsExposedDataRecordsV1OK() *QueryNotificationsExposedDataRecordsV1OK {
	return &QueryNotificationsExposedDataRecordsV1OK{}
}

/*
QueryNotificationsExposedDataRecordsV1OK describes a response with status code 200, with default header values.

OK
*/
type QueryNotificationsExposedDataRecordsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainQueryResponse
}

// IsSuccess returns true when this query notifications exposed data records v1 o k response has a 2xx status code
func (o *QueryNotificationsExposedDataRecordsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query notifications exposed data records v1 o k response has a 3xx status code
func (o *QueryNotificationsExposedDataRecordsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications exposed data records v1 o k response has a 4xx status code
func (o *QueryNotificationsExposedDataRecordsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query notifications exposed data records v1 o k response has a 5xx status code
func (o *QueryNotificationsExposedDataRecordsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications exposed data records v1 o k response a status code equal to that given
func (o *QueryNotificationsExposedDataRecordsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query notifications exposed data records v1 o k response
func (o *QueryNotificationsExposedDataRecordsV1OK) Code() int {
	return 200
}

func (o *QueryNotificationsExposedDataRecordsV1OK) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1OK  %+v", 200, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1OK) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1OK  %+v", 200, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1OK) GetPayload() *models.DomainQueryResponse {
	return o.Payload
}

func (o *QueryNotificationsExposedDataRecordsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsExposedDataRecordsV1BadRequest creates a QueryNotificationsExposedDataRecordsV1BadRequest with default headers values
func NewQueryNotificationsExposedDataRecordsV1BadRequest() *QueryNotificationsExposedDataRecordsV1BadRequest {
	return &QueryNotificationsExposedDataRecordsV1BadRequest{}
}

/*
QueryNotificationsExposedDataRecordsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryNotificationsExposedDataRecordsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query notifications exposed data records v1 bad request response has a 2xx status code
func (o *QueryNotificationsExposedDataRecordsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications exposed data records v1 bad request response has a 3xx status code
func (o *QueryNotificationsExposedDataRecordsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications exposed data records v1 bad request response has a 4xx status code
func (o *QueryNotificationsExposedDataRecordsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query notifications exposed data records v1 bad request response has a 5xx status code
func (o *QueryNotificationsExposedDataRecordsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications exposed data records v1 bad request response a status code equal to that given
func (o *QueryNotificationsExposedDataRecordsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query notifications exposed data records v1 bad request response
func (o *QueryNotificationsExposedDataRecordsV1BadRequest) Code() int {
	return 400
}

func (o *QueryNotificationsExposedDataRecordsV1BadRequest) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1BadRequest  %+v", 400, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1BadRequest) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1BadRequest  %+v", 400, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryNotificationsExposedDataRecordsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsExposedDataRecordsV1Unauthorized creates a QueryNotificationsExposedDataRecordsV1Unauthorized with default headers values
func NewQueryNotificationsExposedDataRecordsV1Unauthorized() *QueryNotificationsExposedDataRecordsV1Unauthorized {
	return &QueryNotificationsExposedDataRecordsV1Unauthorized{}
}

/*
QueryNotificationsExposedDataRecordsV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type QueryNotificationsExposedDataRecordsV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query notifications exposed data records v1 unauthorized response has a 2xx status code
func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications exposed data records v1 unauthorized response has a 3xx status code
func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications exposed data records v1 unauthorized response has a 4xx status code
func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this query notifications exposed data records v1 unauthorized response has a 5xx status code
func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications exposed data records v1 unauthorized response a status code equal to that given
func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the query notifications exposed data records v1 unauthorized response
func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) Code() int {
	return 401
}

func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryNotificationsExposedDataRecordsV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsExposedDataRecordsV1Forbidden creates a QueryNotificationsExposedDataRecordsV1Forbidden with default headers values
func NewQueryNotificationsExposedDataRecordsV1Forbidden() *QueryNotificationsExposedDataRecordsV1Forbidden {
	return &QueryNotificationsExposedDataRecordsV1Forbidden{}
}

/*
QueryNotificationsExposedDataRecordsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryNotificationsExposedDataRecordsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query notifications exposed data records v1 forbidden response has a 2xx status code
func (o *QueryNotificationsExposedDataRecordsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications exposed data records v1 forbidden response has a 3xx status code
func (o *QueryNotificationsExposedDataRecordsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications exposed data records v1 forbidden response has a 4xx status code
func (o *QueryNotificationsExposedDataRecordsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query notifications exposed data records v1 forbidden response has a 5xx status code
func (o *QueryNotificationsExposedDataRecordsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications exposed data records v1 forbidden response a status code equal to that given
func (o *QueryNotificationsExposedDataRecordsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query notifications exposed data records v1 forbidden response
func (o *QueryNotificationsExposedDataRecordsV1Forbidden) Code() int {
	return 403
}

func (o *QueryNotificationsExposedDataRecordsV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1Forbidden  %+v", 403, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1Forbidden) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1Forbidden  %+v", 403, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryNotificationsExposedDataRecordsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsExposedDataRecordsV1TooManyRequests creates a QueryNotificationsExposedDataRecordsV1TooManyRequests with default headers values
func NewQueryNotificationsExposedDataRecordsV1TooManyRequests() *QueryNotificationsExposedDataRecordsV1TooManyRequests {
	return &QueryNotificationsExposedDataRecordsV1TooManyRequests{}
}

/*
QueryNotificationsExposedDataRecordsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryNotificationsExposedDataRecordsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query notifications exposed data records v1 too many requests response has a 2xx status code
func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications exposed data records v1 too many requests response has a 3xx status code
func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications exposed data records v1 too many requests response has a 4xx status code
func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query notifications exposed data records v1 too many requests response has a 5xx status code
func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications exposed data records v1 too many requests response a status code equal to that given
func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query notifications exposed data records v1 too many requests response
func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) Code() int {
	return 429
}

func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryNotificationsExposedDataRecordsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsExposedDataRecordsV1InternalServerError creates a QueryNotificationsExposedDataRecordsV1InternalServerError with default headers values
func NewQueryNotificationsExposedDataRecordsV1InternalServerError() *QueryNotificationsExposedDataRecordsV1InternalServerError {
	return &QueryNotificationsExposedDataRecordsV1InternalServerError{}
}

/*
QueryNotificationsExposedDataRecordsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryNotificationsExposedDataRecordsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query notifications exposed data records v1 internal server error response has a 2xx status code
func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications exposed data records v1 internal server error response has a 3xx status code
func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications exposed data records v1 internal server error response has a 4xx status code
func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query notifications exposed data records v1 internal server error response has a 5xx status code
func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query notifications exposed data records v1 internal server error response a status code equal to that given
func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query notifications exposed data records v1 internal server error response
func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) Code() int {
	return 500
}

func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications-exposed-data-records/v1][%d] queryNotificationsExposedDataRecordsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryNotificationsExposedDataRecordsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
