// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryNotificationsV1Reader is a Reader for the QueryNotificationsV1 structure.
type QueryNotificationsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryNotificationsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryNotificationsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryNotificationsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewQueryNotificationsV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryNotificationsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryNotificationsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryNotificationsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /recon/queries/notifications/v1] QueryNotificationsV1", response, response.Code())
	}
}

// NewQueryNotificationsV1OK creates a QueryNotificationsV1OK with default headers values
func NewQueryNotificationsV1OK() *QueryNotificationsV1OK {
	return &QueryNotificationsV1OK{}
}

/*
QueryNotificationsV1OK describes a response with status code 200, with default header values.

OK
*/
type QueryNotificationsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainQueryResponse
}

// IsSuccess returns true when this query notifications v1 o k response has a 2xx status code
func (o *QueryNotificationsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query notifications v1 o k response has a 3xx status code
func (o *QueryNotificationsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications v1 o k response has a 4xx status code
func (o *QueryNotificationsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query notifications v1 o k response has a 5xx status code
func (o *QueryNotificationsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications v1 o k response a status code equal to that given
func (o *QueryNotificationsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query notifications v1 o k response
func (o *QueryNotificationsV1OK) Code() int {
	return 200
}

func (o *QueryNotificationsV1OK) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1OK  %+v", 200, o.Payload)
}

func (o *QueryNotificationsV1OK) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1OK  %+v", 200, o.Payload)
}

func (o *QueryNotificationsV1OK) GetPayload() *models.DomainQueryResponse {
	return o.Payload
}

func (o *QueryNotificationsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsV1BadRequest creates a QueryNotificationsV1BadRequest with default headers values
func NewQueryNotificationsV1BadRequest() *QueryNotificationsV1BadRequest {
	return &QueryNotificationsV1BadRequest{}
}

/*
QueryNotificationsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryNotificationsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query notifications v1 bad request response has a 2xx status code
func (o *QueryNotificationsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications v1 bad request response has a 3xx status code
func (o *QueryNotificationsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications v1 bad request response has a 4xx status code
func (o *QueryNotificationsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query notifications v1 bad request response has a 5xx status code
func (o *QueryNotificationsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications v1 bad request response a status code equal to that given
func (o *QueryNotificationsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query notifications v1 bad request response
func (o *QueryNotificationsV1BadRequest) Code() int {
	return 400
}

func (o *QueryNotificationsV1BadRequest) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1BadRequest  %+v", 400, o.Payload)
}

func (o *QueryNotificationsV1BadRequest) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1BadRequest  %+v", 400, o.Payload)
}

func (o *QueryNotificationsV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryNotificationsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsV1Unauthorized creates a QueryNotificationsV1Unauthorized with default headers values
func NewQueryNotificationsV1Unauthorized() *QueryNotificationsV1Unauthorized {
	return &QueryNotificationsV1Unauthorized{}
}

/*
QueryNotificationsV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type QueryNotificationsV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query notifications v1 unauthorized response has a 2xx status code
func (o *QueryNotificationsV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications v1 unauthorized response has a 3xx status code
func (o *QueryNotificationsV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications v1 unauthorized response has a 4xx status code
func (o *QueryNotificationsV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this query notifications v1 unauthorized response has a 5xx status code
func (o *QueryNotificationsV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications v1 unauthorized response a status code equal to that given
func (o *QueryNotificationsV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the query notifications v1 unauthorized response
func (o *QueryNotificationsV1Unauthorized) Code() int {
	return 401
}

func (o *QueryNotificationsV1Unauthorized) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *QueryNotificationsV1Unauthorized) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *QueryNotificationsV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryNotificationsV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsV1Forbidden creates a QueryNotificationsV1Forbidden with default headers values
func NewQueryNotificationsV1Forbidden() *QueryNotificationsV1Forbidden {
	return &QueryNotificationsV1Forbidden{}
}

/*
QueryNotificationsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryNotificationsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query notifications v1 forbidden response has a 2xx status code
func (o *QueryNotificationsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications v1 forbidden response has a 3xx status code
func (o *QueryNotificationsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications v1 forbidden response has a 4xx status code
func (o *QueryNotificationsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query notifications v1 forbidden response has a 5xx status code
func (o *QueryNotificationsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications v1 forbidden response a status code equal to that given
func (o *QueryNotificationsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query notifications v1 forbidden response
func (o *QueryNotificationsV1Forbidden) Code() int {
	return 403
}

func (o *QueryNotificationsV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1Forbidden  %+v", 403, o.Payload)
}

func (o *QueryNotificationsV1Forbidden) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1Forbidden  %+v", 403, o.Payload)
}

func (o *QueryNotificationsV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryNotificationsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsV1TooManyRequests creates a QueryNotificationsV1TooManyRequests with default headers values
func NewQueryNotificationsV1TooManyRequests() *QueryNotificationsV1TooManyRequests {
	return &QueryNotificationsV1TooManyRequests{}
}

/*
QueryNotificationsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryNotificationsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query notifications v1 too many requests response has a 2xx status code
func (o *QueryNotificationsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications v1 too many requests response has a 3xx status code
func (o *QueryNotificationsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications v1 too many requests response has a 4xx status code
func (o *QueryNotificationsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query notifications v1 too many requests response has a 5xx status code
func (o *QueryNotificationsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query notifications v1 too many requests response a status code equal to that given
func (o *QueryNotificationsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query notifications v1 too many requests response
func (o *QueryNotificationsV1TooManyRequests) Code() int {
	return 429
}

func (o *QueryNotificationsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryNotificationsV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryNotificationsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryNotificationsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryNotificationsV1InternalServerError creates a QueryNotificationsV1InternalServerError with default headers values
func NewQueryNotificationsV1InternalServerError() *QueryNotificationsV1InternalServerError {
	return &QueryNotificationsV1InternalServerError{}
}

/*
QueryNotificationsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryNotificationsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query notifications v1 internal server error response has a 2xx status code
func (o *QueryNotificationsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query notifications v1 internal server error response has a 3xx status code
func (o *QueryNotificationsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query notifications v1 internal server error response has a 4xx status code
func (o *QueryNotificationsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query notifications v1 internal server error response has a 5xx status code
func (o *QueryNotificationsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query notifications v1 internal server error response a status code equal to that given
func (o *QueryNotificationsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query notifications v1 internal server error response
func (o *QueryNotificationsV1InternalServerError) Code() int {
	return 500
}

func (o *QueryNotificationsV1InternalServerError) Error() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryNotificationsV1InternalServerError) String() string {
	return fmt.Sprintf("[GET /recon/queries/notifications/v1][%d] queryNotificationsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryNotificationsV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryNotificationsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
