// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryRulesV1Reader is a Reader for the QueryRulesV1 structure.
type QueryRulesV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryRulesV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryRulesV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryRulesV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewQueryRulesV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryRulesV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryRulesV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryRulesV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /recon/queries/rules/v1] QueryRulesV1", response, response.Code())
	}
}

// NewQueryRulesV1OK creates a QueryRulesV1OK with default headers values
func NewQueryRulesV1OK() *QueryRulesV1OK {
	return &QueryRulesV1OK{}
}

/*
QueryRulesV1OK describes a response with status code 200, with default header values.

OK
*/
type QueryRulesV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainRuleQueryResponseV1
}

// IsSuccess returns true when this query rules v1 o k response has a 2xx status code
func (o *QueryRulesV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query rules v1 o k response has a 3xx status code
func (o *QueryRulesV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query rules v1 o k response has a 4xx status code
func (o *QueryRulesV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query rules v1 o k response has a 5xx status code
func (o *QueryRulesV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this query rules v1 o k response a status code equal to that given
func (o *QueryRulesV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query rules v1 o k response
func (o *QueryRulesV1OK) Code() int {
	return 200
}

func (o *QueryRulesV1OK) Error() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1OK  %+v", 200, o.Payload)
}

func (o *QueryRulesV1OK) String() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1OK  %+v", 200, o.Payload)
}

func (o *QueryRulesV1OK) GetPayload() *models.DomainRuleQueryResponseV1 {
	return o.Payload
}

func (o *QueryRulesV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainRuleQueryResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRulesV1BadRequest creates a QueryRulesV1BadRequest with default headers values
func NewQueryRulesV1BadRequest() *QueryRulesV1BadRequest {
	return &QueryRulesV1BadRequest{}
}

/*
QueryRulesV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryRulesV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query rules v1 bad request response has a 2xx status code
func (o *QueryRulesV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query rules v1 bad request response has a 3xx status code
func (o *QueryRulesV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query rules v1 bad request response has a 4xx status code
func (o *QueryRulesV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query rules v1 bad request response has a 5xx status code
func (o *QueryRulesV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query rules v1 bad request response a status code equal to that given
func (o *QueryRulesV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query rules v1 bad request response
func (o *QueryRulesV1BadRequest) Code() int {
	return 400
}

func (o *QueryRulesV1BadRequest) Error() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1BadRequest  %+v", 400, o.Payload)
}

func (o *QueryRulesV1BadRequest) String() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1BadRequest  %+v", 400, o.Payload)
}

func (o *QueryRulesV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryRulesV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRulesV1Unauthorized creates a QueryRulesV1Unauthorized with default headers values
func NewQueryRulesV1Unauthorized() *QueryRulesV1Unauthorized {
	return &QueryRulesV1Unauthorized{}
}

/*
QueryRulesV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type QueryRulesV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query rules v1 unauthorized response has a 2xx status code
func (o *QueryRulesV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query rules v1 unauthorized response has a 3xx status code
func (o *QueryRulesV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query rules v1 unauthorized response has a 4xx status code
func (o *QueryRulesV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this query rules v1 unauthorized response has a 5xx status code
func (o *QueryRulesV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this query rules v1 unauthorized response a status code equal to that given
func (o *QueryRulesV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the query rules v1 unauthorized response
func (o *QueryRulesV1Unauthorized) Code() int {
	return 401
}

func (o *QueryRulesV1Unauthorized) Error() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1Unauthorized  %+v", 401, o.Payload)
}

func (o *QueryRulesV1Unauthorized) String() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1Unauthorized  %+v", 401, o.Payload)
}

func (o *QueryRulesV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryRulesV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRulesV1Forbidden creates a QueryRulesV1Forbidden with default headers values
func NewQueryRulesV1Forbidden() *QueryRulesV1Forbidden {
	return &QueryRulesV1Forbidden{}
}

/*
QueryRulesV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryRulesV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query rules v1 forbidden response has a 2xx status code
func (o *QueryRulesV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query rules v1 forbidden response has a 3xx status code
func (o *QueryRulesV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query rules v1 forbidden response has a 4xx status code
func (o *QueryRulesV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query rules v1 forbidden response has a 5xx status code
func (o *QueryRulesV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query rules v1 forbidden response a status code equal to that given
func (o *QueryRulesV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query rules v1 forbidden response
func (o *QueryRulesV1Forbidden) Code() int {
	return 403
}

func (o *QueryRulesV1Forbidden) Error() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1Forbidden  %+v", 403, o.Payload)
}

func (o *QueryRulesV1Forbidden) String() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1Forbidden  %+v", 403, o.Payload)
}

func (o *QueryRulesV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryRulesV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRulesV1TooManyRequests creates a QueryRulesV1TooManyRequests with default headers values
func NewQueryRulesV1TooManyRequests() *QueryRulesV1TooManyRequests {
	return &QueryRulesV1TooManyRequests{}
}

/*
QueryRulesV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryRulesV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query rules v1 too many requests response has a 2xx status code
func (o *QueryRulesV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query rules v1 too many requests response has a 3xx status code
func (o *QueryRulesV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query rules v1 too many requests response has a 4xx status code
func (o *QueryRulesV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query rules v1 too many requests response has a 5xx status code
func (o *QueryRulesV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query rules v1 too many requests response a status code equal to that given
func (o *QueryRulesV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query rules v1 too many requests response
func (o *QueryRulesV1TooManyRequests) Code() int {
	return 429
}

func (o *QueryRulesV1TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryRulesV1TooManyRequests) String() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryRulesV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryRulesV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRulesV1InternalServerError creates a QueryRulesV1InternalServerError with default headers values
func NewQueryRulesV1InternalServerError() *QueryRulesV1InternalServerError {
	return &QueryRulesV1InternalServerError{}
}

/*
QueryRulesV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryRulesV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this query rules v1 internal server error response has a 2xx status code
func (o *QueryRulesV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query rules v1 internal server error response has a 3xx status code
func (o *QueryRulesV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query rules v1 internal server error response has a 4xx status code
func (o *QueryRulesV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query rules v1 internal server error response has a 5xx status code
func (o *QueryRulesV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query rules v1 internal server error response a status code equal to that given
func (o *QueryRulesV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query rules v1 internal server error response
func (o *QueryRulesV1InternalServerError) Code() int {
	return 500
}

func (o *QueryRulesV1InternalServerError) Error() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryRulesV1InternalServerError) String() string {
	return fmt.Sprintf("[GET /recon/queries/rules/v1][%d] queryRulesV1InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryRulesV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *QueryRulesV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
