// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new recon API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for recon API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AggregateNotificationsExposedDataRecordsV1(params *AggregateNotificationsExposedDataRecordsV1Params, opts ...ClientOption) (*AggregateNotificationsExposedDataRecordsV1OK, error)

	AggregateNotificationsV1(params *AggregateNotificationsV1Params, opts ...ClientOption) (*AggregateNotificationsV1OK, error)

	CreateActionsV1(params *CreateActionsV1Params, opts ...ClientOption) (*CreateActionsV1OK, error)

	CreateExportJobsV1(params *CreateExportJobsV1Params, opts ...ClientOption) (*CreateExportJobsV1OK, error)

	CreateRulesV1(params *CreateRulesV1Params, opts ...ClientOption) (*CreateRulesV1OK, error)

	DeleteActionV1(params *DeleteActionV1Params, opts ...ClientOption) (*DeleteActionV1OK, error)

	DeleteExportJobsV1(params *DeleteExportJobsV1Params, opts ...ClientOption) (*DeleteExportJobsV1OK, error)

	DeleteNotificationsV1(params *DeleteNotificationsV1Params, opts ...ClientOption) (*DeleteNotificationsV1OK, error)

	DeleteRulesV1(params *DeleteRulesV1Params, opts ...ClientOption) (*DeleteRulesV1OK, error)

	GetActionsV1(params *GetActionsV1Params, opts ...ClientOption) (*GetActionsV1OK, error)

	GetExportJobsV1(params *GetExportJobsV1Params, opts ...ClientOption) (*GetExportJobsV1OK, error)

	GetFileContentForExportJobsV1(params *GetFileContentForExportJobsV1Params, opts ...ClientOption) (*GetFileContentForExportJobsV1OK, error)

	GetNotificationsDetailedTranslatedV1(params *GetNotificationsDetailedTranslatedV1Params, opts ...ClientOption) (*GetNotificationsDetailedTranslatedV1OK, error)

	GetNotificationsDetailedV1(params *GetNotificationsDetailedV1Params, opts ...ClientOption) (*GetNotificationsDetailedV1OK, error)

	GetNotificationsExposedDataRecordsV1(params *GetNotificationsExposedDataRecordsV1Params, opts ...ClientOption) (*GetNotificationsExposedDataRecordsV1OK, error)

	GetNotificationsTranslatedV1(params *GetNotificationsTranslatedV1Params, opts ...ClientOption) (*GetNotificationsTranslatedV1OK, error)

	GetNotificationsV1(params *GetNotificationsV1Params, opts ...ClientOption) (*GetNotificationsV1OK, error)

	GetRulesV1(params *GetRulesV1Params, opts ...ClientOption) (*GetRulesV1OK, error)

	PreviewRuleV1(params *PreviewRuleV1Params, opts ...ClientOption) (*PreviewRuleV1OK, error)

	QueryActionsV1(params *QueryActionsV1Params, opts ...ClientOption) (*QueryActionsV1OK, error)

	QueryNotificationsExposedDataRecordsV1(params *QueryNotificationsExposedDataRecordsV1Params, opts ...ClientOption) (*QueryNotificationsExposedDataRecordsV1OK, error)

	QueryNotificationsV1(params *QueryNotificationsV1Params, opts ...ClientOption) (*QueryNotificationsV1OK, error)

	QueryRulesV1(params *QueryRulesV1Params, opts ...ClientOption) (*QueryRulesV1OK, error)

	UpdateActionV1(params *UpdateActionV1Params, opts ...ClientOption) (*UpdateActionV1OK, error)

	UpdateNotificationsV1(params *UpdateNotificationsV1Params, opts ...ClientOption) (*UpdateNotificationsV1OK, error)

	UpdateRulesV1(params *UpdateRulesV1Params, opts ...ClientOption) (*UpdateRulesV1OK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AggregateNotificationsExposedDataRecordsV1 gets notification exposed data record aggregates as specified via JSON in request body the valid aggregation fields are cid notification id created date rule id rule name rule topic source category site author file name
*/
func (a *Client) AggregateNotificationsExposedDataRecordsV1(params *AggregateNotificationsExposedDataRecordsV1Params, opts ...ClientOption) (*AggregateNotificationsExposedDataRecordsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateNotificationsExposedDataRecordsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateNotificationsExposedDataRecordsV1",
		Method:             "POST",
		PathPattern:        "/recon/aggregates/notifications-exposed-data-records/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateNotificationsExposedDataRecordsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateNotificationsExposedDataRecordsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateNotificationsExposedDataRecordsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
AggregateNotificationsV1 gets notification aggregates as specified via JSON in request body
*/
func (a *Client) AggregateNotificationsV1(params *AggregateNotificationsV1Params, opts ...ClientOption) (*AggregateNotificationsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAggregateNotificationsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "AggregateNotificationsV1",
		Method:             "POST",
		PathPattern:        "/recon/aggregates/notifications/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AggregateNotificationsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AggregateNotificationsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for AggregateNotificationsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateActionsV1 creates actions for a monitoring rule accepts a list of actions that will be attached to the monitoring rule
*/
func (a *Client) CreateActionsV1(params *CreateActionsV1Params, opts ...ClientOption) (*CreateActionsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateActionsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateActionsV1",
		Method:             "POST",
		PathPattern:        "/recon/entities/actions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateActionsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateActionsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CreateActionsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateExportJobsV1 launches asynchronous export job use the job ID to poll the status of the job using g e t entities exports v1
*/
func (a *Client) CreateExportJobsV1(params *CreateExportJobsV1Params, opts ...ClientOption) (*CreateExportJobsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateExportJobsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateExportJobsV1",
		Method:             "POST",
		PathPattern:        "/recon/entities/exports/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateExportJobsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateExportJobsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CreateExportJobsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
CreateRulesV1 creates monitoring rules
*/
func (a *Client) CreateRulesV1(params *CreateRulesV1Params, opts ...ClientOption) (*CreateRulesV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRulesV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateRulesV1",
		Method:             "POST",
		PathPattern:        "/recon/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateRulesV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRulesV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for CreateRulesV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteActionV1 deletes an action from a monitoring rule based on the action ID
*/
func (a *Client) DeleteActionV1(params *DeleteActionV1Params, opts ...ClientOption) (*DeleteActionV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteActionV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteActionV1",
		Method:             "DELETE",
		PathPattern:        "/recon/entities/actions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteActionV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteActionV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteActionV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteExportJobsV1 deletes export jobs and their associated file s based on their i ds
*/
func (a *Client) DeleteExportJobsV1(params *DeleteExportJobsV1Params, opts ...ClientOption) (*DeleteExportJobsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteExportJobsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteExportJobsV1",
		Method:             "DELETE",
		PathPattern:        "/recon/entities/exports/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteExportJobsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteExportJobsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteExportJobsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteNotificationsV1 deletes notifications based on i ds notifications cannot be recovered after they are deleted
*/
func (a *Client) DeleteNotificationsV1(params *DeleteNotificationsV1Params, opts ...ClientOption) (*DeleteNotificationsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteNotificationsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteNotificationsV1",
		Method:             "DELETE",
		PathPattern:        "/recon/entities/notifications/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteNotificationsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteNotificationsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteNotificationsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteRulesV1 deletes monitoring rules
*/
func (a *Client) DeleteRulesV1(params *DeleteRulesV1Params, opts ...ClientOption) (*DeleteRulesV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRulesV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteRulesV1",
		Method:             "DELETE",
		PathPattern:        "/recon/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DeleteRulesV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRulesV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DeleteRulesV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetActionsV1 gets actions based on their i ds i ds can be retrieved using the g e t queries actions v1 endpoint
*/
func (a *Client) GetActionsV1(params *GetActionsV1Params, opts ...ClientOption) (*GetActionsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetActionsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetActionsV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/actions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetActionsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetActionsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetActionsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetExportJobsV1 gets the status of export jobs based on their i ds export jobs can be launched by calling p o s t entities exports v1 when a job is complete use the job ID to download the file s associated with it using g e t entities export files v1
*/
func (a *Client) GetExportJobsV1(params *GetExportJobsV1Params, opts ...ClientOption) (*GetExportJobsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetExportJobsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetExportJobsV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/exports/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetExportJobsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetExportJobsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetExportJobsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetFileContentForExportJobsV1 downloads the file associated with a job ID
*/
func (a *Client) GetFileContentForExportJobsV1(params *GetFileContentForExportJobsV1Params, opts ...ClientOption) (*GetFileContentForExportJobsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetFileContentForExportJobsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetFileContentForExportJobsV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/export-files/v1",
		ProducesMediaTypes: []string{"application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetFileContentForExportJobsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetFileContentForExportJobsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetFileContentForExportJobsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetNotificationsDetailedTranslatedV1 gets detailed notifications based on their i ds these include the raw intelligence content that generated the match this endpoint will return translated notification content the only target language available is english a single notification can be translated per request
*/
func (a *Client) GetNotificationsDetailedTranslatedV1(params *GetNotificationsDetailedTranslatedV1Params, opts ...ClientOption) (*GetNotificationsDetailedTranslatedV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetNotificationsDetailedTranslatedV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetNotificationsDetailedTranslatedV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/notifications-detailed-translated/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetNotificationsDetailedTranslatedV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetNotificationsDetailedTranslatedV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetNotificationsDetailedTranslatedV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetNotificationsDetailedV1 gets detailed notifications based on their i ds these include the raw intelligence content that generated the match
*/
func (a *Client) GetNotificationsDetailedV1(params *GetNotificationsDetailedV1Params, opts ...ClientOption) (*GetNotificationsDetailedV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetNotificationsDetailedV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetNotificationsDetailedV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/notifications-detailed/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetNotificationsDetailedV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetNotificationsDetailedV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetNotificationsDetailedV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetNotificationsExposedDataRecordsV1 gets notifications exposed data records based on their i ds i ds can be retrieved using the g e t queries notifications exposed data records v1 endpoint the associate notification can be fetched using the entities notifications v endpoints
*/
func (a *Client) GetNotificationsExposedDataRecordsV1(params *GetNotificationsExposedDataRecordsV1Params, opts ...ClientOption) (*GetNotificationsExposedDataRecordsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetNotificationsExposedDataRecordsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetNotificationsExposedDataRecordsV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/notifications-exposed-data-records/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetNotificationsExposedDataRecordsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetNotificationsExposedDataRecordsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetNotificationsExposedDataRecordsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetNotificationsTranslatedV1 gets notifications based on their i ds i ds can be retrieved using the g e t queries notifications v1 endpoint this endpoint will return translated notification content the only target language available is english
*/
func (a *Client) GetNotificationsTranslatedV1(params *GetNotificationsTranslatedV1Params, opts ...ClientOption) (*GetNotificationsTranslatedV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetNotificationsTranslatedV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetNotificationsTranslatedV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/notifications-translated/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetNotificationsTranslatedV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetNotificationsTranslatedV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetNotificationsTranslatedV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetNotificationsV1 gets notifications based on their i ds i ds can be retrieved using the g e t queries notifications v1 endpoint
*/
func (a *Client) GetNotificationsV1(params *GetNotificationsV1Params, opts ...ClientOption) (*GetNotificationsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetNotificationsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetNotificationsV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/notifications/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetNotificationsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetNotificationsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetNotificationsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetRulesV1 gets monitoring rules based on their i ds i ds can be retrieved using the g e t queries rules v1 endpoint
*/
func (a *Client) GetRulesV1(params *GetRulesV1Params, opts ...ClientOption) (*GetRulesV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRulesV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetRulesV1",
		Method:             "GET",
		PathPattern:        "/recon/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetRulesV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRulesV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetRulesV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
PreviewRuleV1 previews rules notification count and distribution this will return aggregations on channel count site
*/
func (a *Client) PreviewRuleV1(params *PreviewRuleV1Params, opts ...ClientOption) (*PreviewRuleV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPreviewRuleV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "PreviewRuleV1",
		Method:             "POST",
		PathPattern:        "/recon/aggregates/rules-preview/GET/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PreviewRuleV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PreviewRuleV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for PreviewRuleV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryActionsV1 queries actions based on provided criteria use the i ds from this response to get the action entities on g e t entities actions v1
*/
func (a *Client) QueryActionsV1(params *QueryActionsV1Params, opts ...ClientOption) (*QueryActionsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryActionsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryActionsV1",
		Method:             "GET",
		PathPattern:        "/recon/queries/actions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryActionsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryActionsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryActionsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryNotificationsExposedDataRecordsV1 queries notifications exposed data records based on provided criteria use the i ds from this response to get the notification entities on g e t entities notifications exposed data records v1
*/
func (a *Client) QueryNotificationsExposedDataRecordsV1(params *QueryNotificationsExposedDataRecordsV1Params, opts ...ClientOption) (*QueryNotificationsExposedDataRecordsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryNotificationsExposedDataRecordsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryNotificationsExposedDataRecordsV1",
		Method:             "GET",
		PathPattern:        "/recon/queries/notifications-exposed-data-records/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryNotificationsExposedDataRecordsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryNotificationsExposedDataRecordsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryNotificationsExposedDataRecordsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryNotificationsV1 queries notifications based on provided criteria use the i ds from this response to get the notification entities on g e t entities notifications v1 g e t entities notifications detailed v1 g e t entities notifications translated v1 or g e t entities notifications detailed translated v1
*/
func (a *Client) QueryNotificationsV1(params *QueryNotificationsV1Params, opts ...ClientOption) (*QueryNotificationsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryNotificationsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryNotificationsV1",
		Method:             "GET",
		PathPattern:        "/recon/queries/notifications/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryNotificationsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryNotificationsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryNotificationsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryRulesV1 queries monitoring rules based on provided criteria use the i ds from this response to fetch the rules on entities rules v1
*/
func (a *Client) QueryRulesV1(params *QueryRulesV1Params, opts ...ClientOption) (*QueryRulesV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewQueryRulesV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "QueryRulesV1",
		Method:             "GET",
		PathPattern:        "/recon/queries/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &QueryRulesV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryRulesV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for QueryRulesV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateActionV1 updates an action for a monitoring rule
*/
func (a *Client) UpdateActionV1(params *UpdateActionV1Params, opts ...ClientOption) (*UpdateActionV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateActionV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateActionV1",
		Method:             "PATCH",
		PathPattern:        "/recon/entities/actions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateActionV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateActionV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for UpdateActionV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateNotificationsV1 updates notification status or assignee accepts bulk requests
*/
func (a *Client) UpdateNotificationsV1(params *UpdateNotificationsV1Params, opts ...ClientOption) (*UpdateNotificationsV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateNotificationsV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateNotificationsV1",
		Method:             "PATCH",
		PathPattern:        "/recon/entities/notifications/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateNotificationsV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateNotificationsV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for UpdateNotificationsV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateRulesV1 updates monitoring rules
*/
func (a *Client) UpdateRulesV1(params *UpdateRulesV1Params, opts ...ClientOption) (*UpdateRulesV1OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRulesV1Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateRulesV1",
		Method:             "PATCH",
		PathPattern:        "/recon/entities/rules/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &UpdateRulesV1Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRulesV1OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for UpdateRulesV1: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
