// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateNotificationsV1Reader is a Reader for the UpdateNotificationsV1 structure.
type UpdateNotificationsV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateNotificationsV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateNotificationsV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateNotificationsV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateNotificationsV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateNotificationsV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateNotificationsV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateNotificationsV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /recon/entities/notifications/v1] UpdateNotificationsV1", response, response.Code())
	}
}

// NewUpdateNotificationsV1OK creates a UpdateNotificationsV1OK with default headers values
func NewUpdateNotificationsV1OK() *UpdateNotificationsV1OK {
	return &UpdateNotificationsV1OK{}
}

/*
UpdateNotificationsV1OK describes a response with status code 200, with default header values.

OK
*/
type UpdateNotificationsV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainNotificationEntitiesResponseV1
}

// IsSuccess returns true when this update notifications v1 o k response has a 2xx status code
func (o *UpdateNotificationsV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update notifications v1 o k response has a 3xx status code
func (o *UpdateNotificationsV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update notifications v1 o k response has a 4xx status code
func (o *UpdateNotificationsV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update notifications v1 o k response has a 5xx status code
func (o *UpdateNotificationsV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this update notifications v1 o k response a status code equal to that given
func (o *UpdateNotificationsV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update notifications v1 o k response
func (o *UpdateNotificationsV1OK) Code() int {
	return 200
}

func (o *UpdateNotificationsV1OK) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1OK  %+v", 200, o.Payload)
}

func (o *UpdateNotificationsV1OK) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1OK  %+v", 200, o.Payload)
}

func (o *UpdateNotificationsV1OK) GetPayload() *models.DomainNotificationEntitiesResponseV1 {
	return o.Payload
}

func (o *UpdateNotificationsV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainNotificationEntitiesResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNotificationsV1BadRequest creates a UpdateNotificationsV1BadRequest with default headers values
func NewUpdateNotificationsV1BadRequest() *UpdateNotificationsV1BadRequest {
	return &UpdateNotificationsV1BadRequest{}
}

/*
UpdateNotificationsV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateNotificationsV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this update notifications v1 bad request response has a 2xx status code
func (o *UpdateNotificationsV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update notifications v1 bad request response has a 3xx status code
func (o *UpdateNotificationsV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update notifications v1 bad request response has a 4xx status code
func (o *UpdateNotificationsV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update notifications v1 bad request response has a 5xx status code
func (o *UpdateNotificationsV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update notifications v1 bad request response a status code equal to that given
func (o *UpdateNotificationsV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update notifications v1 bad request response
func (o *UpdateNotificationsV1BadRequest) Code() int {
	return 400
}

func (o *UpdateNotificationsV1BadRequest) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1BadRequest  %+v", 400, o.Payload)
}

func (o *UpdateNotificationsV1BadRequest) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1BadRequest  %+v", 400, o.Payload)
}

func (o *UpdateNotificationsV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *UpdateNotificationsV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNotificationsV1Unauthorized creates a UpdateNotificationsV1Unauthorized with default headers values
func NewUpdateNotificationsV1Unauthorized() *UpdateNotificationsV1Unauthorized {
	return &UpdateNotificationsV1Unauthorized{}
}

/*
UpdateNotificationsV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type UpdateNotificationsV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this update notifications v1 unauthorized response has a 2xx status code
func (o *UpdateNotificationsV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update notifications v1 unauthorized response has a 3xx status code
func (o *UpdateNotificationsV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update notifications v1 unauthorized response has a 4xx status code
func (o *UpdateNotificationsV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update notifications v1 unauthorized response has a 5xx status code
func (o *UpdateNotificationsV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update notifications v1 unauthorized response a status code equal to that given
func (o *UpdateNotificationsV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update notifications v1 unauthorized response
func (o *UpdateNotificationsV1Unauthorized) Code() int {
	return 401
}

func (o *UpdateNotificationsV1Unauthorized) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *UpdateNotificationsV1Unauthorized) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1Unauthorized  %+v", 401, o.Payload)
}

func (o *UpdateNotificationsV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *UpdateNotificationsV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNotificationsV1Forbidden creates a UpdateNotificationsV1Forbidden with default headers values
func NewUpdateNotificationsV1Forbidden() *UpdateNotificationsV1Forbidden {
	return &UpdateNotificationsV1Forbidden{}
}

/*
UpdateNotificationsV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateNotificationsV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this update notifications v1 forbidden response has a 2xx status code
func (o *UpdateNotificationsV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update notifications v1 forbidden response has a 3xx status code
func (o *UpdateNotificationsV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update notifications v1 forbidden response has a 4xx status code
func (o *UpdateNotificationsV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update notifications v1 forbidden response has a 5xx status code
func (o *UpdateNotificationsV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update notifications v1 forbidden response a status code equal to that given
func (o *UpdateNotificationsV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update notifications v1 forbidden response
func (o *UpdateNotificationsV1Forbidden) Code() int {
	return 403
}

func (o *UpdateNotificationsV1Forbidden) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1Forbidden  %+v", 403, o.Payload)
}

func (o *UpdateNotificationsV1Forbidden) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1Forbidden  %+v", 403, o.Payload)
}

func (o *UpdateNotificationsV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *UpdateNotificationsV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNotificationsV1TooManyRequests creates a UpdateNotificationsV1TooManyRequests with default headers values
func NewUpdateNotificationsV1TooManyRequests() *UpdateNotificationsV1TooManyRequests {
	return &UpdateNotificationsV1TooManyRequests{}
}

/*
UpdateNotificationsV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateNotificationsV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update notifications v1 too many requests response has a 2xx status code
func (o *UpdateNotificationsV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update notifications v1 too many requests response has a 3xx status code
func (o *UpdateNotificationsV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update notifications v1 too many requests response has a 4xx status code
func (o *UpdateNotificationsV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update notifications v1 too many requests response has a 5xx status code
func (o *UpdateNotificationsV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update notifications v1 too many requests response a status code equal to that given
func (o *UpdateNotificationsV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update notifications v1 too many requests response
func (o *UpdateNotificationsV1TooManyRequests) Code() int {
	return 429
}

func (o *UpdateNotificationsV1TooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateNotificationsV1TooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateNotificationsV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateNotificationsV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateNotificationsV1InternalServerError creates a UpdateNotificationsV1InternalServerError with default headers values
func NewUpdateNotificationsV1InternalServerError() *UpdateNotificationsV1InternalServerError {
	return &UpdateNotificationsV1InternalServerError{}
}

/*
UpdateNotificationsV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateNotificationsV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this update notifications v1 internal server error response has a 2xx status code
func (o *UpdateNotificationsV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update notifications v1 internal server error response has a 3xx status code
func (o *UpdateNotificationsV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update notifications v1 internal server error response has a 4xx status code
func (o *UpdateNotificationsV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update notifications v1 internal server error response has a 5xx status code
func (o *UpdateNotificationsV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update notifications v1 internal server error response a status code equal to that given
func (o *UpdateNotificationsV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update notifications v1 internal server error response
func (o *UpdateNotificationsV1InternalServerError) Code() int {
	return 500
}

func (o *UpdateNotificationsV1InternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateNotificationsV1InternalServerError) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/notifications/v1][%d] updateNotificationsV1InternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateNotificationsV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *UpdateNotificationsV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
