// Code generated by go-swagger; DO NOT EDIT.

package recon

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateRulesV1Reader is a Reader for the UpdateRulesV1 structure.
type UpdateRulesV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateRulesV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateRulesV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateRulesV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateRulesV1Unauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateRulesV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateRulesV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateRulesV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /recon/entities/rules/v1] UpdateRulesV1", response, response.Code())
	}
}

// NewUpdateRulesV1OK creates a UpdateRulesV1OK with default headers values
func NewUpdateRulesV1OK() *UpdateRulesV1OK {
	return &UpdateRulesV1OK{}
}

/*
UpdateRulesV1OK describes a response with status code 200, with default header values.

OK
*/
type UpdateRulesV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainRulesEntitiesResponseV1
}

// IsSuccess returns true when this update rules v1 o k response has a 2xx status code
func (o *UpdateRulesV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update rules v1 o k response has a 3xx status code
func (o *UpdateRulesV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update rules v1 o k response has a 4xx status code
func (o *UpdateRulesV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update rules v1 o k response has a 5xx status code
func (o *UpdateRulesV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this update rules v1 o k response a status code equal to that given
func (o *UpdateRulesV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update rules v1 o k response
func (o *UpdateRulesV1OK) Code() int {
	return 200
}

func (o *UpdateRulesV1OK) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1OK  %+v", 200, o.Payload)
}

func (o *UpdateRulesV1OK) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1OK  %+v", 200, o.Payload)
}

func (o *UpdateRulesV1OK) GetPayload() *models.DomainRulesEntitiesResponseV1 {
	return o.Payload
}

func (o *UpdateRulesV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainRulesEntitiesResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRulesV1BadRequest creates a UpdateRulesV1BadRequest with default headers values
func NewUpdateRulesV1BadRequest() *UpdateRulesV1BadRequest {
	return &UpdateRulesV1BadRequest{}
}

/*
UpdateRulesV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateRulesV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this update rules v1 bad request response has a 2xx status code
func (o *UpdateRulesV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update rules v1 bad request response has a 3xx status code
func (o *UpdateRulesV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update rules v1 bad request response has a 4xx status code
func (o *UpdateRulesV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update rules v1 bad request response has a 5xx status code
func (o *UpdateRulesV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update rules v1 bad request response a status code equal to that given
func (o *UpdateRulesV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update rules v1 bad request response
func (o *UpdateRulesV1BadRequest) Code() int {
	return 400
}

func (o *UpdateRulesV1BadRequest) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1BadRequest  %+v", 400, o.Payload)
}

func (o *UpdateRulesV1BadRequest) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1BadRequest  %+v", 400, o.Payload)
}

func (o *UpdateRulesV1BadRequest) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *UpdateRulesV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRulesV1Unauthorized creates a UpdateRulesV1Unauthorized with default headers values
func NewUpdateRulesV1Unauthorized() *UpdateRulesV1Unauthorized {
	return &UpdateRulesV1Unauthorized{}
}

/*
UpdateRulesV1Unauthorized describes a response with status code 401, with default header values.

Unauthorized
*/
type UpdateRulesV1Unauthorized struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this update rules v1 unauthorized response has a 2xx status code
func (o *UpdateRulesV1Unauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update rules v1 unauthorized response has a 3xx status code
func (o *UpdateRulesV1Unauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update rules v1 unauthorized response has a 4xx status code
func (o *UpdateRulesV1Unauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update rules v1 unauthorized response has a 5xx status code
func (o *UpdateRulesV1Unauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update rules v1 unauthorized response a status code equal to that given
func (o *UpdateRulesV1Unauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update rules v1 unauthorized response
func (o *UpdateRulesV1Unauthorized) Code() int {
	return 401
}

func (o *UpdateRulesV1Unauthorized) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1Unauthorized  %+v", 401, o.Payload)
}

func (o *UpdateRulesV1Unauthorized) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1Unauthorized  %+v", 401, o.Payload)
}

func (o *UpdateRulesV1Unauthorized) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *UpdateRulesV1Unauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRulesV1Forbidden creates a UpdateRulesV1Forbidden with default headers values
func NewUpdateRulesV1Forbidden() *UpdateRulesV1Forbidden {
	return &UpdateRulesV1Forbidden{}
}

/*
UpdateRulesV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateRulesV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this update rules v1 forbidden response has a 2xx status code
func (o *UpdateRulesV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update rules v1 forbidden response has a 3xx status code
func (o *UpdateRulesV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update rules v1 forbidden response has a 4xx status code
func (o *UpdateRulesV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update rules v1 forbidden response has a 5xx status code
func (o *UpdateRulesV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update rules v1 forbidden response a status code equal to that given
func (o *UpdateRulesV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update rules v1 forbidden response
func (o *UpdateRulesV1Forbidden) Code() int {
	return 403
}

func (o *UpdateRulesV1Forbidden) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1Forbidden  %+v", 403, o.Payload)
}

func (o *UpdateRulesV1Forbidden) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1Forbidden  %+v", 403, o.Payload)
}

func (o *UpdateRulesV1Forbidden) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *UpdateRulesV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRulesV1TooManyRequests creates a UpdateRulesV1TooManyRequests with default headers values
func NewUpdateRulesV1TooManyRequests() *UpdateRulesV1TooManyRequests {
	return &UpdateRulesV1TooManyRequests{}
}

/*
UpdateRulesV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateRulesV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update rules v1 too many requests response has a 2xx status code
func (o *UpdateRulesV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update rules v1 too many requests response has a 3xx status code
func (o *UpdateRulesV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update rules v1 too many requests response has a 4xx status code
func (o *UpdateRulesV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update rules v1 too many requests response has a 5xx status code
func (o *UpdateRulesV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update rules v1 too many requests response a status code equal to that given
func (o *UpdateRulesV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update rules v1 too many requests response
func (o *UpdateRulesV1TooManyRequests) Code() int {
	return 429
}

func (o *UpdateRulesV1TooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateRulesV1TooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateRulesV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateRulesV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRulesV1InternalServerError creates a UpdateRulesV1InternalServerError with default headers values
func NewUpdateRulesV1InternalServerError() *UpdateRulesV1InternalServerError {
	return &UpdateRulesV1InternalServerError{}
}

/*
UpdateRulesV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateRulesV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainErrorsOnly
}

// IsSuccess returns true when this update rules v1 internal server error response has a 2xx status code
func (o *UpdateRulesV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update rules v1 internal server error response has a 3xx status code
func (o *UpdateRulesV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update rules v1 internal server error response has a 4xx status code
func (o *UpdateRulesV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update rules v1 internal server error response has a 5xx status code
func (o *UpdateRulesV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update rules v1 internal server error response a status code equal to that given
func (o *UpdateRulesV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update rules v1 internal server error response
func (o *UpdateRulesV1InternalServerError) Code() int {
	return 500
}

func (o *UpdateRulesV1InternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1InternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateRulesV1InternalServerError) String() string {
	return fmt.Sprintf("[PATCH /recon/entities/rules/v1][%d] updateRulesV1InternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateRulesV1InternalServerError) GetPayload() *models.DomainErrorsOnly {
	return o.Payload
}

func (o *UpdateRulesV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
