// Code generated by go-swagger; DO NOT EDIT.

package report_executions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new report executions API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for report executions API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ReportExecutionsDownloadGet(params *ReportExecutionsDownloadGetParams, opts ...ClientOption) (*ReportExecutionsDownloadGetOK, error)

	ReportExecutionsGet(params *ReportExecutionsGetParams, opts ...ClientOption) (*ReportExecutionsGetOK, error)

	ReportExecutionsQuery(params *ReportExecutionsQueryParams, opts ...ClientOption) (*ReportExecutionsQueryOK, error)

	ReportExecutionsRetry(params *ReportExecutionsRetryParams, opts ...ClientOption) (*ReportExecutionsRetryOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ReportExecutionsDownloadGet gets report entity download
*/
func (a *Client) ReportExecutionsDownloadGet(params *ReportExecutionsDownloadGetParams, opts ...ClientOption) (*ReportExecutionsDownloadGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewReportExecutionsDownloadGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "report-executions-download.get",
		Method:             "GET",
		PathPattern:        "/reports/entities/report-executions-download/v1",
		ProducesMediaTypes: []string{"*/*"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ReportExecutionsDownloadGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ReportExecutionsDownloadGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for report-executions-download.get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ReportExecutionsGet retrieves report details for the provided report i ds
*/
func (a *Client) ReportExecutionsGet(params *ReportExecutionsGetParams, opts ...ClientOption) (*ReportExecutionsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewReportExecutionsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "report-executions.get",
		Method:             "GET",
		PathPattern:        "/reports/entities/report-executions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ReportExecutionsGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ReportExecutionsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for report-executions.get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ReportExecutionsQuery finds all report execution i ds matching the query with filter
*/
func (a *Client) ReportExecutionsQuery(params *ReportExecutionsQueryParams, opts ...ClientOption) (*ReportExecutionsQueryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewReportExecutionsQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "report-executions.query",
		Method:             "GET",
		PathPattern:        "/reports/queries/report-executions/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ReportExecutionsQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ReportExecutionsQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for report-executions.query: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ReportExecutionsRetry this endpoint will be used to retry report executions
*/
func (a *Client) ReportExecutionsRetry(params *ReportExecutionsRetryParams, opts ...ClientOption) (*ReportExecutionsRetryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewReportExecutionsRetryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "report-executions.retry",
		Method:             "POST",
		PathPattern:        "/reports/entities/report-executions-retry/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ReportExecutionsRetryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ReportExecutionsRetryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for report-executions.retry: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
