// Code generated by go-swagger; DO NOT EDIT.

package response_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// CreateRTResponsePoliciesReader is a Reader for the CreateRTResponsePolicies structure.
type CreateRTResponsePoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateRTResponsePoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewCreateRTResponsePoliciesCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateRTResponsePoliciesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateRTResponsePoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewCreateRTResponsePoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewCreateRTResponsePoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateRTResponsePoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /policy/entities/response/v1] createRTResponsePolicies", response, response.Code())
	}
}

// NewCreateRTResponsePoliciesCreated creates a CreateRTResponsePoliciesCreated with default headers values
func NewCreateRTResponsePoliciesCreated() *CreateRTResponsePoliciesCreated {
	return &CreateRTResponsePoliciesCreated{}
}

/*
CreateRTResponsePoliciesCreated describes a response with status code 201, with default header values.

Created
*/
type CreateRTResponsePoliciesCreated struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RemoteResponseRespV1
}

// IsSuccess returns true when this create r t response policies created response has a 2xx status code
func (o *CreateRTResponsePoliciesCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create r t response policies created response has a 3xx status code
func (o *CreateRTResponsePoliciesCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create r t response policies created response has a 4xx status code
func (o *CreateRTResponsePoliciesCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this create r t response policies created response has a 5xx status code
func (o *CreateRTResponsePoliciesCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this create r t response policies created response a status code equal to that given
func (o *CreateRTResponsePoliciesCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the create r t response policies created response
func (o *CreateRTResponsePoliciesCreated) Code() int {
	return 201
}

func (o *CreateRTResponsePoliciesCreated) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesCreated  %+v", 201, o.Payload)
}

func (o *CreateRTResponsePoliciesCreated) String() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesCreated  %+v", 201, o.Payload)
}

func (o *CreateRTResponsePoliciesCreated) GetPayload() *models.RemoteResponseRespV1 {
	return o.Payload
}

func (o *CreateRTResponsePoliciesCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RemoteResponseRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRTResponsePoliciesBadRequest creates a CreateRTResponsePoliciesBadRequest with default headers values
func NewCreateRTResponsePoliciesBadRequest() *CreateRTResponsePoliciesBadRequest {
	return &CreateRTResponsePoliciesBadRequest{}
}

/*
CreateRTResponsePoliciesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type CreateRTResponsePoliciesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RemoteResponseRespV1
}

// IsSuccess returns true when this create r t response policies bad request response has a 2xx status code
func (o *CreateRTResponsePoliciesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create r t response policies bad request response has a 3xx status code
func (o *CreateRTResponsePoliciesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create r t response policies bad request response has a 4xx status code
func (o *CreateRTResponsePoliciesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create r t response policies bad request response has a 5xx status code
func (o *CreateRTResponsePoliciesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create r t response policies bad request response a status code equal to that given
func (o *CreateRTResponsePoliciesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create r t response policies bad request response
func (o *CreateRTResponsePoliciesBadRequest) Code() int {
	return 400
}

func (o *CreateRTResponsePoliciesBadRequest) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRTResponsePoliciesBadRequest) String() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *CreateRTResponsePoliciesBadRequest) GetPayload() *models.RemoteResponseRespV1 {
	return o.Payload
}

func (o *CreateRTResponsePoliciesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RemoteResponseRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRTResponsePoliciesForbidden creates a CreateRTResponsePoliciesForbidden with default headers values
func NewCreateRTResponsePoliciesForbidden() *CreateRTResponsePoliciesForbidden {
	return &CreateRTResponsePoliciesForbidden{}
}

/*
CreateRTResponsePoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type CreateRTResponsePoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this create r t response policies forbidden response has a 2xx status code
func (o *CreateRTResponsePoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create r t response policies forbidden response has a 3xx status code
func (o *CreateRTResponsePoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create r t response policies forbidden response has a 4xx status code
func (o *CreateRTResponsePoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create r t response policies forbidden response has a 5xx status code
func (o *CreateRTResponsePoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create r t response policies forbidden response a status code equal to that given
func (o *CreateRTResponsePoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create r t response policies forbidden response
func (o *CreateRTResponsePoliciesForbidden) Code() int {
	return 403
}

func (o *CreateRTResponsePoliciesForbidden) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesForbidden  %+v", 403, o.Payload)
}

func (o *CreateRTResponsePoliciesForbidden) String() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesForbidden  %+v", 403, o.Payload)
}

func (o *CreateRTResponsePoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *CreateRTResponsePoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRTResponsePoliciesNotFound creates a CreateRTResponsePoliciesNotFound with default headers values
func NewCreateRTResponsePoliciesNotFound() *CreateRTResponsePoliciesNotFound {
	return &CreateRTResponsePoliciesNotFound{}
}

/*
CreateRTResponsePoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type CreateRTResponsePoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RemoteResponseRespV1
}

// IsSuccess returns true when this create r t response policies not found response has a 2xx status code
func (o *CreateRTResponsePoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create r t response policies not found response has a 3xx status code
func (o *CreateRTResponsePoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create r t response policies not found response has a 4xx status code
func (o *CreateRTResponsePoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this create r t response policies not found response has a 5xx status code
func (o *CreateRTResponsePoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this create r t response policies not found response a status code equal to that given
func (o *CreateRTResponsePoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the create r t response policies not found response
func (o *CreateRTResponsePoliciesNotFound) Code() int {
	return 404
}

func (o *CreateRTResponsePoliciesNotFound) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesNotFound  %+v", 404, o.Payload)
}

func (o *CreateRTResponsePoliciesNotFound) String() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesNotFound  %+v", 404, o.Payload)
}

func (o *CreateRTResponsePoliciesNotFound) GetPayload() *models.RemoteResponseRespV1 {
	return o.Payload
}

func (o *CreateRTResponsePoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RemoteResponseRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRTResponsePoliciesTooManyRequests creates a CreateRTResponsePoliciesTooManyRequests with default headers values
func NewCreateRTResponsePoliciesTooManyRequests() *CreateRTResponsePoliciesTooManyRequests {
	return &CreateRTResponsePoliciesTooManyRequests{}
}

/*
CreateRTResponsePoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type CreateRTResponsePoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this create r t response policies too many requests response has a 2xx status code
func (o *CreateRTResponsePoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create r t response policies too many requests response has a 3xx status code
func (o *CreateRTResponsePoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create r t response policies too many requests response has a 4xx status code
func (o *CreateRTResponsePoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this create r t response policies too many requests response has a 5xx status code
func (o *CreateRTResponsePoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this create r t response policies too many requests response a status code equal to that given
func (o *CreateRTResponsePoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the create r t response policies too many requests response
func (o *CreateRTResponsePoliciesTooManyRequests) Code() int {
	return 429
}

func (o *CreateRTResponsePoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRTResponsePoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *CreateRTResponsePoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *CreateRTResponsePoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateRTResponsePoliciesInternalServerError creates a CreateRTResponsePoliciesInternalServerError with default headers values
func NewCreateRTResponsePoliciesInternalServerError() *CreateRTResponsePoliciesInternalServerError {
	return &CreateRTResponsePoliciesInternalServerError{}
}

/*
CreateRTResponsePoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type CreateRTResponsePoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RemoteResponseRespV1
}

// IsSuccess returns true when this create r t response policies internal server error response has a 2xx status code
func (o *CreateRTResponsePoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create r t response policies internal server error response has a 3xx status code
func (o *CreateRTResponsePoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create r t response policies internal server error response has a 4xx status code
func (o *CreateRTResponsePoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create r t response policies internal server error response has a 5xx status code
func (o *CreateRTResponsePoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create r t response policies internal server error response a status code equal to that given
func (o *CreateRTResponsePoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create r t response policies internal server error response
func (o *CreateRTResponsePoliciesInternalServerError) Code() int {
	return 500
}

func (o *CreateRTResponsePoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateRTResponsePoliciesInternalServerError) String() string {
	return fmt.Sprintf("[POST /policy/entities/response/v1][%d] createRTResponsePoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *CreateRTResponsePoliciesInternalServerError) GetPayload() *models.RemoteResponseRespV1 {
	return o.Payload
}

func (o *CreateRTResponsePoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RemoteResponseRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
