// Code generated by go-swagger; DO NOT EDIT.

package response_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// DeleteRTResponsePoliciesReader is a Reader for the DeleteRTResponsePolicies structure.
type DeleteRTResponsePoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteRTResponsePoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteRTResponsePoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewDeleteRTResponsePoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteRTResponsePoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewDeleteRTResponsePoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteRTResponsePoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /policy/entities/response/v1] deleteRTResponsePolicies", response, response.Code())
	}
}

// NewDeleteRTResponsePoliciesOK creates a DeleteRTResponsePoliciesOK with default headers values
func NewDeleteRTResponsePoliciesOK() *DeleteRTResponsePoliciesOK {
	return &DeleteRTResponsePoliciesOK{}
}

/*
DeleteRTResponsePoliciesOK describes a response with status code 200, with default header values.

OK
*/
type DeleteRTResponsePoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete r t response policies o k response has a 2xx status code
func (o *DeleteRTResponsePoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete r t response policies o k response has a 3xx status code
func (o *DeleteRTResponsePoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete r t response policies o k response has a 4xx status code
func (o *DeleteRTResponsePoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete r t response policies o k response has a 5xx status code
func (o *DeleteRTResponsePoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete r t response policies o k response a status code equal to that given
func (o *DeleteRTResponsePoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete r t response policies o k response
func (o *DeleteRTResponsePoliciesOK) Code() int {
	return 200
}

func (o *DeleteRTResponsePoliciesOK) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesOK  %+v", 200, o.Payload)
}

func (o *DeleteRTResponsePoliciesOK) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesOK  %+v", 200, o.Payload)
}

func (o *DeleteRTResponsePoliciesOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteRTResponsePoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteRTResponsePoliciesForbidden creates a DeleteRTResponsePoliciesForbidden with default headers values
func NewDeleteRTResponsePoliciesForbidden() *DeleteRTResponsePoliciesForbidden {
	return &DeleteRTResponsePoliciesForbidden{}
}

/*
DeleteRTResponsePoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteRTResponsePoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this delete r t response policies forbidden response has a 2xx status code
func (o *DeleteRTResponsePoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete r t response policies forbidden response has a 3xx status code
func (o *DeleteRTResponsePoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete r t response policies forbidden response has a 4xx status code
func (o *DeleteRTResponsePoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete r t response policies forbidden response has a 5xx status code
func (o *DeleteRTResponsePoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete r t response policies forbidden response a status code equal to that given
func (o *DeleteRTResponsePoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete r t response policies forbidden response
func (o *DeleteRTResponsePoliciesForbidden) Code() int {
	return 403
}

func (o *DeleteRTResponsePoliciesForbidden) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesForbidden  %+v", 403, o.Payload)
}

func (o *DeleteRTResponsePoliciesForbidden) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesForbidden  %+v", 403, o.Payload)
}

func (o *DeleteRTResponsePoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *DeleteRTResponsePoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteRTResponsePoliciesNotFound creates a DeleteRTResponsePoliciesNotFound with default headers values
func NewDeleteRTResponsePoliciesNotFound() *DeleteRTResponsePoliciesNotFound {
	return &DeleteRTResponsePoliciesNotFound{}
}

/*
DeleteRTResponsePoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type DeleteRTResponsePoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete r t response policies not found response has a 2xx status code
func (o *DeleteRTResponsePoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete r t response policies not found response has a 3xx status code
func (o *DeleteRTResponsePoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete r t response policies not found response has a 4xx status code
func (o *DeleteRTResponsePoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete r t response policies not found response has a 5xx status code
func (o *DeleteRTResponsePoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete r t response policies not found response a status code equal to that given
func (o *DeleteRTResponsePoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete r t response policies not found response
func (o *DeleteRTResponsePoliciesNotFound) Code() int {
	return 404
}

func (o *DeleteRTResponsePoliciesNotFound) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesNotFound  %+v", 404, o.Payload)
}

func (o *DeleteRTResponsePoliciesNotFound) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesNotFound  %+v", 404, o.Payload)
}

func (o *DeleteRTResponsePoliciesNotFound) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteRTResponsePoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteRTResponsePoliciesTooManyRequests creates a DeleteRTResponsePoliciesTooManyRequests with default headers values
func NewDeleteRTResponsePoliciesTooManyRequests() *DeleteRTResponsePoliciesTooManyRequests {
	return &DeleteRTResponsePoliciesTooManyRequests{}
}

/*
DeleteRTResponsePoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type DeleteRTResponsePoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this delete r t response policies too many requests response has a 2xx status code
func (o *DeleteRTResponsePoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete r t response policies too many requests response has a 3xx status code
func (o *DeleteRTResponsePoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete r t response policies too many requests response has a 4xx status code
func (o *DeleteRTResponsePoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete r t response policies too many requests response has a 5xx status code
func (o *DeleteRTResponsePoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this delete r t response policies too many requests response a status code equal to that given
func (o *DeleteRTResponsePoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the delete r t response policies too many requests response
func (o *DeleteRTResponsePoliciesTooManyRequests) Code() int {
	return 429
}

func (o *DeleteRTResponsePoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteRTResponsePoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *DeleteRTResponsePoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *DeleteRTResponsePoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteRTResponsePoliciesInternalServerError creates a DeleteRTResponsePoliciesInternalServerError with default headers values
func NewDeleteRTResponsePoliciesInternalServerError() *DeleteRTResponsePoliciesInternalServerError {
	return &DeleteRTResponsePoliciesInternalServerError{}
}

/*
DeleteRTResponsePoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type DeleteRTResponsePoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this delete r t response policies internal server error response has a 2xx status code
func (o *DeleteRTResponsePoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete r t response policies internal server error response has a 3xx status code
func (o *DeleteRTResponsePoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete r t response policies internal server error response has a 4xx status code
func (o *DeleteRTResponsePoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete r t response policies internal server error response has a 5xx status code
func (o *DeleteRTResponsePoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete r t response policies internal server error response a status code equal to that given
func (o *DeleteRTResponsePoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete r t response policies internal server error response
func (o *DeleteRTResponsePoliciesInternalServerError) Code() int {
	return 500
}

func (o *DeleteRTResponsePoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteRTResponsePoliciesInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /policy/entities/response/v1][%d] deleteRTResponsePoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *DeleteRTResponsePoliciesInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *DeleteRTResponsePoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
