// Code generated by go-swagger; DO NOT EDIT.

package response_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetRTResponsePoliciesParams creates a new GetRTResponsePoliciesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetRTResponsePoliciesParams() *GetRTResponsePoliciesParams {
	return &GetRTResponsePoliciesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetRTResponsePoliciesParamsWithTimeout creates a new GetRTResponsePoliciesParams object
// with the ability to set a timeout on a request.
func NewGetRTResponsePoliciesParamsWithTimeout(timeout time.Duration) *GetRTResponsePoliciesParams {
	return &GetRTResponsePoliciesParams{
		timeout: timeout,
	}
}

// NewGetRTResponsePoliciesParamsWithContext creates a new GetRTResponsePoliciesParams object
// with the ability to set a context for a request.
func NewGetRTResponsePoliciesParamsWithContext(ctx context.Context) *GetRTResponsePoliciesParams {
	return &GetRTResponsePoliciesParams{
		Context: ctx,
	}
}

// NewGetRTResponsePoliciesParamsWithHTTPClient creates a new GetRTResponsePoliciesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetRTResponsePoliciesParamsWithHTTPClient(client *http.Client) *GetRTResponsePoliciesParams {
	return &GetRTResponsePoliciesParams{
		HTTPClient: client,
	}
}

/*
GetRTResponsePoliciesParams contains all the parameters to send to the API endpoint

	for the get r t response policies operation.

	Typically these are written to a http.Request.
*/
type GetRTResponsePoliciesParams struct {

	/* Ids.

	   The IDs of the RTR Policies to return
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get r t response policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRTResponsePoliciesParams) WithDefaults() *GetRTResponsePoliciesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get r t response policies params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetRTResponsePoliciesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get r t response policies params
func (o *GetRTResponsePoliciesParams) WithTimeout(timeout time.Duration) *GetRTResponsePoliciesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get r t response policies params
func (o *GetRTResponsePoliciesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get r t response policies params
func (o *GetRTResponsePoliciesParams) WithContext(ctx context.Context) *GetRTResponsePoliciesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get r t response policies params
func (o *GetRTResponsePoliciesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get r t response policies params
func (o *GetRTResponsePoliciesParams) WithHTTPClient(client *http.Client) *GetRTResponsePoliciesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get r t response policies params
func (o *GetRTResponsePoliciesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get r t response policies params
func (o *GetRTResponsePoliciesParams) WithIds(ids []string) *GetRTResponsePoliciesParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get r t response policies params
func (o *GetRTResponsePoliciesParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *GetRTResponsePoliciesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGetRTResponsePolicies binds the parameter ids
func (o *GetRTResponsePoliciesParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
