// Code generated by go-swagger; DO NOT EDIT.

package response_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// PerformRTResponsePoliciesActionReader is a Reader for the PerformRTResponsePoliciesAction structure.
type PerformRTResponsePoliciesActionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformRTResponsePoliciesActionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformRTResponsePoliciesActionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPerformRTResponsePoliciesActionBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPerformRTResponsePoliciesActionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewPerformRTResponsePoliciesActionNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewPerformRTResponsePoliciesActionTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPerformRTResponsePoliciesActionInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /policy/entities/response-actions/v1] performRTResponsePoliciesAction", response, response.Code())
	}
}

// NewPerformRTResponsePoliciesActionOK creates a PerformRTResponsePoliciesActionOK with default headers values
func NewPerformRTResponsePoliciesActionOK() *PerformRTResponsePoliciesActionOK {
	return &PerformRTResponsePoliciesActionOK{}
}

/*
PerformRTResponsePoliciesActionOK describes a response with status code 200, with default header values.

OK
*/
type PerformRTResponsePoliciesActionOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RemoteResponseRespV1
}

// IsSuccess returns true when this perform r t response policies action o k response has a 2xx status code
func (o *PerformRTResponsePoliciesActionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this perform r t response policies action o k response has a 3xx status code
func (o *PerformRTResponsePoliciesActionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform r t response policies action o k response has a 4xx status code
func (o *PerformRTResponsePoliciesActionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this perform r t response policies action o k response has a 5xx status code
func (o *PerformRTResponsePoliciesActionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this perform r t response policies action o k response a status code equal to that given
func (o *PerformRTResponsePoliciesActionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the perform r t response policies action o k response
func (o *PerformRTResponsePoliciesActionOK) Code() int {
	return 200
}

func (o *PerformRTResponsePoliciesActionOK) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionOK  %+v", 200, o.Payload)
}

func (o *PerformRTResponsePoliciesActionOK) String() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionOK  %+v", 200, o.Payload)
}

func (o *PerformRTResponsePoliciesActionOK) GetPayload() *models.RemoteResponseRespV1 {
	return o.Payload
}

func (o *PerformRTResponsePoliciesActionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RemoteResponseRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformRTResponsePoliciesActionBadRequest creates a PerformRTResponsePoliciesActionBadRequest with default headers values
func NewPerformRTResponsePoliciesActionBadRequest() *PerformRTResponsePoliciesActionBadRequest {
	return &PerformRTResponsePoliciesActionBadRequest{}
}

/*
PerformRTResponsePoliciesActionBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type PerformRTResponsePoliciesActionBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RemoteResponseRespV1
}

// IsSuccess returns true when this perform r t response policies action bad request response has a 2xx status code
func (o *PerformRTResponsePoliciesActionBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform r t response policies action bad request response has a 3xx status code
func (o *PerformRTResponsePoliciesActionBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform r t response policies action bad request response has a 4xx status code
func (o *PerformRTResponsePoliciesActionBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform r t response policies action bad request response has a 5xx status code
func (o *PerformRTResponsePoliciesActionBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this perform r t response policies action bad request response a status code equal to that given
func (o *PerformRTResponsePoliciesActionBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the perform r t response policies action bad request response
func (o *PerformRTResponsePoliciesActionBadRequest) Code() int {
	return 400
}

func (o *PerformRTResponsePoliciesActionBadRequest) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionBadRequest  %+v", 400, o.Payload)
}

func (o *PerformRTResponsePoliciesActionBadRequest) String() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionBadRequest  %+v", 400, o.Payload)
}

func (o *PerformRTResponsePoliciesActionBadRequest) GetPayload() *models.RemoteResponseRespV1 {
	return o.Payload
}

func (o *PerformRTResponsePoliciesActionBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RemoteResponseRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformRTResponsePoliciesActionForbidden creates a PerformRTResponsePoliciesActionForbidden with default headers values
func NewPerformRTResponsePoliciesActionForbidden() *PerformRTResponsePoliciesActionForbidden {
	return &PerformRTResponsePoliciesActionForbidden{}
}

/*
PerformRTResponsePoliciesActionForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type PerformRTResponsePoliciesActionForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this perform r t response policies action forbidden response has a 2xx status code
func (o *PerformRTResponsePoliciesActionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform r t response policies action forbidden response has a 3xx status code
func (o *PerformRTResponsePoliciesActionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform r t response policies action forbidden response has a 4xx status code
func (o *PerformRTResponsePoliciesActionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform r t response policies action forbidden response has a 5xx status code
func (o *PerformRTResponsePoliciesActionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this perform r t response policies action forbidden response a status code equal to that given
func (o *PerformRTResponsePoliciesActionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the perform r t response policies action forbidden response
func (o *PerformRTResponsePoliciesActionForbidden) Code() int {
	return 403
}

func (o *PerformRTResponsePoliciesActionForbidden) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionForbidden  %+v", 403, o.Payload)
}

func (o *PerformRTResponsePoliciesActionForbidden) String() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionForbidden  %+v", 403, o.Payload)
}

func (o *PerformRTResponsePoliciesActionForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *PerformRTResponsePoliciesActionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformRTResponsePoliciesActionNotFound creates a PerformRTResponsePoliciesActionNotFound with default headers values
func NewPerformRTResponsePoliciesActionNotFound() *PerformRTResponsePoliciesActionNotFound {
	return &PerformRTResponsePoliciesActionNotFound{}
}

/*
PerformRTResponsePoliciesActionNotFound describes a response with status code 404, with default header values.

Not Found
*/
type PerformRTResponsePoliciesActionNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RemoteResponseRespV1
}

// IsSuccess returns true when this perform r t response policies action not found response has a 2xx status code
func (o *PerformRTResponsePoliciesActionNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform r t response policies action not found response has a 3xx status code
func (o *PerformRTResponsePoliciesActionNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform r t response policies action not found response has a 4xx status code
func (o *PerformRTResponsePoliciesActionNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform r t response policies action not found response has a 5xx status code
func (o *PerformRTResponsePoliciesActionNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this perform r t response policies action not found response a status code equal to that given
func (o *PerformRTResponsePoliciesActionNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the perform r t response policies action not found response
func (o *PerformRTResponsePoliciesActionNotFound) Code() int {
	return 404
}

func (o *PerformRTResponsePoliciesActionNotFound) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionNotFound  %+v", 404, o.Payload)
}

func (o *PerformRTResponsePoliciesActionNotFound) String() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionNotFound  %+v", 404, o.Payload)
}

func (o *PerformRTResponsePoliciesActionNotFound) GetPayload() *models.RemoteResponseRespV1 {
	return o.Payload
}

func (o *PerformRTResponsePoliciesActionNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RemoteResponseRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformRTResponsePoliciesActionTooManyRequests creates a PerformRTResponsePoliciesActionTooManyRequests with default headers values
func NewPerformRTResponsePoliciesActionTooManyRequests() *PerformRTResponsePoliciesActionTooManyRequests {
	return &PerformRTResponsePoliciesActionTooManyRequests{}
}

/*
PerformRTResponsePoliciesActionTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type PerformRTResponsePoliciesActionTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this perform r t response policies action too many requests response has a 2xx status code
func (o *PerformRTResponsePoliciesActionTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform r t response policies action too many requests response has a 3xx status code
func (o *PerformRTResponsePoliciesActionTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform r t response policies action too many requests response has a 4xx status code
func (o *PerformRTResponsePoliciesActionTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this perform r t response policies action too many requests response has a 5xx status code
func (o *PerformRTResponsePoliciesActionTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this perform r t response policies action too many requests response a status code equal to that given
func (o *PerformRTResponsePoliciesActionTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the perform r t response policies action too many requests response
func (o *PerformRTResponsePoliciesActionTooManyRequests) Code() int {
	return 429
}

func (o *PerformRTResponsePoliciesActionTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionTooManyRequests  %+v", 429, o.Payload)
}

func (o *PerformRTResponsePoliciesActionTooManyRequests) String() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionTooManyRequests  %+v", 429, o.Payload)
}

func (o *PerformRTResponsePoliciesActionTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *PerformRTResponsePoliciesActionTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformRTResponsePoliciesActionInternalServerError creates a PerformRTResponsePoliciesActionInternalServerError with default headers values
func NewPerformRTResponsePoliciesActionInternalServerError() *PerformRTResponsePoliciesActionInternalServerError {
	return &PerformRTResponsePoliciesActionInternalServerError{}
}

/*
PerformRTResponsePoliciesActionInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type PerformRTResponsePoliciesActionInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.RemoteResponseRespV1
}

// IsSuccess returns true when this perform r t response policies action internal server error response has a 2xx status code
func (o *PerformRTResponsePoliciesActionInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this perform r t response policies action internal server error response has a 3xx status code
func (o *PerformRTResponsePoliciesActionInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this perform r t response policies action internal server error response has a 4xx status code
func (o *PerformRTResponsePoliciesActionInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this perform r t response policies action internal server error response has a 5xx status code
func (o *PerformRTResponsePoliciesActionInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this perform r t response policies action internal server error response a status code equal to that given
func (o *PerformRTResponsePoliciesActionInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the perform r t response policies action internal server error response
func (o *PerformRTResponsePoliciesActionInternalServerError) Code() int {
	return 500
}

func (o *PerformRTResponsePoliciesActionInternalServerError) Error() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionInternalServerError  %+v", 500, o.Payload)
}

func (o *PerformRTResponsePoliciesActionInternalServerError) String() string {
	return fmt.Sprintf("[POST /policy/entities/response-actions/v1][%d] performRTResponsePoliciesActionInternalServerError  %+v", 500, o.Payload)
}

func (o *PerformRTResponsePoliciesActionInternalServerError) GetPayload() *models.RemoteResponseRespV1 {
	return o.Payload
}

func (o *PerformRTResponsePoliciesActionInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.RemoteResponseRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
