// Code generated by go-swagger; DO NOT EDIT.

package response_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryRTResponsePolicyMembersReader is a Reader for the QueryRTResponsePolicyMembers structure.
type QueryRTResponsePolicyMembersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryRTResponsePolicyMembersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryRTResponsePolicyMembersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryRTResponsePolicyMembersBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryRTResponsePolicyMembersForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewQueryRTResponsePolicyMembersNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryRTResponsePolicyMembersTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryRTResponsePolicyMembersInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/queries/response-members/v1] queryRTResponsePolicyMembers", response, response.Code())
	}
}

// NewQueryRTResponsePolicyMembersOK creates a QueryRTResponsePolicyMembersOK with default headers values
func NewQueryRTResponsePolicyMembersOK() *QueryRTResponsePolicyMembersOK {
	return &QueryRTResponsePolicyMembersOK{}
}

/*
QueryRTResponsePolicyMembersOK describes a response with status code 200, with default header values.

OK
*/
type QueryRTResponsePolicyMembersOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query r t response policy members o k response has a 2xx status code
func (o *QueryRTResponsePolicyMembersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query r t response policy members o k response has a 3xx status code
func (o *QueryRTResponsePolicyMembersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query r t response policy members o k response has a 4xx status code
func (o *QueryRTResponsePolicyMembersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query r t response policy members o k response has a 5xx status code
func (o *QueryRTResponsePolicyMembersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query r t response policy members o k response a status code equal to that given
func (o *QueryRTResponsePolicyMembersOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query r t response policy members o k response
func (o *QueryRTResponsePolicyMembersOK) Code() int {
	return 200
}

func (o *QueryRTResponsePolicyMembersOK) Error() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersOK  %+v", 200, o.Payload)
}

func (o *QueryRTResponsePolicyMembersOK) String() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersOK  %+v", 200, o.Payload)
}

func (o *QueryRTResponsePolicyMembersOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryRTResponsePolicyMembersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRTResponsePolicyMembersBadRequest creates a QueryRTResponsePolicyMembersBadRequest with default headers values
func NewQueryRTResponsePolicyMembersBadRequest() *QueryRTResponsePolicyMembersBadRequest {
	return &QueryRTResponsePolicyMembersBadRequest{}
}

/*
QueryRTResponsePolicyMembersBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryRTResponsePolicyMembersBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query r t response policy members bad request response has a 2xx status code
func (o *QueryRTResponsePolicyMembersBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query r t response policy members bad request response has a 3xx status code
func (o *QueryRTResponsePolicyMembersBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query r t response policy members bad request response has a 4xx status code
func (o *QueryRTResponsePolicyMembersBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query r t response policy members bad request response has a 5xx status code
func (o *QueryRTResponsePolicyMembersBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query r t response policy members bad request response a status code equal to that given
func (o *QueryRTResponsePolicyMembersBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query r t response policy members bad request response
func (o *QueryRTResponsePolicyMembersBadRequest) Code() int {
	return 400
}

func (o *QueryRTResponsePolicyMembersBadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersBadRequest  %+v", 400, o.Payload)
}

func (o *QueryRTResponsePolicyMembersBadRequest) String() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersBadRequest  %+v", 400, o.Payload)
}

func (o *QueryRTResponsePolicyMembersBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryRTResponsePolicyMembersBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRTResponsePolicyMembersForbidden creates a QueryRTResponsePolicyMembersForbidden with default headers values
func NewQueryRTResponsePolicyMembersForbidden() *QueryRTResponsePolicyMembersForbidden {
	return &QueryRTResponsePolicyMembersForbidden{}
}

/*
QueryRTResponsePolicyMembersForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryRTResponsePolicyMembersForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query r t response policy members forbidden response has a 2xx status code
func (o *QueryRTResponsePolicyMembersForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query r t response policy members forbidden response has a 3xx status code
func (o *QueryRTResponsePolicyMembersForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query r t response policy members forbidden response has a 4xx status code
func (o *QueryRTResponsePolicyMembersForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query r t response policy members forbidden response has a 5xx status code
func (o *QueryRTResponsePolicyMembersForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query r t response policy members forbidden response a status code equal to that given
func (o *QueryRTResponsePolicyMembersForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query r t response policy members forbidden response
func (o *QueryRTResponsePolicyMembersForbidden) Code() int {
	return 403
}

func (o *QueryRTResponsePolicyMembersForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryRTResponsePolicyMembersForbidden) String() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersForbidden  %+v", 403, o.Payload)
}

func (o *QueryRTResponsePolicyMembersForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryRTResponsePolicyMembersForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRTResponsePolicyMembersNotFound creates a QueryRTResponsePolicyMembersNotFound with default headers values
func NewQueryRTResponsePolicyMembersNotFound() *QueryRTResponsePolicyMembersNotFound {
	return &QueryRTResponsePolicyMembersNotFound{}
}

/*
QueryRTResponsePolicyMembersNotFound describes a response with status code 404, with default header values.

Not Found
*/
type QueryRTResponsePolicyMembersNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query r t response policy members not found response has a 2xx status code
func (o *QueryRTResponsePolicyMembersNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query r t response policy members not found response has a 3xx status code
func (o *QueryRTResponsePolicyMembersNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query r t response policy members not found response has a 4xx status code
func (o *QueryRTResponsePolicyMembersNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this query r t response policy members not found response has a 5xx status code
func (o *QueryRTResponsePolicyMembersNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this query r t response policy members not found response a status code equal to that given
func (o *QueryRTResponsePolicyMembersNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the query r t response policy members not found response
func (o *QueryRTResponsePolicyMembersNotFound) Code() int {
	return 404
}

func (o *QueryRTResponsePolicyMembersNotFound) Error() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersNotFound  %+v", 404, o.Payload)
}

func (o *QueryRTResponsePolicyMembersNotFound) String() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersNotFound  %+v", 404, o.Payload)
}

func (o *QueryRTResponsePolicyMembersNotFound) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryRTResponsePolicyMembersNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRTResponsePolicyMembersTooManyRequests creates a QueryRTResponsePolicyMembersTooManyRequests with default headers values
func NewQueryRTResponsePolicyMembersTooManyRequests() *QueryRTResponsePolicyMembersTooManyRequests {
	return &QueryRTResponsePolicyMembersTooManyRequests{}
}

/*
QueryRTResponsePolicyMembersTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryRTResponsePolicyMembersTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query r t response policy members too many requests response has a 2xx status code
func (o *QueryRTResponsePolicyMembersTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query r t response policy members too many requests response has a 3xx status code
func (o *QueryRTResponsePolicyMembersTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query r t response policy members too many requests response has a 4xx status code
func (o *QueryRTResponsePolicyMembersTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query r t response policy members too many requests response has a 5xx status code
func (o *QueryRTResponsePolicyMembersTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query r t response policy members too many requests response a status code equal to that given
func (o *QueryRTResponsePolicyMembersTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query r t response policy members too many requests response
func (o *QueryRTResponsePolicyMembersTooManyRequests) Code() int {
	return 429
}

func (o *QueryRTResponsePolicyMembersTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryRTResponsePolicyMembersTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryRTResponsePolicyMembersTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryRTResponsePolicyMembersTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryRTResponsePolicyMembersInternalServerError creates a QueryRTResponsePolicyMembersInternalServerError with default headers values
func NewQueryRTResponsePolicyMembersInternalServerError() *QueryRTResponsePolicyMembersInternalServerError {
	return &QueryRTResponsePolicyMembersInternalServerError{}
}

/*
QueryRTResponsePolicyMembersInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryRTResponsePolicyMembersInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query r t response policy members internal server error response has a 2xx status code
func (o *QueryRTResponsePolicyMembersInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query r t response policy members internal server error response has a 3xx status code
func (o *QueryRTResponsePolicyMembersInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query r t response policy members internal server error response has a 4xx status code
func (o *QueryRTResponsePolicyMembersInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query r t response policy members internal server error response has a 5xx status code
func (o *QueryRTResponsePolicyMembersInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query r t response policy members internal server error response a status code equal to that given
func (o *QueryRTResponsePolicyMembersInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query r t response policy members internal server error response
func (o *QueryRTResponsePolicyMembersInternalServerError) Code() int {
	return 500
}

func (o *QueryRTResponsePolicyMembersInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryRTResponsePolicyMembersInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/queries/response-members/v1][%d] queryRTResponsePolicyMembersInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryRTResponsePolicyMembersInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QueryRTResponsePolicyMembersInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
