// Code generated by go-swagger; DO NOT EDIT.

package sample_uploads

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewArchiveDeleteV1Params creates a new ArchiveDeleteV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewArchiveDeleteV1Params() *ArchiveDeleteV1Params {
	return &ArchiveDeleteV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewArchiveDeleteV1ParamsWithTimeout creates a new ArchiveDeleteV1Params object
// with the ability to set a timeout on a request.
func NewArchiveDeleteV1ParamsWithTimeout(timeout time.Duration) *ArchiveDeleteV1Params {
	return &ArchiveDeleteV1Params{
		timeout: timeout,
	}
}

// NewArchiveDeleteV1ParamsWithContext creates a new ArchiveDeleteV1Params object
// with the ability to set a context for a request.
func NewArchiveDeleteV1ParamsWithContext(ctx context.Context) *ArchiveDeleteV1Params {
	return &ArchiveDeleteV1Params{
		Context: ctx,
	}
}

// NewArchiveDeleteV1ParamsWithHTTPClient creates a new ArchiveDeleteV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewArchiveDeleteV1ParamsWithHTTPClient(client *http.Client) *ArchiveDeleteV1Params {
	return &ArchiveDeleteV1Params{
		HTTPClient: client,
	}
}

/*
ArchiveDeleteV1Params contains all the parameters to send to the API endpoint

	for the archive delete v1 operation.

	Typically these are written to a http.Request.
*/
type ArchiveDeleteV1Params struct {

	/* ID.

	   The archive SHA256.
	*/
	ID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the archive delete v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ArchiveDeleteV1Params) WithDefaults() *ArchiveDeleteV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the archive delete v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ArchiveDeleteV1Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the archive delete v1 params
func (o *ArchiveDeleteV1Params) WithTimeout(timeout time.Duration) *ArchiveDeleteV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the archive delete v1 params
func (o *ArchiveDeleteV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the archive delete v1 params
func (o *ArchiveDeleteV1Params) WithContext(ctx context.Context) *ArchiveDeleteV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the archive delete v1 params
func (o *ArchiveDeleteV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the archive delete v1 params
func (o *ArchiveDeleteV1Params) WithHTTPClient(client *http.Client) *ArchiveDeleteV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the archive delete v1 params
func (o *ArchiveDeleteV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the archive delete v1 params
func (o *ArchiveDeleteV1Params) WithID(id string) *ArchiveDeleteV1Params {
	o.SetID(id)
	return o
}

// SetID adds the id to the archive delete v1 params
func (o *ArchiveDeleteV1Params) SetID(id string) {
	o.ID = id
}

// WriteToRequest writes these params to a swagger request
func (o *ArchiveDeleteV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param id
	qrID := o.ID
	qID := qrID
	if qID != "" {

		if err := r.SetQueryParam("id", qID); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
