// Code generated by go-swagger; DO NOT EDIT.

package sample_uploads

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewArchiveGetV1Params creates a new ArchiveGetV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewArchiveGetV1Params() *ArchiveGetV1Params {
	return &ArchiveGetV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewArchiveGetV1ParamsWithTimeout creates a new ArchiveGetV1Params object
// with the ability to set a timeout on a request.
func NewArchiveGetV1ParamsWithTimeout(timeout time.Duration) *ArchiveGetV1Params {
	return &ArchiveGetV1Params{
		timeout: timeout,
	}
}

// NewArchiveGetV1ParamsWithContext creates a new ArchiveGetV1Params object
// with the ability to set a context for a request.
func NewArchiveGetV1ParamsWithContext(ctx context.Context) *ArchiveGetV1Params {
	return &ArchiveGetV1Params{
		Context: ctx,
	}
}

// NewArchiveGetV1ParamsWithHTTPClient creates a new ArchiveGetV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewArchiveGetV1ParamsWithHTTPClient(client *http.Client) *ArchiveGetV1Params {
	return &ArchiveGetV1Params{
		HTTPClient: client,
	}
}

/*
ArchiveGetV1Params contains all the parameters to send to the API endpoint

	for the archive get v1 operation.

	Typically these are written to a http.Request.
*/
type ArchiveGetV1Params struct {

	/* ID.

	   The archive SHA256.
	*/
	ID string

	/* IncludeFiles.

	   If `true` includes processed archive files in response.
	*/
	IncludeFiles *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the archive get v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ArchiveGetV1Params) WithDefaults() *ArchiveGetV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the archive get v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ArchiveGetV1Params) SetDefaults() {
	var (
		includeFilesDefault = bool(false)
	)

	val := ArchiveGetV1Params{
		IncludeFiles: &includeFilesDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the archive get v1 params
func (o *ArchiveGetV1Params) WithTimeout(timeout time.Duration) *ArchiveGetV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the archive get v1 params
func (o *ArchiveGetV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the archive get v1 params
func (o *ArchiveGetV1Params) WithContext(ctx context.Context) *ArchiveGetV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the archive get v1 params
func (o *ArchiveGetV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the archive get v1 params
func (o *ArchiveGetV1Params) WithHTTPClient(client *http.Client) *ArchiveGetV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the archive get v1 params
func (o *ArchiveGetV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the archive get v1 params
func (o *ArchiveGetV1Params) WithID(id string) *ArchiveGetV1Params {
	o.SetID(id)
	return o
}

// SetID adds the id to the archive get v1 params
func (o *ArchiveGetV1Params) SetID(id string) {
	o.ID = id
}

// WithIncludeFiles adds the includeFiles to the archive get v1 params
func (o *ArchiveGetV1Params) WithIncludeFiles(includeFiles *bool) *ArchiveGetV1Params {
	o.SetIncludeFiles(includeFiles)
	return o
}

// SetIncludeFiles adds the includeFiles to the archive get v1 params
func (o *ArchiveGetV1Params) SetIncludeFiles(includeFiles *bool) {
	o.IncludeFiles = includeFiles
}

// WriteToRequest writes these params to a swagger request
func (o *ArchiveGetV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param id
	qrID := o.ID
	qID := qrID
	if qID != "" {

		if err := r.SetQueryParam("id", qID); err != nil {
			return err
		}
	}

	if o.IncludeFiles != nil {

		// query param include_files
		var qrIncludeFiles bool

		if o.IncludeFiles != nil {
			qrIncludeFiles = *o.IncludeFiles
		}
		qIncludeFiles := swag.FormatBool(qrIncludeFiles)
		if qIncludeFiles != "" {

			if err := r.SetQueryParam("include_files", qIncludeFiles); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
