// Code generated by go-swagger; DO NOT EDIT.

package sample_uploads

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ArchiveUploadV1Reader is a Reader for the ArchiveUploadV1 structure.
type ArchiveUploadV1Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ArchiveUploadV1Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewArchiveUploadV1OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewArchiveUploadV1Accepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewArchiveUploadV1BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewArchiveUploadV1Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewArchiveUploadV1TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewArchiveUploadV1InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /archives/entities/archives/v1] ArchiveUploadV1", response, response.Code())
	}
}

// NewArchiveUploadV1OK creates a ArchiveUploadV1OK with default headers values
func NewArchiveUploadV1OK() *ArchiveUploadV1OK {
	return &ArchiveUploadV1OK{}
}

/*
ArchiveUploadV1OK describes a response with status code 200, with default header values.

OK
*/
type ArchiveUploadV1OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ClientArchiveCreateResponseV1
}

// IsSuccess returns true when this archive upload v1 o k response has a 2xx status code
func (o *ArchiveUploadV1OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this archive upload v1 o k response has a 3xx status code
func (o *ArchiveUploadV1OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this archive upload v1 o k response has a 4xx status code
func (o *ArchiveUploadV1OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this archive upload v1 o k response has a 5xx status code
func (o *ArchiveUploadV1OK) IsServerError() bool {
	return false
}

// IsCode returns true when this archive upload v1 o k response a status code equal to that given
func (o *ArchiveUploadV1OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the archive upload v1 o k response
func (o *ArchiveUploadV1OK) Code() int {
	return 200
}

func (o *ArchiveUploadV1OK) Error() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1OK  %+v", 200, o.Payload)
}

func (o *ArchiveUploadV1OK) String() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1OK  %+v", 200, o.Payload)
}

func (o *ArchiveUploadV1OK) GetPayload() *models.ClientArchiveCreateResponseV1 {
	return o.Payload
}

func (o *ArchiveUploadV1OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ClientArchiveCreateResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewArchiveUploadV1Accepted creates a ArchiveUploadV1Accepted with default headers values
func NewArchiveUploadV1Accepted() *ArchiveUploadV1Accepted {
	return &ArchiveUploadV1Accepted{}
}

/*
ArchiveUploadV1Accepted describes a response with status code 202, with default header values.

OK
*/
type ArchiveUploadV1Accepted struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ClientArchiveCreateResponseV1
}

// IsSuccess returns true when this archive upload v1 accepted response has a 2xx status code
func (o *ArchiveUploadV1Accepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this archive upload v1 accepted response has a 3xx status code
func (o *ArchiveUploadV1Accepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this archive upload v1 accepted response has a 4xx status code
func (o *ArchiveUploadV1Accepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this archive upload v1 accepted response has a 5xx status code
func (o *ArchiveUploadV1Accepted) IsServerError() bool {
	return false
}

// IsCode returns true when this archive upload v1 accepted response a status code equal to that given
func (o *ArchiveUploadV1Accepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the archive upload v1 accepted response
func (o *ArchiveUploadV1Accepted) Code() int {
	return 202
}

func (o *ArchiveUploadV1Accepted) Error() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1Accepted  %+v", 202, o.Payload)
}

func (o *ArchiveUploadV1Accepted) String() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1Accepted  %+v", 202, o.Payload)
}

func (o *ArchiveUploadV1Accepted) GetPayload() *models.ClientArchiveCreateResponseV1 {
	return o.Payload
}

func (o *ArchiveUploadV1Accepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ClientArchiveCreateResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewArchiveUploadV1BadRequest creates a ArchiveUploadV1BadRequest with default headers values
func NewArchiveUploadV1BadRequest() *ArchiveUploadV1BadRequest {
	return &ArchiveUploadV1BadRequest{}
}

/*
ArchiveUploadV1BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type ArchiveUploadV1BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ClientArchiveCreateResponseV1
}

// IsSuccess returns true when this archive upload v1 bad request response has a 2xx status code
func (o *ArchiveUploadV1BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this archive upload v1 bad request response has a 3xx status code
func (o *ArchiveUploadV1BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this archive upload v1 bad request response has a 4xx status code
func (o *ArchiveUploadV1BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this archive upload v1 bad request response has a 5xx status code
func (o *ArchiveUploadV1BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this archive upload v1 bad request response a status code equal to that given
func (o *ArchiveUploadV1BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the archive upload v1 bad request response
func (o *ArchiveUploadV1BadRequest) Code() int {
	return 400
}

func (o *ArchiveUploadV1BadRequest) Error() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1BadRequest  %+v", 400, o.Payload)
}

func (o *ArchiveUploadV1BadRequest) String() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1BadRequest  %+v", 400, o.Payload)
}

func (o *ArchiveUploadV1BadRequest) GetPayload() *models.ClientArchiveCreateResponseV1 {
	return o.Payload
}

func (o *ArchiveUploadV1BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ClientArchiveCreateResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewArchiveUploadV1Forbidden creates a ArchiveUploadV1Forbidden with default headers values
func NewArchiveUploadV1Forbidden() *ArchiveUploadV1Forbidden {
	return &ArchiveUploadV1Forbidden{}
}

/*
ArchiveUploadV1Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ArchiveUploadV1Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this archive upload v1 forbidden response has a 2xx status code
func (o *ArchiveUploadV1Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this archive upload v1 forbidden response has a 3xx status code
func (o *ArchiveUploadV1Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this archive upload v1 forbidden response has a 4xx status code
func (o *ArchiveUploadV1Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this archive upload v1 forbidden response has a 5xx status code
func (o *ArchiveUploadV1Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this archive upload v1 forbidden response a status code equal to that given
func (o *ArchiveUploadV1Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the archive upload v1 forbidden response
func (o *ArchiveUploadV1Forbidden) Code() int {
	return 403
}

func (o *ArchiveUploadV1Forbidden) Error() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1Forbidden  %+v", 403, o.Payload)
}

func (o *ArchiveUploadV1Forbidden) String() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1Forbidden  %+v", 403, o.Payload)
}

func (o *ArchiveUploadV1Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ArchiveUploadV1Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewArchiveUploadV1TooManyRequests creates a ArchiveUploadV1TooManyRequests with default headers values
func NewArchiveUploadV1TooManyRequests() *ArchiveUploadV1TooManyRequests {
	return &ArchiveUploadV1TooManyRequests{}
}

/*
ArchiveUploadV1TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ArchiveUploadV1TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this archive upload v1 too many requests response has a 2xx status code
func (o *ArchiveUploadV1TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this archive upload v1 too many requests response has a 3xx status code
func (o *ArchiveUploadV1TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this archive upload v1 too many requests response has a 4xx status code
func (o *ArchiveUploadV1TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this archive upload v1 too many requests response has a 5xx status code
func (o *ArchiveUploadV1TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this archive upload v1 too many requests response a status code equal to that given
func (o *ArchiveUploadV1TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the archive upload v1 too many requests response
func (o *ArchiveUploadV1TooManyRequests) Code() int {
	return 429
}

func (o *ArchiveUploadV1TooManyRequests) Error() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *ArchiveUploadV1TooManyRequests) String() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1TooManyRequests  %+v", 429, o.Payload)
}

func (o *ArchiveUploadV1TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ArchiveUploadV1TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewArchiveUploadV1InternalServerError creates a ArchiveUploadV1InternalServerError with default headers values
func NewArchiveUploadV1InternalServerError() *ArchiveUploadV1InternalServerError {
	return &ArchiveUploadV1InternalServerError{}
}

/*
ArchiveUploadV1InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type ArchiveUploadV1InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.ClientArchiveCreateResponseV1
}

// IsSuccess returns true when this archive upload v1 internal server error response has a 2xx status code
func (o *ArchiveUploadV1InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this archive upload v1 internal server error response has a 3xx status code
func (o *ArchiveUploadV1InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this archive upload v1 internal server error response has a 4xx status code
func (o *ArchiveUploadV1InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this archive upload v1 internal server error response has a 5xx status code
func (o *ArchiveUploadV1InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this archive upload v1 internal server error response a status code equal to that given
func (o *ArchiveUploadV1InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the archive upload v1 internal server error response
func (o *ArchiveUploadV1InternalServerError) Code() int {
	return 500
}

func (o *ArchiveUploadV1InternalServerError) Error() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1InternalServerError  %+v", 500, o.Payload)
}

func (o *ArchiveUploadV1InternalServerError) String() string {
	return fmt.Sprintf("[POST /archives/entities/archives/v1][%d] archiveUploadV1InternalServerError  %+v", 500, o.Payload)
}

func (o *ArchiveUploadV1InternalServerError) GetPayload() *models.ClientArchiveCreateResponseV1 {
	return o.Payload
}

func (o *ArchiveUploadV1InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.ClientArchiveCreateResponseV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
