// Code generated by go-swagger; DO NOT EDIT.

package sample_uploads

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewArchiveUploadV2Params creates a new ArchiveUploadV2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewArchiveUploadV2Params() *ArchiveUploadV2Params {
	return &ArchiveUploadV2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewArchiveUploadV2ParamsWithTimeout creates a new ArchiveUploadV2Params object
// with the ability to set a timeout on a request.
func NewArchiveUploadV2ParamsWithTimeout(timeout time.Duration) *ArchiveUploadV2Params {
	return &ArchiveUploadV2Params{
		timeout: timeout,
	}
}

// NewArchiveUploadV2ParamsWithContext creates a new ArchiveUploadV2Params object
// with the ability to set a context for a request.
func NewArchiveUploadV2ParamsWithContext(ctx context.Context) *ArchiveUploadV2Params {
	return &ArchiveUploadV2Params{
		Context: ctx,
	}
}

// NewArchiveUploadV2ParamsWithHTTPClient creates a new ArchiveUploadV2Params object
// with the ability to set a custom HTTPClient for a request.
func NewArchiveUploadV2ParamsWithHTTPClient(client *http.Client) *ArchiveUploadV2Params {
	return &ArchiveUploadV2Params{
		HTTPClient: client,
	}
}

/*
ArchiveUploadV2Params contains all the parameters to send to the API endpoint

	for the archive upload v2 operation.

	Typically these are written to a http.Request.
*/
type ArchiveUploadV2Params struct {

	/* Comment.

	   A descriptive comment to identify the file for other users. For example, use `--form comment=` when using cURL.
	*/
	Comment *string

	/* File.

	   Content of the uploaded archive. For example, use `--form file=@$FILE_PATH;type=` when using cURL. Supported file types are `application/zip` and `application/x-7z-compressed`.
	*/
	File runtime.NamedReadCloser

	/* IsConfidential.

	     Defines visibility of this file in Falcon MalQuery, either via the API or the Falcon console. For example, use `--form is_confidential=` when using cURL.

	- `true`: File is only shown to users within your customer account
	- `false`: File can be seen by other CrowdStrike customers

	Default: `true`.

	     Default: true
	*/
	IsConfidential *bool

	/* Name.

	   Name of the archive. For example, use `--form name=` when using cURL.
	*/
	Name string

	/* Password.

	   Archive password. For example, use `--form password=` when using cURL.
	*/
	Password *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the archive upload v2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ArchiveUploadV2Params) WithDefaults() *ArchiveUploadV2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the archive upload v2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ArchiveUploadV2Params) SetDefaults() {
	var (
		isConfidentialDefault = bool(true)
	)

	val := ArchiveUploadV2Params{
		IsConfidential: &isConfidentialDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the archive upload v2 params
func (o *ArchiveUploadV2Params) WithTimeout(timeout time.Duration) *ArchiveUploadV2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the archive upload v2 params
func (o *ArchiveUploadV2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the archive upload v2 params
func (o *ArchiveUploadV2Params) WithContext(ctx context.Context) *ArchiveUploadV2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the archive upload v2 params
func (o *ArchiveUploadV2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the archive upload v2 params
func (o *ArchiveUploadV2Params) WithHTTPClient(client *http.Client) *ArchiveUploadV2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the archive upload v2 params
func (o *ArchiveUploadV2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the archive upload v2 params
func (o *ArchiveUploadV2Params) WithComment(comment *string) *ArchiveUploadV2Params {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the archive upload v2 params
func (o *ArchiveUploadV2Params) SetComment(comment *string) {
	o.Comment = comment
}

// WithFile adds the file to the archive upload v2 params
func (o *ArchiveUploadV2Params) WithFile(file runtime.NamedReadCloser) *ArchiveUploadV2Params {
	o.SetFile(file)
	return o
}

// SetFile adds the file to the archive upload v2 params
func (o *ArchiveUploadV2Params) SetFile(file runtime.NamedReadCloser) {
	o.File = file
}

// WithIsConfidential adds the isConfidential to the archive upload v2 params
func (o *ArchiveUploadV2Params) WithIsConfidential(isConfidential *bool) *ArchiveUploadV2Params {
	o.SetIsConfidential(isConfidential)
	return o
}

// SetIsConfidential adds the isConfidential to the archive upload v2 params
func (o *ArchiveUploadV2Params) SetIsConfidential(isConfidential *bool) {
	o.IsConfidential = isConfidential
}

// WithName adds the name to the archive upload v2 params
func (o *ArchiveUploadV2Params) WithName(name string) *ArchiveUploadV2Params {
	o.SetName(name)
	return o
}

// SetName adds the name to the archive upload v2 params
func (o *ArchiveUploadV2Params) SetName(name string) {
	o.Name = name
}

// WithPassword adds the password to the archive upload v2 params
func (o *ArchiveUploadV2Params) WithPassword(password *string) *ArchiveUploadV2Params {
	o.SetPassword(password)
	return o
}

// SetPassword adds the password to the archive upload v2 params
func (o *ArchiveUploadV2Params) SetPassword(password *string) {
	o.Password = password
}

// WriteToRequest writes these params to a swagger request
func (o *ArchiveUploadV2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// form param comment
		var frComment string
		if o.Comment != nil {
			frComment = *o.Comment
		}
		fComment := frComment
		if fComment != "" {
			if err := r.SetFormParam("comment", fComment); err != nil {
				return err
			}
		}
	}
	// form file param file
	if err := r.SetFileParam("file", o.File); err != nil {
		return err
	}

	if o.IsConfidential != nil {

		// form param is_confidential
		var frIsConfidential bool
		if o.IsConfidential != nil {
			frIsConfidential = *o.IsConfidential
		}
		fIsConfidential := swag.FormatBool(frIsConfidential)
		if fIsConfidential != "" {
			if err := r.SetFormParam("is_confidential", fIsConfidential); err != nil {
				return err
			}
		}
	}

	// form param name
	frName := o.Name
	fName := frName
	if fName != "" {
		if err := r.SetFormParam("name", fName); err != nil {
			return err
		}
	}

	if o.Password != nil {

		// form param password
		var frPassword string
		if o.Password != nil {
			frPassword = *o.Password
		}
		fPassword := frPassword
		if fPassword != "" {
			if err := r.SetFormParam("password", fPassword); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
