// Code generated by go-swagger; DO NOT EDIT.

package sample_uploads

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewExtractionListV1Params creates a new ExtractionListV1Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewExtractionListV1Params() *ExtractionListV1Params {
	return &ExtractionListV1Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewExtractionListV1ParamsWithTimeout creates a new ExtractionListV1Params object
// with the ability to set a timeout on a request.
func NewExtractionListV1ParamsWithTimeout(timeout time.Duration) *ExtractionListV1Params {
	return &ExtractionListV1Params{
		timeout: timeout,
	}
}

// NewExtractionListV1ParamsWithContext creates a new ExtractionListV1Params object
// with the ability to set a context for a request.
func NewExtractionListV1ParamsWithContext(ctx context.Context) *ExtractionListV1Params {
	return &ExtractionListV1Params{
		Context: ctx,
	}
}

// NewExtractionListV1ParamsWithHTTPClient creates a new ExtractionListV1Params object
// with the ability to set a custom HTTPClient for a request.
func NewExtractionListV1ParamsWithHTTPClient(client *http.Client) *ExtractionListV1Params {
	return &ExtractionListV1Params{
		HTTPClient: client,
	}
}

/*
ExtractionListV1Params contains all the parameters to send to the API endpoint

	for the extraction list v1 operation.

	Typically these are written to a http.Request.
*/
type ExtractionListV1Params struct {

	/* ID.

	   The extraction operation ID.
	*/
	ID string

	/* Limit.

	   Max number of file extractions to retrieve.
	*/
	Limit *int64

	/* Offset.

	   Offset from where to get file extractions.
	*/
	Offset *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the extraction list v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExtractionListV1Params) WithDefaults() *ExtractionListV1Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the extraction list v1 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExtractionListV1Params) SetDefaults() {
	var (
		limitDefault = int64(0)
	)

	val := ExtractionListV1Params{
		Limit: &limitDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the extraction list v1 params
func (o *ExtractionListV1Params) WithTimeout(timeout time.Duration) *ExtractionListV1Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the extraction list v1 params
func (o *ExtractionListV1Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the extraction list v1 params
func (o *ExtractionListV1Params) WithContext(ctx context.Context) *ExtractionListV1Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the extraction list v1 params
func (o *ExtractionListV1Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the extraction list v1 params
func (o *ExtractionListV1Params) WithHTTPClient(client *http.Client) *ExtractionListV1Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the extraction list v1 params
func (o *ExtractionListV1Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the extraction list v1 params
func (o *ExtractionListV1Params) WithID(id string) *ExtractionListV1Params {
	o.SetID(id)
	return o
}

// SetID adds the id to the extraction list v1 params
func (o *ExtractionListV1Params) SetID(id string) {
	o.ID = id
}

// WithLimit adds the limit to the extraction list v1 params
func (o *ExtractionListV1Params) WithLimit(limit *int64) *ExtractionListV1Params {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the extraction list v1 params
func (o *ExtractionListV1Params) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the extraction list v1 params
func (o *ExtractionListV1Params) WithOffset(offset *string) *ExtractionListV1Params {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the extraction list v1 params
func (o *ExtractionListV1Params) SetOffset(offset *string) {
	o.Offset = offset
}

// WriteToRequest writes these params to a swagger request
func (o *ExtractionListV1Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param id
	qrID := o.ID
	qID := qrID
	if qID != "" {

		if err := r.SetQueryParam("id", qID); err != nil {
			return err
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset string

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := qrOffset
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
