// Code generated by go-swagger; DO NOT EDIT.

package sample_uploads

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetSampleV3Params creates a new GetSampleV3Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetSampleV3Params() *GetSampleV3Params {
	return &GetSampleV3Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetSampleV3ParamsWithTimeout creates a new GetSampleV3Params object
// with the ability to set a timeout on a request.
func NewGetSampleV3ParamsWithTimeout(timeout time.Duration) *GetSampleV3Params {
	return &GetSampleV3Params{
		timeout: timeout,
	}
}

// NewGetSampleV3ParamsWithContext creates a new GetSampleV3Params object
// with the ability to set a context for a request.
func NewGetSampleV3ParamsWithContext(ctx context.Context) *GetSampleV3Params {
	return &GetSampleV3Params{
		Context: ctx,
	}
}

// NewGetSampleV3ParamsWithHTTPClient creates a new GetSampleV3Params object
// with the ability to set a custom HTTPClient for a request.
func NewGetSampleV3ParamsWithHTTPClient(client *http.Client) *GetSampleV3Params {
	return &GetSampleV3Params{
		HTTPClient: client,
	}
}

/*
GetSampleV3Params contains all the parameters to send to the API endpoint

	for the get sample v3 operation.

	Typically these are written to a http.Request.
*/
type GetSampleV3Params struct {

	/* Ids.

	   The file SHA256.
	*/
	Ids string

	/* PasswordProtected.

	   Flag whether the sample should be zipped and password protected with pass='infected'
	*/
	PasswordProtected *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get sample v3 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSampleV3Params) WithDefaults() *GetSampleV3Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get sample v3 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetSampleV3Params) SetDefaults() {
	var (
		passwordProtectedDefault = bool(false)
	)

	val := GetSampleV3Params{
		PasswordProtected: &passwordProtectedDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get sample v3 params
func (o *GetSampleV3Params) WithTimeout(timeout time.Duration) *GetSampleV3Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get sample v3 params
func (o *GetSampleV3Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get sample v3 params
func (o *GetSampleV3Params) WithContext(ctx context.Context) *GetSampleV3Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get sample v3 params
func (o *GetSampleV3Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get sample v3 params
func (o *GetSampleV3Params) WithHTTPClient(client *http.Client) *GetSampleV3Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get sample v3 params
func (o *GetSampleV3Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the get sample v3 params
func (o *GetSampleV3Params) WithIds(ids string) *GetSampleV3Params {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the get sample v3 params
func (o *GetSampleV3Params) SetIds(ids string) {
	o.Ids = ids
}

// WithPasswordProtected adds the passwordProtected to the get sample v3 params
func (o *GetSampleV3Params) WithPasswordProtected(passwordProtected *bool) *GetSampleV3Params {
	o.SetPasswordProtected(passwordProtected)
	return o
}

// SetPasswordProtected adds the passwordProtected to the get sample v3 params
func (o *GetSampleV3Params) SetPasswordProtected(passwordProtected *bool) {
	o.PasswordProtected = passwordProtected
}

// WriteToRequest writes these params to a swagger request
func (o *GetSampleV3Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param ids
	qrIds := o.Ids
	qIds := qrIds
	if qIds != "" {

		if err := r.SetQueryParam("ids", qIds); err != nil {
			return err
		}
	}

	if o.PasswordProtected != nil {

		// query param password_protected
		var qrPasswordProtected bool

		if o.PasswordProtected != nil {
			qrPasswordProtected = *o.PasswordProtected
		}
		qPasswordProtected := swag.FormatBool(qrPasswordProtected)
		if qPasswordProtected != "" {

			if err := r.SetQueryParam("password_protected", qPasswordProtected); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
