// Code generated by go-swagger; DO NOT EDIT.

package sample_uploads

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetSampleV3Reader is a Reader for the GetSampleV3 structure.
type GetSampleV3Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSampleV3Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSampleV3OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetSampleV3BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetSampleV3Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetSampleV3NotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetSampleV3TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetSampleV3InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /samples/entities/samples/v3] GetSampleV3", response, response.Code())
	}
}

// NewGetSampleV3OK creates a GetSampleV3OK with default headers values
func NewGetSampleV3OK() *GetSampleV3OK {
	return &GetSampleV3OK{}
}

/*
GetSampleV3OK describes a response with status code 200, with default header values.

OK
*/
type GetSampleV3OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload string
}

// IsSuccess returns true when this get sample v3 o k response has a 2xx status code
func (o *GetSampleV3OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get sample v3 o k response has a 3xx status code
func (o *GetSampleV3OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sample v3 o k response has a 4xx status code
func (o *GetSampleV3OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get sample v3 o k response has a 5xx status code
func (o *GetSampleV3OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get sample v3 o k response a status code equal to that given
func (o *GetSampleV3OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get sample v3 o k response
func (o *GetSampleV3OK) Code() int {
	return 200
}

func (o *GetSampleV3OK) Error() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3OK  %+v", 200, o.Payload)
}

func (o *GetSampleV3OK) String() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3OK  %+v", 200, o.Payload)
}

func (o *GetSampleV3OK) GetPayload() string {
	return o.Payload
}

func (o *GetSampleV3OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSampleV3BadRequest creates a GetSampleV3BadRequest with default headers values
func NewGetSampleV3BadRequest() *GetSampleV3BadRequest {
	return &GetSampleV3BadRequest{}
}

/*
GetSampleV3BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetSampleV3BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sample v3 bad request response has a 2xx status code
func (o *GetSampleV3BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sample v3 bad request response has a 3xx status code
func (o *GetSampleV3BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sample v3 bad request response has a 4xx status code
func (o *GetSampleV3BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sample v3 bad request response has a 5xx status code
func (o *GetSampleV3BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get sample v3 bad request response a status code equal to that given
func (o *GetSampleV3BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get sample v3 bad request response
func (o *GetSampleV3BadRequest) Code() int {
	return 400
}

func (o *GetSampleV3BadRequest) Error() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3BadRequest  %+v", 400, o.Payload)
}

func (o *GetSampleV3BadRequest) String() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3BadRequest  %+v", 400, o.Payload)
}

func (o *GetSampleV3BadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSampleV3BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSampleV3Forbidden creates a GetSampleV3Forbidden with default headers values
func NewGetSampleV3Forbidden() *GetSampleV3Forbidden {
	return &GetSampleV3Forbidden{}
}

/*
GetSampleV3Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetSampleV3Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sample v3 forbidden response has a 2xx status code
func (o *GetSampleV3Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sample v3 forbidden response has a 3xx status code
func (o *GetSampleV3Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sample v3 forbidden response has a 4xx status code
func (o *GetSampleV3Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sample v3 forbidden response has a 5xx status code
func (o *GetSampleV3Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get sample v3 forbidden response a status code equal to that given
func (o *GetSampleV3Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get sample v3 forbidden response
func (o *GetSampleV3Forbidden) Code() int {
	return 403
}

func (o *GetSampleV3Forbidden) Error() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3Forbidden  %+v", 403, o.Payload)
}

func (o *GetSampleV3Forbidden) String() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3Forbidden  %+v", 403, o.Payload)
}

func (o *GetSampleV3Forbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSampleV3Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSampleV3NotFound creates a GetSampleV3NotFound with default headers values
func NewGetSampleV3NotFound() *GetSampleV3NotFound {
	return &GetSampleV3NotFound{}
}

/*
GetSampleV3NotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetSampleV3NotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sample v3 not found response has a 2xx status code
func (o *GetSampleV3NotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sample v3 not found response has a 3xx status code
func (o *GetSampleV3NotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sample v3 not found response has a 4xx status code
func (o *GetSampleV3NotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sample v3 not found response has a 5xx status code
func (o *GetSampleV3NotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get sample v3 not found response a status code equal to that given
func (o *GetSampleV3NotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get sample v3 not found response
func (o *GetSampleV3NotFound) Code() int {
	return 404
}

func (o *GetSampleV3NotFound) Error() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3NotFound  %+v", 404, o.Payload)
}

func (o *GetSampleV3NotFound) String() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3NotFound  %+v", 404, o.Payload)
}

func (o *GetSampleV3NotFound) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSampleV3NotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSampleV3TooManyRequests creates a GetSampleV3TooManyRequests with default headers values
func NewGetSampleV3TooManyRequests() *GetSampleV3TooManyRequests {
	return &GetSampleV3TooManyRequests{}
}

/*
GetSampleV3TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetSampleV3TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sample v3 too many requests response has a 2xx status code
func (o *GetSampleV3TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sample v3 too many requests response has a 3xx status code
func (o *GetSampleV3TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sample v3 too many requests response has a 4xx status code
func (o *GetSampleV3TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sample v3 too many requests response has a 5xx status code
func (o *GetSampleV3TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get sample v3 too many requests response a status code equal to that given
func (o *GetSampleV3TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get sample v3 too many requests response
func (o *GetSampleV3TooManyRequests) Code() int {
	return 429
}

func (o *GetSampleV3TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetSampleV3TooManyRequests) String() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetSampleV3TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSampleV3TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSampleV3InternalServerError creates a GetSampleV3InternalServerError with default headers values
func NewGetSampleV3InternalServerError() *GetSampleV3InternalServerError {
	return &GetSampleV3InternalServerError{}
}

/*
GetSampleV3InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetSampleV3InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sample v3 internal server error response has a 2xx status code
func (o *GetSampleV3InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sample v3 internal server error response has a 3xx status code
func (o *GetSampleV3InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sample v3 internal server error response has a 4xx status code
func (o *GetSampleV3InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get sample v3 internal server error response has a 5xx status code
func (o *GetSampleV3InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get sample v3 internal server error response a status code equal to that given
func (o *GetSampleV3InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get sample v3 internal server error response
func (o *GetSampleV3InternalServerError) Code() int {
	return 500
}

func (o *GetSampleV3InternalServerError) Error() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3InternalServerError  %+v", 500, o.Payload)
}

func (o *GetSampleV3InternalServerError) String() string {
	return fmt.Sprintf("[GET /samples/entities/samples/v3][%d] getSampleV3InternalServerError  %+v", 500, o.Payload)
}

func (o *GetSampleV3InternalServerError) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSampleV3InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
