// Code generated by go-swagger; DO NOT EDIT.

package scheduled_reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new scheduled reports API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for scheduled reports API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ScheduledReportsGet(params *ScheduledReportsGetParams, opts ...ClientOption) (*ScheduledReportsGetOK, error)

	ScheduledReportsLaunch(params *ScheduledReportsLaunchParams, opts ...ClientOption) (*ScheduledReportsLaunchOK, error)

	ScheduledReportsQuery(params *ScheduledReportsQueryParams, opts ...ClientOption) (*ScheduledReportsQueryOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ScheduledReportsGet retrieves scheduled reports for the provided report i ds
*/
func (a *Client) ScheduledReportsGet(params *ScheduledReportsGetParams, opts ...ClientOption) (*ScheduledReportsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduledReportsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "scheduled-reports.get",
		Method:             "GET",
		PathPattern:        "/reports/entities/scheduled-reports/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduledReportsGetReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduledReportsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for scheduled-reports.get: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ScheduledReportsLaunch launches scheduled reports executions for the provided report i ds
*/
func (a *Client) ScheduledReportsLaunch(params *ScheduledReportsLaunchParams, opts ...ClientOption) (*ScheduledReportsLaunchOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduledReportsLaunchParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "scheduled-reports.launch",
		Method:             "POST",
		PathPattern:        "/reports/entities/scheduled-reports/execution/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduledReportsLaunchReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduledReportsLaunchOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for scheduled-reports.launch: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ScheduledReportsQuery finds all report i ds matching the query with filter
*/
func (a *Client) ScheduledReportsQuery(params *ScheduledReportsQueryParams, opts ...ClientOption) (*ScheduledReportsQueryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewScheduledReportsQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "scheduled-reports.query",
		Method:             "GET",
		PathPattern:        "/reports/queries/scheduled-reports/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ScheduledReportsQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ScheduledReportsQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for scheduled-reports.query: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
