// Code generated by go-swagger; DO NOT EDIT.

package scheduled_reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewScheduledReportsGetParams creates a new ScheduledReportsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewScheduledReportsGetParams() *ScheduledReportsGetParams {
	return &ScheduledReportsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewScheduledReportsGetParamsWithTimeout creates a new ScheduledReportsGetParams object
// with the ability to set a timeout on a request.
func NewScheduledReportsGetParamsWithTimeout(timeout time.Duration) *ScheduledReportsGetParams {
	return &ScheduledReportsGetParams{
		timeout: timeout,
	}
}

// NewScheduledReportsGetParamsWithContext creates a new ScheduledReportsGetParams object
// with the ability to set a context for a request.
func NewScheduledReportsGetParamsWithContext(ctx context.Context) *ScheduledReportsGetParams {
	return &ScheduledReportsGetParams{
		Context: ctx,
	}
}

// NewScheduledReportsGetParamsWithHTTPClient creates a new ScheduledReportsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewScheduledReportsGetParamsWithHTTPClient(client *http.Client) *ScheduledReportsGetParams {
	return &ScheduledReportsGetParams{
		HTTPClient: client,
	}
}

/*
ScheduledReportsGetParams contains all the parameters to send to the API endpoint

	for the scheduled reports get operation.

	Typically these are written to a http.Request.
*/
type ScheduledReportsGetParams struct {

	/* Ids.

	   The scheduled_report id to get details about.
	*/
	Ids []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the scheduled reports get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduledReportsGetParams) WithDefaults() *ScheduledReportsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the scheduled reports get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ScheduledReportsGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the scheduled reports get params
func (o *ScheduledReportsGetParams) WithTimeout(timeout time.Duration) *ScheduledReportsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the scheduled reports get params
func (o *ScheduledReportsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the scheduled reports get params
func (o *ScheduledReportsGetParams) WithContext(ctx context.Context) *ScheduledReportsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the scheduled reports get params
func (o *ScheduledReportsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the scheduled reports get params
func (o *ScheduledReportsGetParams) WithHTTPClient(client *http.Client) *ScheduledReportsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the scheduled reports get params
func (o *ScheduledReportsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIds adds the ids to the scheduled reports get params
func (o *ScheduledReportsGetParams) WithIds(ids []string) *ScheduledReportsGetParams {
	o.SetIds(ids)
	return o
}

// SetIds adds the ids to the scheduled reports get params
func (o *ScheduledReportsGetParams) SetIds(ids []string) {
	o.Ids = ids
}

// WriteToRequest writes these params to a swagger request
func (o *ScheduledReportsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Ids != nil {

		// binding items for ids
		joinedIds := o.bindParamIds(reg)

		// query array param ids
		if err := r.SetQueryParam("ids", joinedIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamScheduledReportsGet binds the parameter ids
func (o *ScheduledReportsGetParams) bindParamIds(formats strfmt.Registry) []string {
	idsIR := o.Ids

	var idsIC []string
	for _, idsIIR := range idsIR { // explode []string

		idsIIV := idsIIR // string as string
		idsIC = append(idsIC, idsIIV)
	}

	// items.CollectionFormat: "multi"
	idsIS := swag.JoinByFormat(idsIC, "multi")

	return idsIS
}
