// Code generated by go-swagger; DO NOT EDIT.

package scheduled_reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ScheduledReportsGetReader is a Reader for the ScheduledReportsGet structure.
type ScheduledReportsGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ScheduledReportsGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewScheduledReportsGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewScheduledReportsGetBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewScheduledReportsGetForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewScheduledReportsGetTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /reports/entities/scheduled-reports/v1] scheduled-reports.get", response, response.Code())
	}
}

// NewScheduledReportsGetOK creates a ScheduledReportsGetOK with default headers values
func NewScheduledReportsGetOK() *ScheduledReportsGetOK {
	return &ScheduledReportsGetOK{}
}

/*
ScheduledReportsGetOK describes a response with status code 200, with default header values.

OK
*/
type ScheduledReportsGetOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainScheduledReportsResultV1
}

// IsSuccess returns true when this scheduled reports get o k response has a 2xx status code
func (o *ScheduledReportsGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this scheduled reports get o k response has a 3xx status code
func (o *ScheduledReportsGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this scheduled reports get o k response has a 4xx status code
func (o *ScheduledReportsGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this scheduled reports get o k response has a 5xx status code
func (o *ScheduledReportsGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this scheduled reports get o k response a status code equal to that given
func (o *ScheduledReportsGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the scheduled reports get o k response
func (o *ScheduledReportsGetOK) Code() int {
	return 200
}

func (o *ScheduledReportsGetOK) Error() string {
	return fmt.Sprintf("[GET /reports/entities/scheduled-reports/v1][%d] scheduledReportsGetOK  %+v", 200, o.Payload)
}

func (o *ScheduledReportsGetOK) String() string {
	return fmt.Sprintf("[GET /reports/entities/scheduled-reports/v1][%d] scheduledReportsGetOK  %+v", 200, o.Payload)
}

func (o *ScheduledReportsGetOK) GetPayload() *models.DomainScheduledReportsResultV1 {
	return o.Payload
}

func (o *ScheduledReportsGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainScheduledReportsResultV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewScheduledReportsGetBadRequest creates a ScheduledReportsGetBadRequest with default headers values
func NewScheduledReportsGetBadRequest() *ScheduledReportsGetBadRequest {
	return &ScheduledReportsGetBadRequest{}
}

/*
ScheduledReportsGetBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type ScheduledReportsGetBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this scheduled reports get bad request response has a 2xx status code
func (o *ScheduledReportsGetBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this scheduled reports get bad request response has a 3xx status code
func (o *ScheduledReportsGetBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this scheduled reports get bad request response has a 4xx status code
func (o *ScheduledReportsGetBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this scheduled reports get bad request response has a 5xx status code
func (o *ScheduledReportsGetBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this scheduled reports get bad request response a status code equal to that given
func (o *ScheduledReportsGetBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the scheduled reports get bad request response
func (o *ScheduledReportsGetBadRequest) Code() int {
	return 400
}

func (o *ScheduledReportsGetBadRequest) Error() string {
	return fmt.Sprintf("[GET /reports/entities/scheduled-reports/v1][%d] scheduledReportsGetBadRequest  %+v", 400, o.Payload)
}

func (o *ScheduledReportsGetBadRequest) String() string {
	return fmt.Sprintf("[GET /reports/entities/scheduled-reports/v1][%d] scheduledReportsGetBadRequest  %+v", 400, o.Payload)
}

func (o *ScheduledReportsGetBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ScheduledReportsGetBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewScheduledReportsGetForbidden creates a ScheduledReportsGetForbidden with default headers values
func NewScheduledReportsGetForbidden() *ScheduledReportsGetForbidden {
	return &ScheduledReportsGetForbidden{}
}

/*
ScheduledReportsGetForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ScheduledReportsGetForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this scheduled reports get forbidden response has a 2xx status code
func (o *ScheduledReportsGetForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this scheduled reports get forbidden response has a 3xx status code
func (o *ScheduledReportsGetForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this scheduled reports get forbidden response has a 4xx status code
func (o *ScheduledReportsGetForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this scheduled reports get forbidden response has a 5xx status code
func (o *ScheduledReportsGetForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this scheduled reports get forbidden response a status code equal to that given
func (o *ScheduledReportsGetForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the scheduled reports get forbidden response
func (o *ScheduledReportsGetForbidden) Code() int {
	return 403
}

func (o *ScheduledReportsGetForbidden) Error() string {
	return fmt.Sprintf("[GET /reports/entities/scheduled-reports/v1][%d] scheduledReportsGetForbidden  %+v", 403, o.Payload)
}

func (o *ScheduledReportsGetForbidden) String() string {
	return fmt.Sprintf("[GET /reports/entities/scheduled-reports/v1][%d] scheduledReportsGetForbidden  %+v", 403, o.Payload)
}

func (o *ScheduledReportsGetForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ScheduledReportsGetForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewScheduledReportsGetTooManyRequests creates a ScheduledReportsGetTooManyRequests with default headers values
func NewScheduledReportsGetTooManyRequests() *ScheduledReportsGetTooManyRequests {
	return &ScheduledReportsGetTooManyRequests{}
}

/*
ScheduledReportsGetTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ScheduledReportsGetTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this scheduled reports get too many requests response has a 2xx status code
func (o *ScheduledReportsGetTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this scheduled reports get too many requests response has a 3xx status code
func (o *ScheduledReportsGetTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this scheduled reports get too many requests response has a 4xx status code
func (o *ScheduledReportsGetTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this scheduled reports get too many requests response has a 5xx status code
func (o *ScheduledReportsGetTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this scheduled reports get too many requests response a status code equal to that given
func (o *ScheduledReportsGetTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the scheduled reports get too many requests response
func (o *ScheduledReportsGetTooManyRequests) Code() int {
	return 429
}

func (o *ScheduledReportsGetTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /reports/entities/scheduled-reports/v1][%d] scheduledReportsGetTooManyRequests  %+v", 429, o.Payload)
}

func (o *ScheduledReportsGetTooManyRequests) String() string {
	return fmt.Sprintf("[GET /reports/entities/scheduled-reports/v1][%d] scheduledReportsGetTooManyRequests  %+v", 429, o.Payload)
}

func (o *ScheduledReportsGetTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ScheduledReportsGetTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
