// Code generated by go-swagger; DO NOT EDIT.

package scheduled_reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// ScheduledReportsQueryReader is a Reader for the ScheduledReportsQuery structure.
type ScheduledReportsQueryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ScheduledReportsQueryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewScheduledReportsQueryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewScheduledReportsQueryBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewScheduledReportsQueryForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewScheduledReportsQueryTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /reports/queries/scheduled-reports/v1] scheduled-reports.query", response, response.Code())
	}
}

// NewScheduledReportsQueryOK creates a ScheduledReportsQueryOK with default headers values
func NewScheduledReportsQueryOK() *ScheduledReportsQueryOK {
	return &ScheduledReportsQueryOK{}
}

/*
ScheduledReportsQueryOK describes a response with status code 200, with default header values.

OK
*/
type ScheduledReportsQueryOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this scheduled reports query o k response has a 2xx status code
func (o *ScheduledReportsQueryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this scheduled reports query o k response has a 3xx status code
func (o *ScheduledReportsQueryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this scheduled reports query o k response has a 4xx status code
func (o *ScheduledReportsQueryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this scheduled reports query o k response has a 5xx status code
func (o *ScheduledReportsQueryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this scheduled reports query o k response a status code equal to that given
func (o *ScheduledReportsQueryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the scheduled reports query o k response
func (o *ScheduledReportsQueryOK) Code() int {
	return 200
}

func (o *ScheduledReportsQueryOK) Error() string {
	return fmt.Sprintf("[GET /reports/queries/scheduled-reports/v1][%d] scheduledReportsQueryOK  %+v", 200, o.Payload)
}

func (o *ScheduledReportsQueryOK) String() string {
	return fmt.Sprintf("[GET /reports/queries/scheduled-reports/v1][%d] scheduledReportsQueryOK  %+v", 200, o.Payload)
}

func (o *ScheduledReportsQueryOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *ScheduledReportsQueryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewScheduledReportsQueryBadRequest creates a ScheduledReportsQueryBadRequest with default headers values
func NewScheduledReportsQueryBadRequest() *ScheduledReportsQueryBadRequest {
	return &ScheduledReportsQueryBadRequest{}
}

/*
ScheduledReportsQueryBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type ScheduledReportsQueryBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this scheduled reports query bad request response has a 2xx status code
func (o *ScheduledReportsQueryBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this scheduled reports query bad request response has a 3xx status code
func (o *ScheduledReportsQueryBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this scheduled reports query bad request response has a 4xx status code
func (o *ScheduledReportsQueryBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this scheduled reports query bad request response has a 5xx status code
func (o *ScheduledReportsQueryBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this scheduled reports query bad request response a status code equal to that given
func (o *ScheduledReportsQueryBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the scheduled reports query bad request response
func (o *ScheduledReportsQueryBadRequest) Code() int {
	return 400
}

func (o *ScheduledReportsQueryBadRequest) Error() string {
	return fmt.Sprintf("[GET /reports/queries/scheduled-reports/v1][%d] scheduledReportsQueryBadRequest  %+v", 400, o.Payload)
}

func (o *ScheduledReportsQueryBadRequest) String() string {
	return fmt.Sprintf("[GET /reports/queries/scheduled-reports/v1][%d] scheduledReportsQueryBadRequest  %+v", 400, o.Payload)
}

func (o *ScheduledReportsQueryBadRequest) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ScheduledReportsQueryBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewScheduledReportsQueryForbidden creates a ScheduledReportsQueryForbidden with default headers values
func NewScheduledReportsQueryForbidden() *ScheduledReportsQueryForbidden {
	return &ScheduledReportsQueryForbidden{}
}

/*
ScheduledReportsQueryForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type ScheduledReportsQueryForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this scheduled reports query forbidden response has a 2xx status code
func (o *ScheduledReportsQueryForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this scheduled reports query forbidden response has a 3xx status code
func (o *ScheduledReportsQueryForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this scheduled reports query forbidden response has a 4xx status code
func (o *ScheduledReportsQueryForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this scheduled reports query forbidden response has a 5xx status code
func (o *ScheduledReportsQueryForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this scheduled reports query forbidden response a status code equal to that given
func (o *ScheduledReportsQueryForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the scheduled reports query forbidden response
func (o *ScheduledReportsQueryForbidden) Code() int {
	return 403
}

func (o *ScheduledReportsQueryForbidden) Error() string {
	return fmt.Sprintf("[GET /reports/queries/scheduled-reports/v1][%d] scheduledReportsQueryForbidden  %+v", 403, o.Payload)
}

func (o *ScheduledReportsQueryForbidden) String() string {
	return fmt.Sprintf("[GET /reports/queries/scheduled-reports/v1][%d] scheduledReportsQueryForbidden  %+v", 403, o.Payload)
}

func (o *ScheduledReportsQueryForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ScheduledReportsQueryForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewScheduledReportsQueryTooManyRequests creates a ScheduledReportsQueryTooManyRequests with default headers values
func NewScheduledReportsQueryTooManyRequests() *ScheduledReportsQueryTooManyRequests {
	return &ScheduledReportsQueryTooManyRequests{}
}

/*
ScheduledReportsQueryTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type ScheduledReportsQueryTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this scheduled reports query too many requests response has a 2xx status code
func (o *ScheduledReportsQueryTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this scheduled reports query too many requests response has a 3xx status code
func (o *ScheduledReportsQueryTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this scheduled reports query too many requests response has a 4xx status code
func (o *ScheduledReportsQueryTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this scheduled reports query too many requests response has a 5xx status code
func (o *ScheduledReportsQueryTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this scheduled reports query too many requests response a status code equal to that given
func (o *ScheduledReportsQueryTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the scheduled reports query too many requests response
func (o *ScheduledReportsQueryTooManyRequests) Code() int {
	return 429
}

func (o *ScheduledReportsQueryTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /reports/queries/scheduled-reports/v1][%d] scheduledReportsQueryTooManyRequests  %+v", 429, o.Payload)
}

func (o *ScheduledReportsQueryTooManyRequests) String() string {
	return fmt.Sprintf("[GET /reports/queries/scheduled-reports/v1][%d] scheduledReportsQueryTooManyRequests  %+v", 429, o.Payload)
}

func (o *ScheduledReportsQueryTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *ScheduledReportsQueryTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
