// Code generated by go-swagger; DO NOT EDIT.

package sensor_download

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetCombinedSensorInstallersByQueryReader is a Reader for the GetCombinedSensorInstallersByQuery structure.
type GetCombinedSensorInstallersByQueryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCombinedSensorInstallersByQueryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCombinedSensorInstallersByQueryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetCombinedSensorInstallersByQueryBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetCombinedSensorInstallersByQueryForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetCombinedSensorInstallersByQueryTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /sensors/combined/installers/v1] GetCombinedSensorInstallersByQuery", response, response.Code())
	}
}

// NewGetCombinedSensorInstallersByQueryOK creates a GetCombinedSensorInstallersByQueryOK with default headers values
func NewGetCombinedSensorInstallersByQueryOK() *GetCombinedSensorInstallersByQueryOK {
	return &GetCombinedSensorInstallersByQueryOK{}
}

/*
GetCombinedSensorInstallersByQueryOK describes a response with status code 200, with default header values.

OK
*/
type GetCombinedSensorInstallersByQueryOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainSensorInstallersV1
}

// IsSuccess returns true when this get combined sensor installers by query o k response has a 2xx status code
func (o *GetCombinedSensorInstallersByQueryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get combined sensor installers by query o k response has a 3xx status code
func (o *GetCombinedSensorInstallersByQueryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined sensor installers by query o k response has a 4xx status code
func (o *GetCombinedSensorInstallersByQueryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get combined sensor installers by query o k response has a 5xx status code
func (o *GetCombinedSensorInstallersByQueryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined sensor installers by query o k response a status code equal to that given
func (o *GetCombinedSensorInstallersByQueryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get combined sensor installers by query o k response
func (o *GetCombinedSensorInstallersByQueryOK) Code() int {
	return 200
}

func (o *GetCombinedSensorInstallersByQueryOK) Error() string {
	return fmt.Sprintf("[GET /sensors/combined/installers/v1][%d] getCombinedSensorInstallersByQueryOK  %+v", 200, o.Payload)
}

func (o *GetCombinedSensorInstallersByQueryOK) String() string {
	return fmt.Sprintf("[GET /sensors/combined/installers/v1][%d] getCombinedSensorInstallersByQueryOK  %+v", 200, o.Payload)
}

func (o *GetCombinedSensorInstallersByQueryOK) GetPayload() *models.DomainSensorInstallersV1 {
	return o.Payload
}

func (o *GetCombinedSensorInstallersByQueryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainSensorInstallersV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedSensorInstallersByQueryBadRequest creates a GetCombinedSensorInstallersByQueryBadRequest with default headers values
func NewGetCombinedSensorInstallersByQueryBadRequest() *GetCombinedSensorInstallersByQueryBadRequest {
	return &GetCombinedSensorInstallersByQueryBadRequest{}
}

/*
GetCombinedSensorInstallersByQueryBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetCombinedSensorInstallersByQueryBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this get combined sensor installers by query bad request response has a 2xx status code
func (o *GetCombinedSensorInstallersByQueryBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined sensor installers by query bad request response has a 3xx status code
func (o *GetCombinedSensorInstallersByQueryBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined sensor installers by query bad request response has a 4xx status code
func (o *GetCombinedSensorInstallersByQueryBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined sensor installers by query bad request response has a 5xx status code
func (o *GetCombinedSensorInstallersByQueryBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined sensor installers by query bad request response a status code equal to that given
func (o *GetCombinedSensorInstallersByQueryBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get combined sensor installers by query bad request response
func (o *GetCombinedSensorInstallersByQueryBadRequest) Code() int {
	return 400
}

func (o *GetCombinedSensorInstallersByQueryBadRequest) Error() string {
	return fmt.Sprintf("[GET /sensors/combined/installers/v1][%d] getCombinedSensorInstallersByQueryBadRequest  %+v", 400, o.Payload)
}

func (o *GetCombinedSensorInstallersByQueryBadRequest) String() string {
	return fmt.Sprintf("[GET /sensors/combined/installers/v1][%d] getCombinedSensorInstallersByQueryBadRequest  %+v", 400, o.Payload)
}

func (o *GetCombinedSensorInstallersByQueryBadRequest) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *GetCombinedSensorInstallersByQueryBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedSensorInstallersByQueryForbidden creates a GetCombinedSensorInstallersByQueryForbidden with default headers values
func NewGetCombinedSensorInstallersByQueryForbidden() *GetCombinedSensorInstallersByQueryForbidden {
	return &GetCombinedSensorInstallersByQueryForbidden{}
}

/*
GetCombinedSensorInstallersByQueryForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetCombinedSensorInstallersByQueryForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get combined sensor installers by query forbidden response has a 2xx status code
func (o *GetCombinedSensorInstallersByQueryForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined sensor installers by query forbidden response has a 3xx status code
func (o *GetCombinedSensorInstallersByQueryForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined sensor installers by query forbidden response has a 4xx status code
func (o *GetCombinedSensorInstallersByQueryForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined sensor installers by query forbidden response has a 5xx status code
func (o *GetCombinedSensorInstallersByQueryForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined sensor installers by query forbidden response a status code equal to that given
func (o *GetCombinedSensorInstallersByQueryForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get combined sensor installers by query forbidden response
func (o *GetCombinedSensorInstallersByQueryForbidden) Code() int {
	return 403
}

func (o *GetCombinedSensorInstallersByQueryForbidden) Error() string {
	return fmt.Sprintf("[GET /sensors/combined/installers/v1][%d] getCombinedSensorInstallersByQueryForbidden  %+v", 403, o.Payload)
}

func (o *GetCombinedSensorInstallersByQueryForbidden) String() string {
	return fmt.Sprintf("[GET /sensors/combined/installers/v1][%d] getCombinedSensorInstallersByQueryForbidden  %+v", 403, o.Payload)
}

func (o *GetCombinedSensorInstallersByQueryForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCombinedSensorInstallersByQueryForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCombinedSensorInstallersByQueryTooManyRequests creates a GetCombinedSensorInstallersByQueryTooManyRequests with default headers values
func NewGetCombinedSensorInstallersByQueryTooManyRequests() *GetCombinedSensorInstallersByQueryTooManyRequests {
	return &GetCombinedSensorInstallersByQueryTooManyRequests{}
}

/*
GetCombinedSensorInstallersByQueryTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetCombinedSensorInstallersByQueryTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get combined sensor installers by query too many requests response has a 2xx status code
func (o *GetCombinedSensorInstallersByQueryTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get combined sensor installers by query too many requests response has a 3xx status code
func (o *GetCombinedSensorInstallersByQueryTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get combined sensor installers by query too many requests response has a 4xx status code
func (o *GetCombinedSensorInstallersByQueryTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get combined sensor installers by query too many requests response has a 5xx status code
func (o *GetCombinedSensorInstallersByQueryTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get combined sensor installers by query too many requests response a status code equal to that given
func (o *GetCombinedSensorInstallersByQueryTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get combined sensor installers by query too many requests response
func (o *GetCombinedSensorInstallersByQueryTooManyRequests) Code() int {
	return 429
}

func (o *GetCombinedSensorInstallersByQueryTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /sensors/combined/installers/v1][%d] getCombinedSensorInstallersByQueryTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCombinedSensorInstallersByQueryTooManyRequests) String() string {
	return fmt.Sprintf("[GET /sensors/combined/installers/v1][%d] getCombinedSensorInstallersByQueryTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetCombinedSensorInstallersByQueryTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetCombinedSensorInstallersByQueryTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
