// Code generated by go-swagger; DO NOT EDIT.

package sensor_download

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetSensorInstallersEntitiesReader is a Reader for the GetSensorInstallersEntities structure.
type GetSensorInstallersEntitiesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSensorInstallersEntitiesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSensorInstallersEntitiesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 207:
		result := NewGetSensorInstallersEntitiesMultiStatus()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetSensorInstallersEntitiesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetSensorInstallersEntitiesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetSensorInstallersEntitiesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetSensorInstallersEntitiesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /sensors/entities/installers/v1] GetSensorInstallersEntities", response, response.Code())
	}
}

// NewGetSensorInstallersEntitiesOK creates a GetSensorInstallersEntitiesOK with default headers values
func NewGetSensorInstallersEntitiesOK() *GetSensorInstallersEntitiesOK {
	return &GetSensorInstallersEntitiesOK{}
}

/*
GetSensorInstallersEntitiesOK describes a response with status code 200, with default header values.

OK
*/
type GetSensorInstallersEntitiesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainSensorInstallersV1
}

// IsSuccess returns true when this get sensor installers entities o k response has a 2xx status code
func (o *GetSensorInstallersEntitiesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get sensor installers entities o k response has a 3xx status code
func (o *GetSensorInstallersEntitiesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor installers entities o k response has a 4xx status code
func (o *GetSensorInstallersEntitiesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get sensor installers entities o k response has a 5xx status code
func (o *GetSensorInstallersEntitiesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor installers entities o k response a status code equal to that given
func (o *GetSensorInstallersEntitiesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get sensor installers entities o k response
func (o *GetSensorInstallersEntitiesOK) Code() int {
	return 200
}

func (o *GetSensorInstallersEntitiesOK) Error() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesOK  %+v", 200, o.Payload)
}

func (o *GetSensorInstallersEntitiesOK) String() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesOK  %+v", 200, o.Payload)
}

func (o *GetSensorInstallersEntitiesOK) GetPayload() *models.DomainSensorInstallersV1 {
	return o.Payload
}

func (o *GetSensorInstallersEntitiesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainSensorInstallersV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorInstallersEntitiesMultiStatus creates a GetSensorInstallersEntitiesMultiStatus with default headers values
func NewGetSensorInstallersEntitiesMultiStatus() *GetSensorInstallersEntitiesMultiStatus {
	return &GetSensorInstallersEntitiesMultiStatus{}
}

/*
GetSensorInstallersEntitiesMultiStatus describes a response with status code 207, with default header values.

Multi-Status
*/
type GetSensorInstallersEntitiesMultiStatus struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.DomainSensorInstallersV1
}

// IsSuccess returns true when this get sensor installers entities multi status response has a 2xx status code
func (o *GetSensorInstallersEntitiesMultiStatus) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get sensor installers entities multi status response has a 3xx status code
func (o *GetSensorInstallersEntitiesMultiStatus) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor installers entities multi status response has a 4xx status code
func (o *GetSensorInstallersEntitiesMultiStatus) IsClientError() bool {
	return false
}

// IsServerError returns true when this get sensor installers entities multi status response has a 5xx status code
func (o *GetSensorInstallersEntitiesMultiStatus) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor installers entities multi status response a status code equal to that given
func (o *GetSensorInstallersEntitiesMultiStatus) IsCode(code int) bool {
	return code == 207
}

// Code gets the status code for the get sensor installers entities multi status response
func (o *GetSensorInstallersEntitiesMultiStatus) Code() int {
	return 207
}

func (o *GetSensorInstallersEntitiesMultiStatus) Error() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesMultiStatus  %+v", 207, o.Payload)
}

func (o *GetSensorInstallersEntitiesMultiStatus) String() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesMultiStatus  %+v", 207, o.Payload)
}

func (o *GetSensorInstallersEntitiesMultiStatus) GetPayload() *models.DomainSensorInstallersV1 {
	return o.Payload
}

func (o *GetSensorInstallersEntitiesMultiStatus) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.DomainSensorInstallersV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorInstallersEntitiesBadRequest creates a GetSensorInstallersEntitiesBadRequest with default headers values
func NewGetSensorInstallersEntitiesBadRequest() *GetSensorInstallersEntitiesBadRequest {
	return &GetSensorInstallersEntitiesBadRequest{}
}

/*
GetSensorInstallersEntitiesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type GetSensorInstallersEntitiesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this get sensor installers entities bad request response has a 2xx status code
func (o *GetSensorInstallersEntitiesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor installers entities bad request response has a 3xx status code
func (o *GetSensorInstallersEntitiesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor installers entities bad request response has a 4xx status code
func (o *GetSensorInstallersEntitiesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor installers entities bad request response has a 5xx status code
func (o *GetSensorInstallersEntitiesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor installers entities bad request response a status code equal to that given
func (o *GetSensorInstallersEntitiesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get sensor installers entities bad request response
func (o *GetSensorInstallersEntitiesBadRequest) Code() int {
	return 400
}

func (o *GetSensorInstallersEntitiesBadRequest) Error() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesBadRequest  %+v", 400, o.Payload)
}

func (o *GetSensorInstallersEntitiesBadRequest) String() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesBadRequest  %+v", 400, o.Payload)
}

func (o *GetSensorInstallersEntitiesBadRequest) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *GetSensorInstallersEntitiesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorInstallersEntitiesForbidden creates a GetSensorInstallersEntitiesForbidden with default headers values
func NewGetSensorInstallersEntitiesForbidden() *GetSensorInstallersEntitiesForbidden {
	return &GetSensorInstallersEntitiesForbidden{}
}

/*
GetSensorInstallersEntitiesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetSensorInstallersEntitiesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sensor installers entities forbidden response has a 2xx status code
func (o *GetSensorInstallersEntitiesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor installers entities forbidden response has a 3xx status code
func (o *GetSensorInstallersEntitiesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor installers entities forbidden response has a 4xx status code
func (o *GetSensorInstallersEntitiesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor installers entities forbidden response has a 5xx status code
func (o *GetSensorInstallersEntitiesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor installers entities forbidden response a status code equal to that given
func (o *GetSensorInstallersEntitiesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get sensor installers entities forbidden response
func (o *GetSensorInstallersEntitiesForbidden) Code() int {
	return 403
}

func (o *GetSensorInstallersEntitiesForbidden) Error() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *GetSensorInstallersEntitiesForbidden) String() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesForbidden  %+v", 403, o.Payload)
}

func (o *GetSensorInstallersEntitiesForbidden) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSensorInstallersEntitiesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorInstallersEntitiesNotFound creates a GetSensorInstallersEntitiesNotFound with default headers values
func NewGetSensorInstallersEntitiesNotFound() *GetSensorInstallersEntitiesNotFound {
	return &GetSensorInstallersEntitiesNotFound{}
}

/*
GetSensorInstallersEntitiesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetSensorInstallersEntitiesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaspecQueryResponse
}

// IsSuccess returns true when this get sensor installers entities not found response has a 2xx status code
func (o *GetSensorInstallersEntitiesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor installers entities not found response has a 3xx status code
func (o *GetSensorInstallersEntitiesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor installers entities not found response has a 4xx status code
func (o *GetSensorInstallersEntitiesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor installers entities not found response has a 5xx status code
func (o *GetSensorInstallersEntitiesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor installers entities not found response a status code equal to that given
func (o *GetSensorInstallersEntitiesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get sensor installers entities not found response
func (o *GetSensorInstallersEntitiesNotFound) Code() int {
	return 404
}

func (o *GetSensorInstallersEntitiesNotFound) Error() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesNotFound  %+v", 404, o.Payload)
}

func (o *GetSensorInstallersEntitiesNotFound) String() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesNotFound  %+v", 404, o.Payload)
}

func (o *GetSensorInstallersEntitiesNotFound) GetPayload() *models.MsaspecQueryResponse {
	return o.Payload
}

func (o *GetSensorInstallersEntitiesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaspecQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorInstallersEntitiesTooManyRequests creates a GetSensorInstallersEntitiesTooManyRequests with default headers values
func NewGetSensorInstallersEntitiesTooManyRequests() *GetSensorInstallersEntitiesTooManyRequests {
	return &GetSensorInstallersEntitiesTooManyRequests{}
}

/*
GetSensorInstallersEntitiesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetSensorInstallersEntitiesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sensor installers entities too many requests response has a 2xx status code
func (o *GetSensorInstallersEntitiesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor installers entities too many requests response has a 3xx status code
func (o *GetSensorInstallersEntitiesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor installers entities too many requests response has a 4xx status code
func (o *GetSensorInstallersEntitiesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor installers entities too many requests response has a 5xx status code
func (o *GetSensorInstallersEntitiesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor installers entities too many requests response a status code equal to that given
func (o *GetSensorInstallersEntitiesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get sensor installers entities too many requests response
func (o *GetSensorInstallersEntitiesTooManyRequests) Code() int {
	return 429
}

func (o *GetSensorInstallersEntitiesTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetSensorInstallersEntitiesTooManyRequests) String() string {
	return fmt.Sprintf("[GET /sensors/entities/installers/v1][%d] getSensorInstallersEntitiesTooManyRequests  %+v", 429, o.Payload)
}

func (o *GetSensorInstallersEntitiesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSensorInstallersEntitiesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
