// Code generated by go-swagger; DO NOT EDIT.

package sensor_download

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new sensor download API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for sensor download API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	DownloadSensorInstallerByID(params *DownloadSensorInstallerByIDParams, writer io.Writer, opts ...ClientOption) (*DownloadSensorInstallerByIDOK, error)

	GetCombinedSensorInstallersByQuery(params *GetCombinedSensorInstallersByQueryParams, opts ...ClientOption) (*GetCombinedSensorInstallersByQueryOK, error)

	GetSensorInstallersByQuery(params *GetSensorInstallersByQueryParams, opts ...ClientOption) (*GetSensorInstallersByQueryOK, error)

	GetSensorInstallersCCIDByQuery(params *GetSensorInstallersCCIDByQueryParams, opts ...ClientOption) (*GetSensorInstallersCCIDByQueryOK, error)

	GetSensorInstallersEntities(params *GetSensorInstallersEntitiesParams, opts ...ClientOption) (*GetSensorInstallersEntitiesOK, *GetSensorInstallersEntitiesMultiStatus, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
DownloadSensorInstallerByID downloads sensor installer by s h a256 ID
*/
func (a *Client) DownloadSensorInstallerByID(params *DownloadSensorInstallerByIDParams, writer io.Writer, opts ...ClientOption) (*DownloadSensorInstallerByIDOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDownloadSensorInstallerByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DownloadSensorInstallerById",
		Method:             "GET",
		PathPattern:        "/sensors/entities/download-installer/v1",
		ProducesMediaTypes: []string{"application/json", "application/octet-stream"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DownloadSensorInstallerByIDReader{formats: a.formats, writer: writer},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DownloadSensorInstallerByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for DownloadSensorInstallerById: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetCombinedSensorInstallersByQuery gets sensor installer details by provided query
*/
func (a *Client) GetCombinedSensorInstallersByQuery(params *GetCombinedSensorInstallersByQueryParams, opts ...ClientOption) (*GetCombinedSensorInstallersByQueryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetCombinedSensorInstallersByQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetCombinedSensorInstallersByQuery",
		Method:             "GET",
		PathPattern:        "/sensors/combined/installers/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetCombinedSensorInstallersByQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetCombinedSensorInstallersByQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetCombinedSensorInstallersByQuery: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSensorInstallersByQuery gets sensor installer i ds by provided query
*/
func (a *Client) GetSensorInstallersByQuery(params *GetSensorInstallersByQueryParams, opts ...ClientOption) (*GetSensorInstallersByQueryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSensorInstallersByQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSensorInstallersByQuery",
		Method:             "GET",
		PathPattern:        "/sensors/queries/installers/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetSensorInstallersByQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSensorInstallersByQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetSensorInstallersByQuery: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSensorInstallersCCIDByQuery gets c c ID to use with sensor installers
*/
func (a *Client) GetSensorInstallersCCIDByQuery(params *GetSensorInstallersCCIDByQueryParams, opts ...ClientOption) (*GetSensorInstallersCCIDByQueryOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSensorInstallersCCIDByQueryParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSensorInstallersCCIDByQuery",
		Method:             "GET",
		PathPattern:        "/sensors/queries/installers/ccid/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetSensorInstallersCCIDByQueryReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSensorInstallersCCIDByQueryOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for GetSensorInstallersCCIDByQuery: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSensorInstallersEntities gets sensor installer details by provided s h a256 i ds
*/
func (a *Client) GetSensorInstallersEntities(params *GetSensorInstallersEntitiesParams, opts ...ClientOption) (*GetSensorInstallersEntitiesOK, *GetSensorInstallersEntitiesMultiStatus, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSensorInstallersEntitiesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSensorInstallersEntities",
		Method:             "GET",
		PathPattern:        "/sensors/entities/installers/v1",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GetSensorInstallersEntitiesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GetSensorInstallersEntitiesOK:
		return value, nil, nil
	case *GetSensorInstallersEntitiesMultiStatus:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for sensor_download: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
