// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// GetSensorUpdatePoliciesV2Reader is a Reader for the GetSensorUpdatePoliciesV2 structure.
type GetSensorUpdatePoliciesV2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSensorUpdatePoliciesV2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSensorUpdatePoliciesV2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetSensorUpdatePoliciesV2Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetSensorUpdatePoliciesV2NotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewGetSensorUpdatePoliciesV2TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetSensorUpdatePoliciesV2InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/entities/sensor-update/v2] getSensorUpdatePoliciesV2", response, response.Code())
	}
}

// NewGetSensorUpdatePoliciesV2OK creates a GetSensorUpdatePoliciesV2OK with default headers values
func NewGetSensorUpdatePoliciesV2OK() *GetSensorUpdatePoliciesV2OK {
	return &GetSensorUpdatePoliciesV2OK{}
}

/*
GetSensorUpdatePoliciesV2OK describes a response with status code 200, with default header values.

OK
*/
type GetSensorUpdatePoliciesV2OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV2
}

// IsSuccess returns true when this get sensor update policies v2 o k response has a 2xx status code
func (o *GetSensorUpdatePoliciesV2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get sensor update policies v2 o k response has a 3xx status code
func (o *GetSensorUpdatePoliciesV2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor update policies v2 o k response has a 4xx status code
func (o *GetSensorUpdatePoliciesV2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get sensor update policies v2 o k response has a 5xx status code
func (o *GetSensorUpdatePoliciesV2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor update policies v2 o k response a status code equal to that given
func (o *GetSensorUpdatePoliciesV2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get sensor update policies v2 o k response
func (o *GetSensorUpdatePoliciesV2OK) Code() int {
	return 200
}

func (o *GetSensorUpdatePoliciesV2OK) Error() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2OK  %+v", 200, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2OK) String() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2OK  %+v", 200, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2OK) GetPayload() *models.SensorUpdateRespV2 {
	return o.Payload
}

func (o *GetSensorUpdatePoliciesV2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorUpdatePoliciesV2Forbidden creates a GetSensorUpdatePoliciesV2Forbidden with default headers values
func NewGetSensorUpdatePoliciesV2Forbidden() *GetSensorUpdatePoliciesV2Forbidden {
	return &GetSensorUpdatePoliciesV2Forbidden{}
}

/*
GetSensorUpdatePoliciesV2Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type GetSensorUpdatePoliciesV2Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this get sensor update policies v2 forbidden response has a 2xx status code
func (o *GetSensorUpdatePoliciesV2Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor update policies v2 forbidden response has a 3xx status code
func (o *GetSensorUpdatePoliciesV2Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor update policies v2 forbidden response has a 4xx status code
func (o *GetSensorUpdatePoliciesV2Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor update policies v2 forbidden response has a 5xx status code
func (o *GetSensorUpdatePoliciesV2Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor update policies v2 forbidden response a status code equal to that given
func (o *GetSensorUpdatePoliciesV2Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get sensor update policies v2 forbidden response
func (o *GetSensorUpdatePoliciesV2Forbidden) Code() int {
	return 403
}

func (o *GetSensorUpdatePoliciesV2Forbidden) Error() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2Forbidden  %+v", 403, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2Forbidden) String() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2Forbidden  %+v", 403, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2Forbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *GetSensorUpdatePoliciesV2Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorUpdatePoliciesV2NotFound creates a GetSensorUpdatePoliciesV2NotFound with default headers values
func NewGetSensorUpdatePoliciesV2NotFound() *GetSensorUpdatePoliciesV2NotFound {
	return &GetSensorUpdatePoliciesV2NotFound{}
}

/*
GetSensorUpdatePoliciesV2NotFound describes a response with status code 404, with default header values.

Not Found
*/
type GetSensorUpdatePoliciesV2NotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV2
}

// IsSuccess returns true when this get sensor update policies v2 not found response has a 2xx status code
func (o *GetSensorUpdatePoliciesV2NotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor update policies v2 not found response has a 3xx status code
func (o *GetSensorUpdatePoliciesV2NotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor update policies v2 not found response has a 4xx status code
func (o *GetSensorUpdatePoliciesV2NotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor update policies v2 not found response has a 5xx status code
func (o *GetSensorUpdatePoliciesV2NotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor update policies v2 not found response a status code equal to that given
func (o *GetSensorUpdatePoliciesV2NotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get sensor update policies v2 not found response
func (o *GetSensorUpdatePoliciesV2NotFound) Code() int {
	return 404
}

func (o *GetSensorUpdatePoliciesV2NotFound) Error() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2NotFound  %+v", 404, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2NotFound) String() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2NotFound  %+v", 404, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2NotFound) GetPayload() *models.SensorUpdateRespV2 {
	return o.Payload
}

func (o *GetSensorUpdatePoliciesV2NotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorUpdatePoliciesV2TooManyRequests creates a GetSensorUpdatePoliciesV2TooManyRequests with default headers values
func NewGetSensorUpdatePoliciesV2TooManyRequests() *GetSensorUpdatePoliciesV2TooManyRequests {
	return &GetSensorUpdatePoliciesV2TooManyRequests{}
}

/*
GetSensorUpdatePoliciesV2TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type GetSensorUpdatePoliciesV2TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this get sensor update policies v2 too many requests response has a 2xx status code
func (o *GetSensorUpdatePoliciesV2TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor update policies v2 too many requests response has a 3xx status code
func (o *GetSensorUpdatePoliciesV2TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor update policies v2 too many requests response has a 4xx status code
func (o *GetSensorUpdatePoliciesV2TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this get sensor update policies v2 too many requests response has a 5xx status code
func (o *GetSensorUpdatePoliciesV2TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this get sensor update policies v2 too many requests response a status code equal to that given
func (o *GetSensorUpdatePoliciesV2TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the get sensor update policies v2 too many requests response
func (o *GetSensorUpdatePoliciesV2TooManyRequests) Code() int {
	return 429
}

func (o *GetSensorUpdatePoliciesV2TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2TooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *GetSensorUpdatePoliciesV2TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSensorUpdatePoliciesV2InternalServerError creates a GetSensorUpdatePoliciesV2InternalServerError with default headers values
func NewGetSensorUpdatePoliciesV2InternalServerError() *GetSensorUpdatePoliciesV2InternalServerError {
	return &GetSensorUpdatePoliciesV2InternalServerError{}
}

/*
GetSensorUpdatePoliciesV2InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type GetSensorUpdatePoliciesV2InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV2
}

// IsSuccess returns true when this get sensor update policies v2 internal server error response has a 2xx status code
func (o *GetSensorUpdatePoliciesV2InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get sensor update policies v2 internal server error response has a 3xx status code
func (o *GetSensorUpdatePoliciesV2InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get sensor update policies v2 internal server error response has a 4xx status code
func (o *GetSensorUpdatePoliciesV2InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get sensor update policies v2 internal server error response has a 5xx status code
func (o *GetSensorUpdatePoliciesV2InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get sensor update policies v2 internal server error response a status code equal to that given
func (o *GetSensorUpdatePoliciesV2InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get sensor update policies v2 internal server error response
func (o *GetSensorUpdatePoliciesV2InternalServerError) Code() int {
	return 500
}

func (o *GetSensorUpdatePoliciesV2InternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2InternalServerError  %+v", 500, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2InternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/entities/sensor-update/v2][%d] getSensorUpdatePoliciesV2InternalServerError  %+v", 500, o.Payload)
}

func (o *GetSensorUpdatePoliciesV2InternalServerError) GetPayload() *models.SensorUpdateRespV2 {
	return o.Payload
}

func (o *GetSensorUpdatePoliciesV2InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
