// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// NewPerformSensorUpdatePoliciesActionParams creates a new PerformSensorUpdatePoliciesActionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPerformSensorUpdatePoliciesActionParams() *PerformSensorUpdatePoliciesActionParams {
	return &PerformSensorUpdatePoliciesActionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPerformSensorUpdatePoliciesActionParamsWithTimeout creates a new PerformSensorUpdatePoliciesActionParams object
// with the ability to set a timeout on a request.
func NewPerformSensorUpdatePoliciesActionParamsWithTimeout(timeout time.Duration) *PerformSensorUpdatePoliciesActionParams {
	return &PerformSensorUpdatePoliciesActionParams{
		timeout: timeout,
	}
}

// NewPerformSensorUpdatePoliciesActionParamsWithContext creates a new PerformSensorUpdatePoliciesActionParams object
// with the ability to set a context for a request.
func NewPerformSensorUpdatePoliciesActionParamsWithContext(ctx context.Context) *PerformSensorUpdatePoliciesActionParams {
	return &PerformSensorUpdatePoliciesActionParams{
		Context: ctx,
	}
}

// NewPerformSensorUpdatePoliciesActionParamsWithHTTPClient creates a new PerformSensorUpdatePoliciesActionParams object
// with the ability to set a custom HTTPClient for a request.
func NewPerformSensorUpdatePoliciesActionParamsWithHTTPClient(client *http.Client) *PerformSensorUpdatePoliciesActionParams {
	return &PerformSensorUpdatePoliciesActionParams{
		HTTPClient: client,
	}
}

/*
PerformSensorUpdatePoliciesActionParams contains all the parameters to send to the API endpoint

	for the perform sensor update policies action operation.

	Typically these are written to a http.Request.
*/
type PerformSensorUpdatePoliciesActionParams struct {

	/* ActionName.

	   The action to perform
	*/
	ActionName string

	// Body.
	Body *models.MsaEntityActionRequestV2

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the perform sensor update policies action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformSensorUpdatePoliciesActionParams) WithDefaults() *PerformSensorUpdatePoliciesActionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the perform sensor update policies action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformSensorUpdatePoliciesActionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) WithTimeout(timeout time.Duration) *PerformSensorUpdatePoliciesActionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) WithContext(ctx context.Context) *PerformSensorUpdatePoliciesActionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) WithHTTPClient(client *http.Client) *PerformSensorUpdatePoliciesActionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionName adds the actionName to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) WithActionName(actionName string) *PerformSensorUpdatePoliciesActionParams {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) SetActionName(actionName string) {
	o.ActionName = actionName
}

// WithBody adds the body to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) WithBody(body *models.MsaEntityActionRequestV2) *PerformSensorUpdatePoliciesActionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the perform sensor update policies action params
func (o *PerformSensorUpdatePoliciesActionParams) SetBody(body *models.MsaEntityActionRequestV2) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PerformSensorUpdatePoliciesActionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param action_name
	qrActionName := o.ActionName
	qActionName := qrActionName
	if qActionName != "" {

		if err := r.SetQueryParam("action_name", qActionName); err != nil {
			return err
		}
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
