// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCombinedSensorUpdateBuildsReader is a Reader for the QueryCombinedSensorUpdateBuilds structure.
type QueryCombinedSensorUpdateBuildsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCombinedSensorUpdateBuildsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCombinedSensorUpdateBuildsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryCombinedSensorUpdateBuildsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryCombinedSensorUpdateBuildsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCombinedSensorUpdateBuildsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryCombinedSensorUpdateBuildsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		result := NewQueryCombinedSensorUpdateBuildsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQueryCombinedSensorUpdateBuildsOK creates a QueryCombinedSensorUpdateBuildsOK with default headers values
func NewQueryCombinedSensorUpdateBuildsOK() *QueryCombinedSensorUpdateBuildsOK {
	return &QueryCombinedSensorUpdateBuildsOK{}
}

/*
QueryCombinedSensorUpdateBuildsOK describes a response with status code 200, with default header values.

OK
*/
type QueryCombinedSensorUpdateBuildsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateBuildsRespV1
}

// IsSuccess returns true when this query combined sensor update builds o k response has a 2xx status code
func (o *QueryCombinedSensorUpdateBuildsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query combined sensor update builds o k response has a 3xx status code
func (o *QueryCombinedSensorUpdateBuildsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update builds o k response has a 4xx status code
func (o *QueryCombinedSensorUpdateBuildsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined sensor update builds o k response has a 5xx status code
func (o *QueryCombinedSensorUpdateBuildsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update builds o k response a status code equal to that given
func (o *QueryCombinedSensorUpdateBuildsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query combined sensor update builds o k response
func (o *QueryCombinedSensorUpdateBuildsOK) Code() int {
	return 200
}

func (o *QueryCombinedSensorUpdateBuildsOK) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsOK) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsOK) GetPayload() *models.SensorUpdateBuildsRespV1 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateBuildsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateBuildsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateBuildsBadRequest creates a QueryCombinedSensorUpdateBuildsBadRequest with default headers values
func NewQueryCombinedSensorUpdateBuildsBadRequest() *QueryCombinedSensorUpdateBuildsBadRequest {
	return &QueryCombinedSensorUpdateBuildsBadRequest{}
}

/*
QueryCombinedSensorUpdateBuildsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryCombinedSensorUpdateBuildsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateBuildsRespV1
}

// IsSuccess returns true when this query combined sensor update builds bad request response has a 2xx status code
func (o *QueryCombinedSensorUpdateBuildsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update builds bad request response has a 3xx status code
func (o *QueryCombinedSensorUpdateBuildsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update builds bad request response has a 4xx status code
func (o *QueryCombinedSensorUpdateBuildsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update builds bad request response has a 5xx status code
func (o *QueryCombinedSensorUpdateBuildsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update builds bad request response a status code equal to that given
func (o *QueryCombinedSensorUpdateBuildsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query combined sensor update builds bad request response
func (o *QueryCombinedSensorUpdateBuildsBadRequest) Code() int {
	return 400
}

func (o *QueryCombinedSensorUpdateBuildsBadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsBadRequest) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsBadRequest) GetPayload() *models.SensorUpdateBuildsRespV1 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateBuildsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateBuildsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateBuildsForbidden creates a QueryCombinedSensorUpdateBuildsForbidden with default headers values
func NewQueryCombinedSensorUpdateBuildsForbidden() *QueryCombinedSensorUpdateBuildsForbidden {
	return &QueryCombinedSensorUpdateBuildsForbidden{}
}

/*
QueryCombinedSensorUpdateBuildsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCombinedSensorUpdateBuildsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query combined sensor update builds forbidden response has a 2xx status code
func (o *QueryCombinedSensorUpdateBuildsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update builds forbidden response has a 3xx status code
func (o *QueryCombinedSensorUpdateBuildsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update builds forbidden response has a 4xx status code
func (o *QueryCombinedSensorUpdateBuildsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update builds forbidden response has a 5xx status code
func (o *QueryCombinedSensorUpdateBuildsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update builds forbidden response a status code equal to that given
func (o *QueryCombinedSensorUpdateBuildsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query combined sensor update builds forbidden response
func (o *QueryCombinedSensorUpdateBuildsForbidden) Code() int {
	return 403
}

func (o *QueryCombinedSensorUpdateBuildsForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsForbidden) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateBuildsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateBuildsTooManyRequests creates a QueryCombinedSensorUpdateBuildsTooManyRequests with default headers values
func NewQueryCombinedSensorUpdateBuildsTooManyRequests() *QueryCombinedSensorUpdateBuildsTooManyRequests {
	return &QueryCombinedSensorUpdateBuildsTooManyRequests{}
}

/*
QueryCombinedSensorUpdateBuildsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCombinedSensorUpdateBuildsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query combined sensor update builds too many requests response has a 2xx status code
func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update builds too many requests response has a 3xx status code
func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update builds too many requests response has a 4xx status code
func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update builds too many requests response has a 5xx status code
func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update builds too many requests response a status code equal to that given
func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query combined sensor update builds too many requests response
func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) Code() int {
	return 429
}

func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateBuildsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateBuildsInternalServerError creates a QueryCombinedSensorUpdateBuildsInternalServerError with default headers values
func NewQueryCombinedSensorUpdateBuildsInternalServerError() *QueryCombinedSensorUpdateBuildsInternalServerError {
	return &QueryCombinedSensorUpdateBuildsInternalServerError{}
}

/*
QueryCombinedSensorUpdateBuildsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryCombinedSensorUpdateBuildsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateBuildsRespV1
}

// IsSuccess returns true when this query combined sensor update builds internal server error response has a 2xx status code
func (o *QueryCombinedSensorUpdateBuildsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update builds internal server error response has a 3xx status code
func (o *QueryCombinedSensorUpdateBuildsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update builds internal server error response has a 4xx status code
func (o *QueryCombinedSensorUpdateBuildsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined sensor update builds internal server error response has a 5xx status code
func (o *QueryCombinedSensorUpdateBuildsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query combined sensor update builds internal server error response a status code equal to that given
func (o *QueryCombinedSensorUpdateBuildsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query combined sensor update builds internal server error response
func (o *QueryCombinedSensorUpdateBuildsInternalServerError) Code() int {
	return 500
}

func (o *QueryCombinedSensorUpdateBuildsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuildsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsInternalServerError) GetPayload() *models.SensorUpdateBuildsRespV1 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateBuildsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateBuildsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateBuildsDefault creates a QueryCombinedSensorUpdateBuildsDefault with default headers values
func NewQueryCombinedSensorUpdateBuildsDefault(code int) *QueryCombinedSensorUpdateBuildsDefault {
	return &QueryCombinedSensorUpdateBuildsDefault{
		_statusCode: code,
	}
}

/*
QueryCombinedSensorUpdateBuildsDefault describes a response with status code -1, with default header values.

default
*/
type QueryCombinedSensorUpdateBuildsDefault struct {
	_statusCode int

	Payload string
}

// IsSuccess returns true when this query combined sensor update builds default response has a 2xx status code
func (o *QueryCombinedSensorUpdateBuildsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this query combined sensor update builds default response has a 3xx status code
func (o *QueryCombinedSensorUpdateBuildsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this query combined sensor update builds default response has a 4xx status code
func (o *QueryCombinedSensorUpdateBuildsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this query combined sensor update builds default response has a 5xx status code
func (o *QueryCombinedSensorUpdateBuildsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this query combined sensor update builds default response a status code equal to that given
func (o *QueryCombinedSensorUpdateBuildsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the query combined sensor update builds default response
func (o *QueryCombinedSensorUpdateBuildsDefault) Code() int {
	return o._statusCode
}

func (o *QueryCombinedSensorUpdateBuildsDefault) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuilds default  %+v", o._statusCode, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsDefault) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-builds/v1][%d] queryCombinedSensorUpdateBuilds default  %+v", o._statusCode, o.Payload)
}

func (o *QueryCombinedSensorUpdateBuildsDefault) GetPayload() string {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateBuildsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
