// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQueryCombinedSensorUpdateKernelsParams creates a new QueryCombinedSensorUpdateKernelsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQueryCombinedSensorUpdateKernelsParams() *QueryCombinedSensorUpdateKernelsParams {
	return &QueryCombinedSensorUpdateKernelsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQueryCombinedSensorUpdateKernelsParamsWithTimeout creates a new QueryCombinedSensorUpdateKernelsParams object
// with the ability to set a timeout on a request.
func NewQueryCombinedSensorUpdateKernelsParamsWithTimeout(timeout time.Duration) *QueryCombinedSensorUpdateKernelsParams {
	return &QueryCombinedSensorUpdateKernelsParams{
		timeout: timeout,
	}
}

// NewQueryCombinedSensorUpdateKernelsParamsWithContext creates a new QueryCombinedSensorUpdateKernelsParams object
// with the ability to set a context for a request.
func NewQueryCombinedSensorUpdateKernelsParamsWithContext(ctx context.Context) *QueryCombinedSensorUpdateKernelsParams {
	return &QueryCombinedSensorUpdateKernelsParams{
		Context: ctx,
	}
}

// NewQueryCombinedSensorUpdateKernelsParamsWithHTTPClient creates a new QueryCombinedSensorUpdateKernelsParams object
// with the ability to set a custom HTTPClient for a request.
func NewQueryCombinedSensorUpdateKernelsParamsWithHTTPClient(client *http.Client) *QueryCombinedSensorUpdateKernelsParams {
	return &QueryCombinedSensorUpdateKernelsParams{
		HTTPClient: client,
	}
}

/*
QueryCombinedSensorUpdateKernelsParams contains all the parameters to send to the API endpoint

	for the query combined sensor update kernels operation.

	Typically these are written to a http.Request.
*/
type QueryCombinedSensorUpdateKernelsParams struct {

	/* Filter.

	   The filter expression that should be used to limit the results
	*/
	Filter *string

	/* Limit.

	   The maximum records to return. [1-500]
	*/
	Limit *int64

	/* Offset.

	   The offset to start retrieving records from
	*/
	Offset *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the query combined sensor update kernels params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryCombinedSensorUpdateKernelsParams) WithDefaults() *QueryCombinedSensorUpdateKernelsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the query combined sensor update kernels params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QueryCombinedSensorUpdateKernelsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) WithTimeout(timeout time.Duration) *QueryCombinedSensorUpdateKernelsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) WithContext(ctx context.Context) *QueryCombinedSensorUpdateKernelsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) WithHTTPClient(client *http.Client) *QueryCombinedSensorUpdateKernelsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFilter adds the filter to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) WithFilter(filter *string) *QueryCombinedSensorUpdateKernelsParams {
	o.SetFilter(filter)
	return o
}

// SetFilter adds the filter to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) SetFilter(filter *string) {
	o.Filter = filter
}

// WithLimit adds the limit to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) WithLimit(limit *int64) *QueryCombinedSensorUpdateKernelsParams {
	o.SetLimit(limit)
	return o
}

// SetLimit adds the limit to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) SetLimit(limit *int64) {
	o.Limit = limit
}

// WithOffset adds the offset to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) WithOffset(offset *int64) *QueryCombinedSensorUpdateKernelsParams {
	o.SetOffset(offset)
	return o
}

// SetOffset adds the offset to the query combined sensor update kernels params
func (o *QueryCombinedSensorUpdateKernelsParams) SetOffset(offset *int64) {
	o.Offset = offset
}

// WriteToRequest writes these params to a swagger request
func (o *QueryCombinedSensorUpdateKernelsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Filter != nil {

		// query param filter
		var qrFilter string

		if o.Filter != nil {
			qrFilter = *o.Filter
		}
		qFilter := qrFilter
		if qFilter != "" {

			if err := r.SetQueryParam("filter", qFilter); err != nil {
				return err
			}
		}
	}

	if o.Limit != nil {

		// query param limit
		var qrLimit int64

		if o.Limit != nil {
			qrLimit = *o.Limit
		}
		qLimit := swag.FormatInt64(qrLimit)
		if qLimit != "" {

			if err := r.SetQueryParam("limit", qLimit); err != nil {
				return err
			}
		}
	}

	if o.Offset != nil {

		// query param offset
		var qrOffset int64

		if o.Offset != nil {
			qrOffset = *o.Offset
		}
		qOffset := swag.FormatInt64(qrOffset)
		if qOffset != "" {

			if err := r.SetQueryParam("offset", qOffset); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
