// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCombinedSensorUpdateKernelsReader is a Reader for the QueryCombinedSensorUpdateKernels structure.
type QueryCombinedSensorUpdateKernelsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCombinedSensorUpdateKernelsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCombinedSensorUpdateKernelsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryCombinedSensorUpdateKernelsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryCombinedSensorUpdateKernelsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCombinedSensorUpdateKernelsTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryCombinedSensorUpdateKernelsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/combined/sensor-update-kernels/v1] queryCombinedSensorUpdateKernels", response, response.Code())
	}
}

// NewQueryCombinedSensorUpdateKernelsOK creates a QueryCombinedSensorUpdateKernelsOK with default headers values
func NewQueryCombinedSensorUpdateKernelsOK() *QueryCombinedSensorUpdateKernelsOK {
	return &QueryCombinedSensorUpdateKernelsOK{}
}

/*
QueryCombinedSensorUpdateKernelsOK describes a response with status code 200, with default header values.

OK
*/
type QueryCombinedSensorUpdateKernelsOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateKernelsRespV1
}

// IsSuccess returns true when this query combined sensor update kernels o k response has a 2xx status code
func (o *QueryCombinedSensorUpdateKernelsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query combined sensor update kernels o k response has a 3xx status code
func (o *QueryCombinedSensorUpdateKernelsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update kernels o k response has a 4xx status code
func (o *QueryCombinedSensorUpdateKernelsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined sensor update kernels o k response has a 5xx status code
func (o *QueryCombinedSensorUpdateKernelsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update kernels o k response a status code equal to that given
func (o *QueryCombinedSensorUpdateKernelsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query combined sensor update kernels o k response
func (o *QueryCombinedSensorUpdateKernelsOK) Code() int {
	return 200
}

func (o *QueryCombinedSensorUpdateKernelsOK) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsOK) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsOK  %+v", 200, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsOK) GetPayload() *models.SensorUpdateKernelsRespV1 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateKernelsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateKernelsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateKernelsBadRequest creates a QueryCombinedSensorUpdateKernelsBadRequest with default headers values
func NewQueryCombinedSensorUpdateKernelsBadRequest() *QueryCombinedSensorUpdateKernelsBadRequest {
	return &QueryCombinedSensorUpdateKernelsBadRequest{}
}

/*
QueryCombinedSensorUpdateKernelsBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryCombinedSensorUpdateKernelsBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateKernelsRespV1
}

// IsSuccess returns true when this query combined sensor update kernels bad request response has a 2xx status code
func (o *QueryCombinedSensorUpdateKernelsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update kernels bad request response has a 3xx status code
func (o *QueryCombinedSensorUpdateKernelsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update kernels bad request response has a 4xx status code
func (o *QueryCombinedSensorUpdateKernelsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update kernels bad request response has a 5xx status code
func (o *QueryCombinedSensorUpdateKernelsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update kernels bad request response a status code equal to that given
func (o *QueryCombinedSensorUpdateKernelsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query combined sensor update kernels bad request response
func (o *QueryCombinedSensorUpdateKernelsBadRequest) Code() int {
	return 400
}

func (o *QueryCombinedSensorUpdateKernelsBadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsBadRequest) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsBadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsBadRequest) GetPayload() *models.SensorUpdateKernelsRespV1 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateKernelsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateKernelsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateKernelsForbidden creates a QueryCombinedSensorUpdateKernelsForbidden with default headers values
func NewQueryCombinedSensorUpdateKernelsForbidden() *QueryCombinedSensorUpdateKernelsForbidden {
	return &QueryCombinedSensorUpdateKernelsForbidden{}
}

/*
QueryCombinedSensorUpdateKernelsForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCombinedSensorUpdateKernelsForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query combined sensor update kernels forbidden response has a 2xx status code
func (o *QueryCombinedSensorUpdateKernelsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update kernels forbidden response has a 3xx status code
func (o *QueryCombinedSensorUpdateKernelsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update kernels forbidden response has a 4xx status code
func (o *QueryCombinedSensorUpdateKernelsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update kernels forbidden response has a 5xx status code
func (o *QueryCombinedSensorUpdateKernelsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update kernels forbidden response a status code equal to that given
func (o *QueryCombinedSensorUpdateKernelsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query combined sensor update kernels forbidden response
func (o *QueryCombinedSensorUpdateKernelsForbidden) Code() int {
	return 403
}

func (o *QueryCombinedSensorUpdateKernelsForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsForbidden) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsForbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateKernelsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateKernelsTooManyRequests creates a QueryCombinedSensorUpdateKernelsTooManyRequests with default headers values
func NewQueryCombinedSensorUpdateKernelsTooManyRequests() *QueryCombinedSensorUpdateKernelsTooManyRequests {
	return &QueryCombinedSensorUpdateKernelsTooManyRequests{}
}

/*
QueryCombinedSensorUpdateKernelsTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCombinedSensorUpdateKernelsTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query combined sensor update kernels too many requests response has a 2xx status code
func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update kernels too many requests response has a 3xx status code
func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update kernels too many requests response has a 4xx status code
func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update kernels too many requests response has a 5xx status code
func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update kernels too many requests response a status code equal to that given
func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query combined sensor update kernels too many requests response
func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) Code() int {
	return 429
}

func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsTooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateKernelsTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdateKernelsInternalServerError creates a QueryCombinedSensorUpdateKernelsInternalServerError with default headers values
func NewQueryCombinedSensorUpdateKernelsInternalServerError() *QueryCombinedSensorUpdateKernelsInternalServerError {
	return &QueryCombinedSensorUpdateKernelsInternalServerError{}
}

/*
QueryCombinedSensorUpdateKernelsInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryCombinedSensorUpdateKernelsInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateKernelsRespV1
}

// IsSuccess returns true when this query combined sensor update kernels internal server error response has a 2xx status code
func (o *QueryCombinedSensorUpdateKernelsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update kernels internal server error response has a 3xx status code
func (o *QueryCombinedSensorUpdateKernelsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update kernels internal server error response has a 4xx status code
func (o *QueryCombinedSensorUpdateKernelsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined sensor update kernels internal server error response has a 5xx status code
func (o *QueryCombinedSensorUpdateKernelsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query combined sensor update kernels internal server error response a status code equal to that given
func (o *QueryCombinedSensorUpdateKernelsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query combined sensor update kernels internal server error response
func (o *QueryCombinedSensorUpdateKernelsInternalServerError) Code() int {
	return 500
}

func (o *QueryCombinedSensorUpdateKernelsInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update-kernels/v1][%d] queryCombinedSensorUpdateKernelsInternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedSensorUpdateKernelsInternalServerError) GetPayload() *models.SensorUpdateKernelsRespV1 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdateKernelsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateKernelsRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
