// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QueryCombinedSensorUpdatePoliciesV2Reader is a Reader for the QueryCombinedSensorUpdatePoliciesV2 structure.
type QueryCombinedSensorUpdatePoliciesV2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QueryCombinedSensorUpdatePoliciesV2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQueryCombinedSensorUpdatePoliciesV2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQueryCombinedSensorUpdatePoliciesV2BadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQueryCombinedSensorUpdatePoliciesV2Forbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQueryCombinedSensorUpdatePoliciesV2TooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQueryCombinedSensorUpdatePoliciesV2InternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/combined/sensor-update/v2] queryCombinedSensorUpdatePoliciesV2", response, response.Code())
	}
}

// NewQueryCombinedSensorUpdatePoliciesV2OK creates a QueryCombinedSensorUpdatePoliciesV2OK with default headers values
func NewQueryCombinedSensorUpdatePoliciesV2OK() *QueryCombinedSensorUpdatePoliciesV2OK {
	return &QueryCombinedSensorUpdatePoliciesV2OK{}
}

/*
QueryCombinedSensorUpdatePoliciesV2OK describes a response with status code 200, with default header values.

OK
*/
type QueryCombinedSensorUpdatePoliciesV2OK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV2
}

// IsSuccess returns true when this query combined sensor update policies v2 o k response has a 2xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query combined sensor update policies v2 o k response has a 3xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update policies v2 o k response has a 4xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined sensor update policies v2 o k response has a 5xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update policies v2 o k response a status code equal to that given
func (o *QueryCombinedSensorUpdatePoliciesV2OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query combined sensor update policies v2 o k response
func (o *QueryCombinedSensorUpdatePoliciesV2OK) Code() int {
	return 200
}

func (o *QueryCombinedSensorUpdatePoliciesV2OK) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2OK  %+v", 200, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2OK) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2OK  %+v", 200, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2OK) GetPayload() *models.SensorUpdateRespV2 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdatePoliciesV2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdatePoliciesV2BadRequest creates a QueryCombinedSensorUpdatePoliciesV2BadRequest with default headers values
func NewQueryCombinedSensorUpdatePoliciesV2BadRequest() *QueryCombinedSensorUpdatePoliciesV2BadRequest {
	return &QueryCombinedSensorUpdatePoliciesV2BadRequest{}
}

/*
QueryCombinedSensorUpdatePoliciesV2BadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QueryCombinedSensorUpdatePoliciesV2BadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV2
}

// IsSuccess returns true when this query combined sensor update policies v2 bad request response has a 2xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update policies v2 bad request response has a 3xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update policies v2 bad request response has a 4xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update policies v2 bad request response has a 5xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update policies v2 bad request response a status code equal to that given
func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query combined sensor update policies v2 bad request response
func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) Code() int {
	return 400
}

func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2BadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2BadRequest  %+v", 400, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) GetPayload() *models.SensorUpdateRespV2 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdatePoliciesV2BadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdatePoliciesV2Forbidden creates a QueryCombinedSensorUpdatePoliciesV2Forbidden with default headers values
func NewQueryCombinedSensorUpdatePoliciesV2Forbidden() *QueryCombinedSensorUpdatePoliciesV2Forbidden {
	return &QueryCombinedSensorUpdatePoliciesV2Forbidden{}
}

/*
QueryCombinedSensorUpdatePoliciesV2Forbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QueryCombinedSensorUpdatePoliciesV2Forbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query combined sensor update policies v2 forbidden response has a 2xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update policies v2 forbidden response has a 3xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update policies v2 forbidden response has a 4xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update policies v2 forbidden response has a 5xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update policies v2 forbidden response a status code equal to that given
func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query combined sensor update policies v2 forbidden response
func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) Code() int {
	return 403
}

func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2Forbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2Forbidden  %+v", 403, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QueryCombinedSensorUpdatePoliciesV2Forbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdatePoliciesV2TooManyRequests creates a QueryCombinedSensorUpdatePoliciesV2TooManyRequests with default headers values
func NewQueryCombinedSensorUpdatePoliciesV2TooManyRequests() *QueryCombinedSensorUpdatePoliciesV2TooManyRequests {
	return &QueryCombinedSensorUpdatePoliciesV2TooManyRequests{}
}

/*
QueryCombinedSensorUpdatePoliciesV2TooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QueryCombinedSensorUpdatePoliciesV2TooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query combined sensor update policies v2 too many requests response has a 2xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update policies v2 too many requests response has a 3xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update policies v2 too many requests response has a 4xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query combined sensor update policies v2 too many requests response has a 5xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query combined sensor update policies v2 too many requests response a status code equal to that given
func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query combined sensor update policies v2 too many requests response
func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) Code() int {
	return 429
}

func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2TooManyRequests  %+v", 429, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QueryCombinedSensorUpdatePoliciesV2TooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQueryCombinedSensorUpdatePoliciesV2InternalServerError creates a QueryCombinedSensorUpdatePoliciesV2InternalServerError with default headers values
func NewQueryCombinedSensorUpdatePoliciesV2InternalServerError() *QueryCombinedSensorUpdatePoliciesV2InternalServerError {
	return &QueryCombinedSensorUpdatePoliciesV2InternalServerError{}
}

/*
QueryCombinedSensorUpdatePoliciesV2InternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QueryCombinedSensorUpdatePoliciesV2InternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV2
}

// IsSuccess returns true when this query combined sensor update policies v2 internal server error response has a 2xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query combined sensor update policies v2 internal server error response has a 3xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query combined sensor update policies v2 internal server error response has a 4xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query combined sensor update policies v2 internal server error response has a 5xx status code
func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query combined sensor update policies v2 internal server error response a status code equal to that given
func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query combined sensor update policies v2 internal server error response
func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) Code() int {
	return 500
}

func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/combined/sensor-update/v2][%d] queryCombinedSensorUpdatePoliciesV2InternalServerError  %+v", 500, o.Payload)
}

func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) GetPayload() *models.SensorUpdateRespV2 {
	return o.Payload
}

func (o *QueryCombinedSensorUpdatePoliciesV2InternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV2)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
