// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// QuerySensorUpdateKernelsDistinctReader is a Reader for the QuerySensorUpdateKernelsDistinct structure.
type QuerySensorUpdateKernelsDistinctReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QuerySensorUpdateKernelsDistinctReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQuerySensorUpdateKernelsDistinctOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewQuerySensorUpdateKernelsDistinctBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewQuerySensorUpdateKernelsDistinctForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewQuerySensorUpdateKernelsDistinctTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewQuerySensorUpdateKernelsDistinctInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1] querySensorUpdateKernelsDistinct", response, response.Code())
	}
}

// NewQuerySensorUpdateKernelsDistinctOK creates a QuerySensorUpdateKernelsDistinctOK with default headers values
func NewQuerySensorUpdateKernelsDistinctOK() *QuerySensorUpdateKernelsDistinctOK {
	return &QuerySensorUpdateKernelsDistinctOK{}
}

/*
QuerySensorUpdateKernelsDistinctOK describes a response with status code 200, with default header values.

OK
*/
type QuerySensorUpdateKernelsDistinctOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query sensor update kernels distinct o k response has a 2xx status code
func (o *QuerySensorUpdateKernelsDistinctOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this query sensor update kernels distinct o k response has a 3xx status code
func (o *QuerySensorUpdateKernelsDistinctOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query sensor update kernels distinct o k response has a 4xx status code
func (o *QuerySensorUpdateKernelsDistinctOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this query sensor update kernels distinct o k response has a 5xx status code
func (o *QuerySensorUpdateKernelsDistinctOK) IsServerError() bool {
	return false
}

// IsCode returns true when this query sensor update kernels distinct o k response a status code equal to that given
func (o *QuerySensorUpdateKernelsDistinctOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the query sensor update kernels distinct o k response
func (o *QuerySensorUpdateKernelsDistinctOK) Code() int {
	return 200
}

func (o *QuerySensorUpdateKernelsDistinctOK) Error() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctOK  %+v", 200, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctOK) String() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctOK  %+v", 200, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QuerySensorUpdateKernelsDistinctOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuerySensorUpdateKernelsDistinctBadRequest creates a QuerySensorUpdateKernelsDistinctBadRequest with default headers values
func NewQuerySensorUpdateKernelsDistinctBadRequest() *QuerySensorUpdateKernelsDistinctBadRequest {
	return &QuerySensorUpdateKernelsDistinctBadRequest{}
}

/*
QuerySensorUpdateKernelsDistinctBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type QuerySensorUpdateKernelsDistinctBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query sensor update kernels distinct bad request response has a 2xx status code
func (o *QuerySensorUpdateKernelsDistinctBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query sensor update kernels distinct bad request response has a 3xx status code
func (o *QuerySensorUpdateKernelsDistinctBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query sensor update kernels distinct bad request response has a 4xx status code
func (o *QuerySensorUpdateKernelsDistinctBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this query sensor update kernels distinct bad request response has a 5xx status code
func (o *QuerySensorUpdateKernelsDistinctBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this query sensor update kernels distinct bad request response a status code equal to that given
func (o *QuerySensorUpdateKernelsDistinctBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the query sensor update kernels distinct bad request response
func (o *QuerySensorUpdateKernelsDistinctBadRequest) Code() int {
	return 400
}

func (o *QuerySensorUpdateKernelsDistinctBadRequest) Error() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctBadRequest  %+v", 400, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctBadRequest) String() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctBadRequest  %+v", 400, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QuerySensorUpdateKernelsDistinctBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuerySensorUpdateKernelsDistinctForbidden creates a QuerySensorUpdateKernelsDistinctForbidden with default headers values
func NewQuerySensorUpdateKernelsDistinctForbidden() *QuerySensorUpdateKernelsDistinctForbidden {
	return &QuerySensorUpdateKernelsDistinctForbidden{}
}

/*
QuerySensorUpdateKernelsDistinctForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type QuerySensorUpdateKernelsDistinctForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this query sensor update kernels distinct forbidden response has a 2xx status code
func (o *QuerySensorUpdateKernelsDistinctForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query sensor update kernels distinct forbidden response has a 3xx status code
func (o *QuerySensorUpdateKernelsDistinctForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query sensor update kernels distinct forbidden response has a 4xx status code
func (o *QuerySensorUpdateKernelsDistinctForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this query sensor update kernels distinct forbidden response has a 5xx status code
func (o *QuerySensorUpdateKernelsDistinctForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this query sensor update kernels distinct forbidden response a status code equal to that given
func (o *QuerySensorUpdateKernelsDistinctForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the query sensor update kernels distinct forbidden response
func (o *QuerySensorUpdateKernelsDistinctForbidden) Code() int {
	return 403
}

func (o *QuerySensorUpdateKernelsDistinctForbidden) Error() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctForbidden  %+v", 403, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctForbidden) String() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctForbidden  %+v", 403, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *QuerySensorUpdateKernelsDistinctForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuerySensorUpdateKernelsDistinctTooManyRequests creates a QuerySensorUpdateKernelsDistinctTooManyRequests with default headers values
func NewQuerySensorUpdateKernelsDistinctTooManyRequests() *QuerySensorUpdateKernelsDistinctTooManyRequests {
	return &QuerySensorUpdateKernelsDistinctTooManyRequests{}
}

/*
QuerySensorUpdateKernelsDistinctTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type QuerySensorUpdateKernelsDistinctTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this query sensor update kernels distinct too many requests response has a 2xx status code
func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query sensor update kernels distinct too many requests response has a 3xx status code
func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query sensor update kernels distinct too many requests response has a 4xx status code
func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this query sensor update kernels distinct too many requests response has a 5xx status code
func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this query sensor update kernels distinct too many requests response a status code equal to that given
func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the query sensor update kernels distinct too many requests response
func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) Code() int {
	return 429
}

func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) Error() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctTooManyRequests  %+v", 429, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) String() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctTooManyRequests  %+v", 429, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *QuerySensorUpdateKernelsDistinctTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQuerySensorUpdateKernelsDistinctInternalServerError creates a QuerySensorUpdateKernelsDistinctInternalServerError with default headers values
func NewQuerySensorUpdateKernelsDistinctInternalServerError() *QuerySensorUpdateKernelsDistinctInternalServerError {
	return &QuerySensorUpdateKernelsDistinctInternalServerError{}
}

/*
QuerySensorUpdateKernelsDistinctInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type QuerySensorUpdateKernelsDistinctInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this query sensor update kernels distinct internal server error response has a 2xx status code
func (o *QuerySensorUpdateKernelsDistinctInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this query sensor update kernels distinct internal server error response has a 3xx status code
func (o *QuerySensorUpdateKernelsDistinctInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this query sensor update kernels distinct internal server error response has a 4xx status code
func (o *QuerySensorUpdateKernelsDistinctInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this query sensor update kernels distinct internal server error response has a 5xx status code
func (o *QuerySensorUpdateKernelsDistinctInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this query sensor update kernels distinct internal server error response a status code equal to that given
func (o *QuerySensorUpdateKernelsDistinctInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the query sensor update kernels distinct internal server error response
func (o *QuerySensorUpdateKernelsDistinctInternalServerError) Code() int {
	return 500
}

func (o *QuerySensorUpdateKernelsDistinctInternalServerError) Error() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctInternalServerError  %+v", 500, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctInternalServerError) String() string {
	return fmt.Sprintf("[GET /policy/queries/sensor-update-kernels/{distinct_field}/v1][%d] querySensorUpdateKernelsDistinctInternalServerError  %+v", 500, o.Payload)
}

func (o *QuerySensorUpdateKernelsDistinctInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *QuerySensorUpdateKernelsDistinctInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
