// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// SetSensorUpdatePoliciesPrecedenceReader is a Reader for the SetSensorUpdatePoliciesPrecedence structure.
type SetSensorUpdatePoliciesPrecedenceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SetSensorUpdatePoliciesPrecedenceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSetSensorUpdatePoliciesPrecedenceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewSetSensorUpdatePoliciesPrecedenceBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewSetSensorUpdatePoliciesPrecedenceForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewSetSensorUpdatePoliciesPrecedenceTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSetSensorUpdatePoliciesPrecedenceInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /policy/entities/sensor-update-precedence/v1] setSensorUpdatePoliciesPrecedence", response, response.Code())
	}
}

// NewSetSensorUpdatePoliciesPrecedenceOK creates a SetSensorUpdatePoliciesPrecedenceOK with default headers values
func NewSetSensorUpdatePoliciesPrecedenceOK() *SetSensorUpdatePoliciesPrecedenceOK {
	return &SetSensorUpdatePoliciesPrecedenceOK{}
}

/*
SetSensorUpdatePoliciesPrecedenceOK describes a response with status code 200, with default header values.

OK
*/
type SetSensorUpdatePoliciesPrecedenceOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this set sensor update policies precedence o k response has a 2xx status code
func (o *SetSensorUpdatePoliciesPrecedenceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this set sensor update policies precedence o k response has a 3xx status code
func (o *SetSensorUpdatePoliciesPrecedenceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set sensor update policies precedence o k response has a 4xx status code
func (o *SetSensorUpdatePoliciesPrecedenceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this set sensor update policies precedence o k response has a 5xx status code
func (o *SetSensorUpdatePoliciesPrecedenceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this set sensor update policies precedence o k response a status code equal to that given
func (o *SetSensorUpdatePoliciesPrecedenceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the set sensor update policies precedence o k response
func (o *SetSensorUpdatePoliciesPrecedenceOK) Code() int {
	return 200
}

func (o *SetSensorUpdatePoliciesPrecedenceOK) Error() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceOK  %+v", 200, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceOK) String() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceOK  %+v", 200, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceOK) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *SetSensorUpdatePoliciesPrecedenceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetSensorUpdatePoliciesPrecedenceBadRequest creates a SetSensorUpdatePoliciesPrecedenceBadRequest with default headers values
func NewSetSensorUpdatePoliciesPrecedenceBadRequest() *SetSensorUpdatePoliciesPrecedenceBadRequest {
	return &SetSensorUpdatePoliciesPrecedenceBadRequest{}
}

/*
SetSensorUpdatePoliciesPrecedenceBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type SetSensorUpdatePoliciesPrecedenceBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this set sensor update policies precedence bad request response has a 2xx status code
func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set sensor update policies precedence bad request response has a 3xx status code
func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set sensor update policies precedence bad request response has a 4xx status code
func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this set sensor update policies precedence bad request response has a 5xx status code
func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this set sensor update policies precedence bad request response a status code equal to that given
func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the set sensor update policies precedence bad request response
func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) Code() int {
	return 400
}

func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) Error() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceBadRequest  %+v", 400, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) String() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceBadRequest  %+v", 400, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *SetSensorUpdatePoliciesPrecedenceBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetSensorUpdatePoliciesPrecedenceForbidden creates a SetSensorUpdatePoliciesPrecedenceForbidden with default headers values
func NewSetSensorUpdatePoliciesPrecedenceForbidden() *SetSensorUpdatePoliciesPrecedenceForbidden {
	return &SetSensorUpdatePoliciesPrecedenceForbidden{}
}

/*
SetSensorUpdatePoliciesPrecedenceForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type SetSensorUpdatePoliciesPrecedenceForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this set sensor update policies precedence forbidden response has a 2xx status code
func (o *SetSensorUpdatePoliciesPrecedenceForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set sensor update policies precedence forbidden response has a 3xx status code
func (o *SetSensorUpdatePoliciesPrecedenceForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set sensor update policies precedence forbidden response has a 4xx status code
func (o *SetSensorUpdatePoliciesPrecedenceForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this set sensor update policies precedence forbidden response has a 5xx status code
func (o *SetSensorUpdatePoliciesPrecedenceForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this set sensor update policies precedence forbidden response a status code equal to that given
func (o *SetSensorUpdatePoliciesPrecedenceForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the set sensor update policies precedence forbidden response
func (o *SetSensorUpdatePoliciesPrecedenceForbidden) Code() int {
	return 403
}

func (o *SetSensorUpdatePoliciesPrecedenceForbidden) Error() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceForbidden  %+v", 403, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceForbidden) String() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceForbidden  %+v", 403, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *SetSensorUpdatePoliciesPrecedenceForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetSensorUpdatePoliciesPrecedenceTooManyRequests creates a SetSensorUpdatePoliciesPrecedenceTooManyRequests with default headers values
func NewSetSensorUpdatePoliciesPrecedenceTooManyRequests() *SetSensorUpdatePoliciesPrecedenceTooManyRequests {
	return &SetSensorUpdatePoliciesPrecedenceTooManyRequests{}
}

/*
SetSensorUpdatePoliciesPrecedenceTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type SetSensorUpdatePoliciesPrecedenceTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this set sensor update policies precedence too many requests response has a 2xx status code
func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set sensor update policies precedence too many requests response has a 3xx status code
func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set sensor update policies precedence too many requests response has a 4xx status code
func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this set sensor update policies precedence too many requests response has a 5xx status code
func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this set sensor update policies precedence too many requests response a status code equal to that given
func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the set sensor update policies precedence too many requests response
func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) Code() int {
	return 429
}

func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceTooManyRequests  %+v", 429, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) String() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceTooManyRequests  %+v", 429, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *SetSensorUpdatePoliciesPrecedenceTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetSensorUpdatePoliciesPrecedenceInternalServerError creates a SetSensorUpdatePoliciesPrecedenceInternalServerError with default headers values
func NewSetSensorUpdatePoliciesPrecedenceInternalServerError() *SetSensorUpdatePoliciesPrecedenceInternalServerError {
	return &SetSensorUpdatePoliciesPrecedenceInternalServerError{}
}

/*
SetSensorUpdatePoliciesPrecedenceInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type SetSensorUpdatePoliciesPrecedenceInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaQueryResponse
}

// IsSuccess returns true when this set sensor update policies precedence internal server error response has a 2xx status code
func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this set sensor update policies precedence internal server error response has a 3xx status code
func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set sensor update policies precedence internal server error response has a 4xx status code
func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this set sensor update policies precedence internal server error response has a 5xx status code
func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this set sensor update policies precedence internal server error response a status code equal to that given
func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the set sensor update policies precedence internal server error response
func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) Code() int {
	return 500
}

func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) Error() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceInternalServerError  %+v", 500, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) String() string {
	return fmt.Sprintf("[POST /policy/entities/sensor-update-precedence/v1][%d] setSensorUpdatePoliciesPrecedenceInternalServerError  %+v", 500, o.Payload)
}

func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) GetPayload() *models.MsaQueryResponse {
	return o.Payload
}

func (o *SetSensorUpdatePoliciesPrecedenceInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaQueryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
