// Code generated by go-swagger; DO NOT EDIT.

package sensor_update_policies

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/crowdstrike/gofalcon/falcon/models"
)

// UpdateSensorUpdatePoliciesReader is a Reader for the UpdateSensorUpdatePolicies structure.
type UpdateSensorUpdatePoliciesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateSensorUpdatePoliciesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateSensorUpdatePoliciesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateSensorUpdatePoliciesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateSensorUpdatePoliciesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateSensorUpdatePoliciesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 429:
		result := NewUpdateSensorUpdatePoliciesTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateSensorUpdatePoliciesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PATCH /policy/entities/sensor-update/v1] updateSensorUpdatePolicies", response, response.Code())
	}
}

// NewUpdateSensorUpdatePoliciesOK creates a UpdateSensorUpdatePoliciesOK with default headers values
func NewUpdateSensorUpdatePoliciesOK() *UpdateSensorUpdatePoliciesOK {
	return &UpdateSensorUpdatePoliciesOK{}
}

/*
UpdateSensorUpdatePoliciesOK describes a response with status code 200, with default header values.

OK
*/
type UpdateSensorUpdatePoliciesOK struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV1
}

// IsSuccess returns true when this update sensor update policies o k response has a 2xx status code
func (o *UpdateSensorUpdatePoliciesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update sensor update policies o k response has a 3xx status code
func (o *UpdateSensorUpdatePoliciesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor update policies o k response has a 4xx status code
func (o *UpdateSensorUpdatePoliciesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update sensor update policies o k response has a 5xx status code
func (o *UpdateSensorUpdatePoliciesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor update policies o k response a status code equal to that given
func (o *UpdateSensorUpdatePoliciesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update sensor update policies o k response
func (o *UpdateSensorUpdatePoliciesOK) Code() int {
	return 200
}

func (o *UpdateSensorUpdatePoliciesOK) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesOK  %+v", 200, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesOK) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesOK  %+v", 200, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesOK) GetPayload() *models.SensorUpdateRespV1 {
	return o.Payload
}

func (o *UpdateSensorUpdatePoliciesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorUpdatePoliciesBadRequest creates a UpdateSensorUpdatePoliciesBadRequest with default headers values
func NewUpdateSensorUpdatePoliciesBadRequest() *UpdateSensorUpdatePoliciesBadRequest {
	return &UpdateSensorUpdatePoliciesBadRequest{}
}

/*
UpdateSensorUpdatePoliciesBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type UpdateSensorUpdatePoliciesBadRequest struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV1
}

// IsSuccess returns true when this update sensor update policies bad request response has a 2xx status code
func (o *UpdateSensorUpdatePoliciesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor update policies bad request response has a 3xx status code
func (o *UpdateSensorUpdatePoliciesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor update policies bad request response has a 4xx status code
func (o *UpdateSensorUpdatePoliciesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update sensor update policies bad request response has a 5xx status code
func (o *UpdateSensorUpdatePoliciesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor update policies bad request response a status code equal to that given
func (o *UpdateSensorUpdatePoliciesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update sensor update policies bad request response
func (o *UpdateSensorUpdatePoliciesBadRequest) Code() int {
	return 400
}

func (o *UpdateSensorUpdatePoliciesBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesBadRequest) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesBadRequest  %+v", 400, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesBadRequest) GetPayload() *models.SensorUpdateRespV1 {
	return o.Payload
}

func (o *UpdateSensorUpdatePoliciesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorUpdatePoliciesForbidden creates a UpdateSensorUpdatePoliciesForbidden with default headers values
func NewUpdateSensorUpdatePoliciesForbidden() *UpdateSensorUpdatePoliciesForbidden {
	return &UpdateSensorUpdatePoliciesForbidden{}
}

/*
UpdateSensorUpdatePoliciesForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type UpdateSensorUpdatePoliciesForbidden struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.MsaErrorsOnly
}

// IsSuccess returns true when this update sensor update policies forbidden response has a 2xx status code
func (o *UpdateSensorUpdatePoliciesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor update policies forbidden response has a 3xx status code
func (o *UpdateSensorUpdatePoliciesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor update policies forbidden response has a 4xx status code
func (o *UpdateSensorUpdatePoliciesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update sensor update policies forbidden response has a 5xx status code
func (o *UpdateSensorUpdatePoliciesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor update policies forbidden response a status code equal to that given
func (o *UpdateSensorUpdatePoliciesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update sensor update policies forbidden response
func (o *UpdateSensorUpdatePoliciesForbidden) Code() int {
	return 403
}

func (o *UpdateSensorUpdatePoliciesForbidden) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesForbidden) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesForbidden  %+v", 403, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesForbidden) GetPayload() *models.MsaErrorsOnly {
	return o.Payload
}

func (o *UpdateSensorUpdatePoliciesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.MsaErrorsOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorUpdatePoliciesNotFound creates a UpdateSensorUpdatePoliciesNotFound with default headers values
func NewUpdateSensorUpdatePoliciesNotFound() *UpdateSensorUpdatePoliciesNotFound {
	return &UpdateSensorUpdatePoliciesNotFound{}
}

/*
UpdateSensorUpdatePoliciesNotFound describes a response with status code 404, with default header values.

Not Found
*/
type UpdateSensorUpdatePoliciesNotFound struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV1
}

// IsSuccess returns true when this update sensor update policies not found response has a 2xx status code
func (o *UpdateSensorUpdatePoliciesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor update policies not found response has a 3xx status code
func (o *UpdateSensorUpdatePoliciesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor update policies not found response has a 4xx status code
func (o *UpdateSensorUpdatePoliciesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update sensor update policies not found response has a 5xx status code
func (o *UpdateSensorUpdatePoliciesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor update policies not found response a status code equal to that given
func (o *UpdateSensorUpdatePoliciesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update sensor update policies not found response
func (o *UpdateSensorUpdatePoliciesNotFound) Code() int {
	return 404
}

func (o *UpdateSensorUpdatePoliciesNotFound) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesNotFound) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesNotFound  %+v", 404, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesNotFound) GetPayload() *models.SensorUpdateRespV1 {
	return o.Payload
}

func (o *UpdateSensorUpdatePoliciesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorUpdatePoliciesTooManyRequests creates a UpdateSensorUpdatePoliciesTooManyRequests with default headers values
func NewUpdateSensorUpdatePoliciesTooManyRequests() *UpdateSensorUpdatePoliciesTooManyRequests {
	return &UpdateSensorUpdatePoliciesTooManyRequests{}
}

/*
UpdateSensorUpdatePoliciesTooManyRequests describes a response with status code 429, with default header values.

Too Many Requests
*/
type UpdateSensorUpdatePoliciesTooManyRequests struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	/* Too many requests, retry after this time (as milliseconds since epoch)
	 */
	XRateLimitRetryAfter int64

	Payload *models.MsaReplyMetaOnly
}

// IsSuccess returns true when this update sensor update policies too many requests response has a 2xx status code
func (o *UpdateSensorUpdatePoliciesTooManyRequests) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor update policies too many requests response has a 3xx status code
func (o *UpdateSensorUpdatePoliciesTooManyRequests) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor update policies too many requests response has a 4xx status code
func (o *UpdateSensorUpdatePoliciesTooManyRequests) IsClientError() bool {
	return true
}

// IsServerError returns true when this update sensor update policies too many requests response has a 5xx status code
func (o *UpdateSensorUpdatePoliciesTooManyRequests) IsServerError() bool {
	return false
}

// IsCode returns true when this update sensor update policies too many requests response a status code equal to that given
func (o *UpdateSensorUpdatePoliciesTooManyRequests) IsCode(code int) bool {
	return code == 429
}

// Code gets the status code for the update sensor update policies too many requests response
func (o *UpdateSensorUpdatePoliciesTooManyRequests) Code() int {
	return 429
}

func (o *UpdateSensorUpdatePoliciesTooManyRequests) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesTooManyRequests) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesTooManyRequests  %+v", 429, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesTooManyRequests) GetPayload() *models.MsaReplyMetaOnly {
	return o.Payload
}

func (o *UpdateSensorUpdatePoliciesTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	// hydrates response header X-RateLimit-RetryAfter
	hdrXRateLimitRetryAfter := response.GetHeader("X-RateLimit-RetryAfter")

	if hdrXRateLimitRetryAfter != "" {
		valxRateLimitRetryAfter, err := swag.ConvertInt64(hdrXRateLimitRetryAfter)
		if err != nil {
			return errors.InvalidType("X-RateLimit-RetryAfter", "header", "int64", hdrXRateLimitRetryAfter)
		}
		o.XRateLimitRetryAfter = valxRateLimitRetryAfter
	}

	o.Payload = new(models.MsaReplyMetaOnly)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateSensorUpdatePoliciesInternalServerError creates a UpdateSensorUpdatePoliciesInternalServerError with default headers values
func NewUpdateSensorUpdatePoliciesInternalServerError() *UpdateSensorUpdatePoliciesInternalServerError {
	return &UpdateSensorUpdatePoliciesInternalServerError{}
}

/*
UpdateSensorUpdatePoliciesInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type UpdateSensorUpdatePoliciesInternalServerError struct {

	/* Trace-ID: submit to support if resolving an issue
	 */
	XCSTRACEID string

	/* Request limit per minute.
	 */
	XRateLimitLimit int64

	/* The number of requests remaining for the sliding one minute window.
	 */
	XRateLimitRemaining int64

	Payload *models.SensorUpdateRespV1
}

// IsSuccess returns true when this update sensor update policies internal server error response has a 2xx status code
func (o *UpdateSensorUpdatePoliciesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update sensor update policies internal server error response has a 3xx status code
func (o *UpdateSensorUpdatePoliciesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update sensor update policies internal server error response has a 4xx status code
func (o *UpdateSensorUpdatePoliciesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update sensor update policies internal server error response has a 5xx status code
func (o *UpdateSensorUpdatePoliciesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update sensor update policies internal server error response a status code equal to that given
func (o *UpdateSensorUpdatePoliciesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update sensor update policies internal server error response
func (o *UpdateSensorUpdatePoliciesInternalServerError) Code() int {
	return 500
}

func (o *UpdateSensorUpdatePoliciesInternalServerError) Error() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesInternalServerError) String() string {
	return fmt.Sprintf("[PATCH /policy/entities/sensor-update/v1][%d] updateSensorUpdatePoliciesInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateSensorUpdatePoliciesInternalServerError) GetPayload() *models.SensorUpdateRespV1 {
	return o.Payload
}

func (o *UpdateSensorUpdatePoliciesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-CS-TRACEID
	hdrXCSTRACEID := response.GetHeader("X-CS-TRACEID")

	if hdrXCSTRACEID != "" {
		o.XCSTRACEID = hdrXCSTRACEID
	}

	// hydrates response header X-RateLimit-Limit
	hdrXRateLimitLimit := response.GetHeader("X-RateLimit-Limit")

	if hdrXRateLimitLimit != "" {
		valxRateLimitLimit, err := swag.ConvertInt64(hdrXRateLimitLimit)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Limit", "header", "int64", hdrXRateLimitLimit)
		}
		o.XRateLimitLimit = valxRateLimitLimit
	}

	// hydrates response header X-RateLimit-Remaining
	hdrXRateLimitRemaining := response.GetHeader("X-RateLimit-Remaining")

	if hdrXRateLimitRemaining != "" {
		valxRateLimitRemaining, err := swag.ConvertInt64(hdrXRateLimitRemaining)
		if err != nil {
			return errors.InvalidType("X-RateLimit-Remaining", "header", "int64", hdrXRateLimitRemaining)
		}
		o.XRateLimitRemaining = valxRateLimitRemaining
	}

	o.Payload = new(models.SensorUpdateRespV1)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
